/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import com.github.wnameless.json.base.JacksonJsonCore;
import com.github.wnameless.json.base.JsonCore;
import com.github.wnameless.json.base.JsonValueBase;
import com.github.wnameless.json.flattener.CharSequenceTranslatorFactory;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.IndexedPeekIterator;
import com.github.wnameless.json.flattener.JsonifyArrayList;
import com.github.wnameless.json.flattener.JsonifyLinkedHashMap;
import com.github.wnameless.json.flattener.KeyTransformer;
import com.github.wnameless.json.flattener.PrintMode;
import com.github.wnameless.json.flattener.StringEscapePolicy;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class JsonFlattener {
    public static final String ROOT = "root";
    private final JsonCore<?> jsonCore;
    private final Deque<IndexedPeekIterator<?>> elementIters = new ArrayDeque();
    private final JsonValueBase<?> source;
    private JsonifyLinkedHashMap<String, Object> flattenedMap;
    private FlattenMode flattenMode = FlattenMode.NORMAL;
    private CharSequenceTranslatorFactory policy = StringEscapePolicy.DEFAULT;
    private Character separator = Character.valueOf('.');
    private Character leftBracket = Character.valueOf('[');
    private Character rightBracket = Character.valueOf(']');
    private PrintMode printMode = PrintMode.MINIMAL;
    private KeyTransformer keyTrans = null;
    private boolean ignoreReservedCharacters = false;

    public static String flatten(JsonValueBase<?> jsonVal) {
        return new JsonFlattener(jsonVal).flatten();
    }

    public static String flatten(String json) {
        return new JsonFlattener(json).flatten();
    }

    public static Map<String, Object> flattenAsMap(JsonValueBase<?> jsonVal) {
        return new JsonFlattener(jsonVal).flattenAsMap();
    }

    public static Map<String, Object> flattenAsMap(String json) {
        return new JsonFlattener(json).flattenAsMap();
    }

    private JsonFlattener newJsonFlattener(JsonValueBase<?> jsonVal) {
        JsonFlattener jf = new JsonFlattener(jsonVal);
        jf.withFlattenMode(this.flattenMode);
        jf.withStringEscapePolicy(this.policy);
        jf.withSeparator(this.separator.charValue());
        jf.withLeftAndRightBrackets(this.leftBracket.charValue(), this.rightBracket.charValue());
        jf.withPrintMode(this.printMode);
        jf.withKeyTransformer(this.keyTrans);
        if (this.ignoreReservedCharacters) {
            jf.ignoreReservedCharacters();
        }
        return jf;
    }

    public JsonFlattener(JsonValueBase<?> json) {
        this.jsonCore = new JacksonJsonCore();
        this.source = Validate.notNull(json);
    }

    public JsonFlattener(JsonCore<?> jsonCore, JsonValueBase<?> json) {
        this.jsonCore = Validate.notNull(jsonCore);
        this.source = jsonCore.parse(json.toJson());
    }

    public JsonFlattener(String json) {
        this.jsonCore = new JacksonJsonCore();
        this.source = this.jsonCore.parse(json);
    }

    public JsonFlattener(JsonCore<?> jsonCore, String json) {
        this.jsonCore = Validate.notNull(jsonCore);
        this.source = jsonCore.parse(json);
    }

    public JsonFlattener(Reader jsonReader) throws IOException {
        this.jsonCore = new JacksonJsonCore();
        this.source = this.jsonCore.parse(jsonReader);
    }

    public JsonFlattener(JsonCore<?> jsonCore, Reader jsonReader) throws IOException {
        this.jsonCore = Validate.notNull(jsonCore);
        this.source = jsonCore.parse(jsonReader);
    }

    public JsonFlattener withFlattenMode(FlattenMode flattenMode) {
        this.flattenMode = Validate.notNull(flattenMode);
        this.flattenedMap = null;
        return this;
    }

    public JsonFlattener withStringEscapePolicy(CharSequenceTranslatorFactory policy) {
        this.policy = Validate.notNull(policy);
        this.flattenedMap = null;
        return this;
    }

    public JsonFlattener withSeparator(char separator) {
        String separatorStr = String.valueOf(separator);
        Validate.isTrue(!separatorStr.matches("[\"\\s]"), "Separator contains illegal character(%s)", separatorStr);
        Validate.isTrue(!this.leftBracket.equals(Character.valueOf(separator)) && !this.rightBracket.equals(Character.valueOf(separator)), "Separator(%s) is already used in brackets", separatorStr);
        this.separator = Character.valueOf(separator);
        this.flattenedMap = null;
        return this;
    }

    private String illegalBracketsRegex() {
        return "[\"\\s" + Pattern.quote(this.separator.toString()) + "]";
    }

    public JsonFlattener withLeftAndRightBrackets(char leftBracket, char rightBracket) {
        Validate.isTrue(leftBracket != rightBracket, "Both brackets cannot be the same", new Object[0]);
        String leftBracketStr = String.valueOf(leftBracket);
        String rightBracketStr = String.valueOf(rightBracket);
        Validate.isTrue(!leftBracketStr.matches(this.illegalBracketsRegex()), "Left bracket contains illegal character(%s)", leftBracketStr);
        Validate.isTrue(!rightBracketStr.matches(this.illegalBracketsRegex()), "Right bracket contains illegal character(%s)", rightBracketStr);
        this.leftBracket = Character.valueOf(leftBracket);
        this.rightBracket = Character.valueOf(rightBracket);
        this.flattenedMap = null;
        return this;
    }

    public JsonFlattener withPrintMode(PrintMode printMode) {
        this.printMode = Validate.notNull(printMode);
        return this;
    }

    public JsonFlattener withKeyTransformer(KeyTransformer keyTrans) {
        this.keyTrans = keyTrans;
        this.flattenedMap = null;
        return this;
    }

    public JsonFlattener ignoreReservedCharacters() {
        this.ignoreReservedCharacters = true;
        return this;
    }

    public String flatten() {
        this.flattenAsMap();
        if (this.source.isObject() || this.isObjectifiableArray()) {
            return this.flattenedMap.toString(this.printMode);
        }
        return this.javaObj2Json(this.flattenedMap.get(ROOT));
    }

    private boolean isObjectifiableArray() {
        return this.source.isArray() && !this.flattenedMap.containsKey(ROOT);
    }

    private String javaObj2Json(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof CharSequence) {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            sb.append(this.policy.getCharSequenceTranslator().translate((CharSequence)obj));
            sb.append('\"');
            return sb.toString();
        }
        if (obj instanceof JsonifyArrayList) {
            JsonifyArrayList list = (JsonifyArrayList)obj;
            return list.toString(this.printMode);
        }
        return obj.toString();
    }

    public Map<String, Object> flattenAsMap() {
        if (this.flattenedMap != null) {
            return this.flattenedMap;
        }
        this.flattenedMap = this.newJsonifyLinkedHashMap();
        this.reduce(this.source);
        while (!this.elementIters.isEmpty()) {
            IndexedPeekIterator<?> deepestIter = this.elementIters.getLast();
            if (!deepestIter.hasNext()) {
                this.elementIters.removeLast();
                continue;
            }
            if (deepestIter.peek() instanceof Map.Entry) {
                Map.Entry mem = (Map.Entry)deepestIter.next();
                this.reduce((JsonValueBase)mem.getValue());
                continue;
            }
            JsonValueBase val = (JsonValueBase)deepestIter.next();
            this.reduce(val);
        }
        return this.flattenedMap;
    }

    private void reduce(JsonValueBase<?> val) {
        if (val.isObject() && val.asObject().iterator().hasNext()) {
            this.elementIters.add(IndexedPeekIterator.newIndexedPeekIterator(val.asObject()));
        } else if (val.isArray() && val.asArray().iterator().hasNext()) {
            switch (this.flattenMode) {
                case KEEP_PRIMITIVE_ARRAYS: {
                    boolean allPrimitive = true;
                    for (JsonValueBase value : val.asArray()) {
                        if (!value.isArray() && !value.isObject()) continue;
                        allPrimitive = false;
                        break;
                    }
                    if (allPrimitive) {
                        JsonifyArrayList array = this.newJsonifyArrayList();
                        for (JsonValueBase value : val.asArray()) {
                            array.add(this.jsonVal2Obj(value));
                        }
                        this.flattenedMap.put(this.computeKey(), array);
                        break;
                    }
                    this.elementIters.add(IndexedPeekIterator.newIndexedPeekIterator(val.asArray()));
                    break;
                }
                case KEEP_ARRAYS: {
                    JsonifyArrayList array = this.newJsonifyArrayList();
                    for (JsonValueBase value : val.asArray()) {
                        array.add(this.jsonVal2Obj(value));
                    }
                    this.flattenedMap.put(this.computeKey(), array);
                    break;
                }
                default: {
                    this.elementIters.add(IndexedPeekIterator.newIndexedPeekIterator(val.asArray()));
                    break;
                }
            }
        } else {
            String key = this.computeKey();
            Object value = this.jsonVal2Obj(val);
            if (!ROOT.equals(key) || !Collections.EMPTY_MAP.equals(value)) {
                this.flattenedMap.put(key, value);
            }
        }
    }

    private Object jsonVal2Obj(JsonValueBase<?> val) {
        if (val.isBoolean()) {
            return val.asBoolean();
        }
        if (val.isString()) {
            return val.asString();
        }
        if (val.isNumber()) {
            return val.asNumber();
        }
        switch (this.flattenMode) {
            case KEEP_ARRAYS: {
                if (val.isArray()) {
                    JsonifyArrayList array = this.newJsonifyArrayList();
                    for (JsonValueBase value : val.asArray()) {
                        array.add(this.jsonVal2Obj(value));
                    }
                    return array;
                }
                if (!val.isObject()) break;
                if (val.asObject().iterator().hasNext()) {
                    return this.newJsonFlattener(val).flattenAsMap();
                }
                return this.newJsonifyLinkedHashMap();
            }
        }
        if (val.isArray()) {
            return this.newJsonifyArrayList();
        }
        if (val.isObject()) {
            return this.newJsonifyLinkedHashMap();
        }
        return null;
    }

    private boolean hasReservedCharacters(String key) {
        if (this.flattenMode.equals((Object)FlattenMode.MONGODB) && StringUtils.containsAny((CharSequence)key, this.separator.charValue())) {
            throw new IllegalArgumentException("Key cannot contain separator(" + this.separator + ") in FlattenMode." + (Object)((Object)FlattenMode.MONGODB));
        }
        return StringUtils.containsAny((CharSequence)key, this.separator.charValue(), this.leftBracket.charValue(), this.rightBracket.charValue());
    }

    private String computeKey() {
        if (this.elementIters.isEmpty()) {
            return ROOT;
        }
        StringBuilder sb = new StringBuilder();
        for (IndexedPeekIterator<?> iter : this.elementIters) {
            if (iter.getCurrent() instanceof Map.Entry) {
                String key = (String)((Map.Entry)iter.getCurrent()).getKey();
                if (this.keyTrans != null) {
                    key = this.keyTrans.transform(key);
                }
                if (!this.ignoreReservedCharacters && this.hasReservedCharacters(key)) {
                    sb.append(this.leftBracket);
                    sb.append('\"');
                    sb.append(key);
                    sb.append('\"');
                    sb.append(this.rightBracket);
                    continue;
                }
                if (sb.length() != 0) {
                    sb.append(this.separator);
                }
                sb.append(key);
                continue;
            }
            sb.append(this.flattenMode.equals((Object)FlattenMode.MONGODB) ? this.separator : this.leftBracket);
            sb.append(iter.getIndex());
            sb.append(this.flattenMode.equals((Object)FlattenMode.MONGODB) ? "" : this.rightBracket);
        }
        return sb.toString();
    }

    private <T> JsonifyArrayList<T> newJsonifyArrayList() {
        JsonifyArrayList array = new JsonifyArrayList();
        array.setTranslator(this.policy.getCharSequenceTranslator());
        return array;
    }

    private <K, V> JsonifyLinkedHashMap<K, V> newJsonifyLinkedHashMap() {
        JsonifyLinkedHashMap map = new JsonifyLinkedHashMap();
        map.setTranslator(this.policy.getCharSequenceTranslator());
        return map;
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonFlattener)) {
            return false;
        }
        return this.source.equals(((JsonFlattener)o).source);
    }

    public String toString() {
        return "JsonFlattener{source=" + this.source + "}";
    }
}

