/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.msgsimple.provider;

import com.github.fge.msgsimple.InternalBundle;
import com.github.fge.msgsimple.provider.MessageSourceLoader;
import com.github.fge.msgsimple.provider.MessageSourceProvider;
import com.github.fge.msgsimple.source.MessageSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LoadingMessageSourceProvider
implements MessageSourceProvider {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread ret = this.factory.newThread(r);
            ret.setDaemon(true);
            return ret;
        }
    };
    private static final InternalBundle BUNDLE = InternalBundle.getInstance();
    private static final int NTHREADS = 3;
    private final ExecutorService service = Executors.newFixedThreadPool(3, THREAD_FACTORY);
    private final MessageSourceLoader loader;
    private final MessageSource defaultSource;
    private final long timeoutDuration;
    private final TimeUnit timeoutUnit;
    private final AtomicBoolean expiryEnabled;
    private final long expiryDuration;
    private final TimeUnit expiryUnit;
    private final Map<Locale, FutureTask<MessageSource>> sources = new HashMap<Locale, FutureTask<MessageSource>>();

    private LoadingMessageSourceProvider(Builder builder) {
        this.loader = builder.loader;
        this.defaultSource = builder.defaultSource;
        this.timeoutDuration = builder.timeoutDuration;
        this.timeoutUnit = builder.timeoutUnit;
        this.expiryDuration = builder.expiryDuration;
        this.expiryUnit = builder.expiryUnit;
        this.expiryEnabled = new AtomicBoolean(this.expiryDuration == 0L);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageSource getMessageSource(Locale locale) {
        FutureTask<MessageSource> task;
        if (!this.expiryEnabled.getAndSet(true)) {
            this.setupExpiry(this.expiryDuration, this.expiryUnit);
        }
        Map<Locale, FutureTask<MessageSource>> map = this.sources;
        synchronized (map) {
            task = this.sources.get(locale);
            if (task == null) {
                task = this.loadingTask(locale);
                this.sources.put(locale, task);
                this.service.execute(task);
            }
        }
        try {
            MessageSource source2 = task.get(this.timeoutDuration, this.timeoutUnit);
            return source2 == null ? this.defaultSource : source2;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return this.defaultSource;
        }
        catch (ExecutionException ignored) {
            return this.defaultSource;
        }
        catch (TimeoutException ignored) {
            return this.defaultSource;
        }
        catch (CancellationException ignored) {
            return this.defaultSource;
        }
    }

    private FutureTask<MessageSource> loadingTask(final Locale locale) {
        return new FutureTask<MessageSource>(new Callable<MessageSource>(){

            @Override
            public MessageSource call() throws IOException {
                return LoadingMessageSourceProvider.this.loader.load(locale);
            }
        });
    }

    private void setupExpiry(long duration, TimeUnit unit) {
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList tasks;
                Map map = LoadingMessageSourceProvider.this.sources;
                synchronized (map) {
                    tasks = new ArrayList(LoadingMessageSourceProvider.this.sources.values());
                    LoadingMessageSourceProvider.this.sources.clear();
                }
                for (FutureTask task : tasks) {
                    task.cancel(true);
                }
            }
        };
        ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1, THREAD_FACTORY);
        scheduled.scheduleAtFixedRate(runnable2, duration, duration, unit);
    }

    public static final class Builder {
        private MessageSourceLoader loader;
        private MessageSource defaultSource;
        private long timeoutDuration = 1L;
        private TimeUnit timeoutUnit = TimeUnit.SECONDS;
        private long expiryDuration = 10L;
        private TimeUnit expiryUnit = TimeUnit.MINUTES;

        private Builder() {
        }

        public Builder setLoader(MessageSourceLoader loader) {
            BUNDLE.checkNotNull(loader, "cfg.nullLoader");
            this.loader = loader;
            return this;
        }

        public Builder setDefaultSource(MessageSource defaultSource) {
            BUNDLE.checkNotNull(defaultSource, "cfg.nullDefaultSource");
            this.defaultSource = defaultSource;
            return this;
        }

        public Builder setLoadTimeout(long duration, TimeUnit unit) {
            BUNDLE.checkArgument(duration > 0L, "cfg.nonPositiveDuration");
            BUNDLE.checkNotNull(unit, "cfg.nullTimeUnit");
            this.timeoutDuration = duration;
            this.timeoutUnit = unit;
            return this;
        }

        public Builder setExpiryTime(long duration, TimeUnit unit) {
            BUNDLE.checkArgument(duration > 0L, "cfg.nonPositiveDuration");
            BUNDLE.checkNotNull(unit, "cfg.nullTimeUnit");
            this.expiryDuration = duration;
            this.expiryUnit = unit;
            return this;
        }

        public Builder neverExpires() {
            this.expiryDuration = 0L;
            return this;
        }

        public MessageSourceProvider build() {
            BUNDLE.checkArgument(this.loader != null, "cfg.noLoader");
            return new LoadingMessageSourceProvider(this);
        }
    }
}

