/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.mergepatch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import com.github.fge.jsonpatch.mergepatch.NonObjectMergePatch;
import com.github.fge.jsonpatch.mergepatch.ObjectMergePatch;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

final class JsonMergePatchDeserializer
extends JsonDeserializer<JsonMergePatch> {
    private static final ObjectCodec CODEC = JacksonUtils.newMapper();

    JsonMergePatchDeserializer() {
    }

    @Override
    public JsonMergePatch deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        jp.setCodec(CODEC);
        JsonNode node = (JsonNode)jp.readValueAsTree();
        if (!node.isObject()) {
            return new NonObjectMergePatch(node);
        }
        HashSet<String> removedMembers = new HashSet<String>();
        HashMap<String, JsonMergePatch> modifiedMembers = new HashMap<String, JsonMergePatch>();
        Iterator<Map.Entry<String, JsonNode>> iterator2 = node.fields();
        while (iterator2.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator2.next();
            if (entry.getValue().isNull()) {
                removedMembers.add(entry.getKey());
                continue;
            }
            JsonMergePatch value = this.deserialize(entry.getValue().traverse(), ctxt);
            modifiedMembers.put(entry.getKey(), value);
        }
        return new ObjectMergePatch(removedMembers, modifiedMembers);
    }

    @Override
    public JsonMergePatch getNullValue() {
        return new NonObjectMergePatch(NullNode.getInstance());
    }
}

