/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.resolution.retransform.api.AttributeTransformationResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonIgnoreProperties(value={"drop", "dropAll", "droppedAttribute"}, allowGetters=true)
@JsonPropertyOrder(value={"initial"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TransformationResults {
    private final Map<String, AttributeTransformationResult> attributeTransformationResults;
    private final Map<String, Collection<String>> transformedAttributes;
    private final Map<String, List<String>> initial = Collections.emptyMap();

    public static TransformationResults createEmptyNonDrop() {
        return new TransformationResults(Collections.emptyMap(), Collections.emptyMap());
    }

    public static TransformationResults create() {
        return new TransformationResults(null, null);
    }

    public static TransformationResults create(String key, AttributeTransformationResult transformerChainResult) {
        return TransformationResults.create(Collections.singletonMap(key, transformerChainResult));
    }

    public static TransformationResults create(Map<String, AttributeTransformationResult> transformerChainResults) {
        return new TransformationResults(transformerChainResults, null);
    }

    public static TransformationResults createPassthrough(@Nullable Map<String, ?> connectorAttributes, @Nullable Map<String, ?> auxAttributes) {
        if (connectorAttributes == null && auxAttributes == null) {
            return TransformationResults.createEmptyNonDrop();
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        TransformationResults.fillResultMap(connectorAttributes, result);
        TransformationResults.fillResultMap(auxAttributes, result);
        return new TransformationResults(null, result);
    }

    private static void fillResultMap(@Nullable Map<String, ?> dataMap, @Nonnull Map<String, List<String>> resultMap) {
        if (dataMap == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection valueCollection = (Collection)value;
                List stringValues = valueCollection.stream().map(String::valueOf).collect(Collectors.toList());
                resultMap.put(key, stringValues);
                continue;
            }
            resultMap.put(key, Collections.singletonList(String.valueOf(value)));
        }
    }

    @JsonCreator
    public static TransformationResults create(@JsonProperty(value="transformerChainResults") Map<String, AttributeTransformationResult> transformerChainResults, @JsonProperty(value="transformedAttributes") Map<String, List<String>> transformedAttributes) {
        return new TransformationResults(transformerChainResults, transformedAttributes);
    }

    public static AttributeTransformationResult createPasstrough(@Nullable Map<String, ?> connectorAttributes, @Nullable Map<String, ?> auxAttributes, String key) {
        List<String> values2 = TransformationResults.getAttributeValueAsStringList(connectorAttributes, auxAttributes, key);
        return AttributeTransformationResult.create(values2, false, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getAttributeValueAsStringList(@Nullable Map<String, ?> connectorAttributes, @Nullable Map<String, ?> auxAttributes, String key) {
        if (connectorAttributes == null) return Collections.emptyList();
        Object valueAsObject = connectorAttributes.get(key);
        if (valueAsObject == null) {
            if (auxAttributes == null) return Collections.emptyList();
            valueAsObject = auxAttributes.get(key);
            if (valueAsObject == null) {
                return Collections.emptyList();
            }
        }
        if (!(valueAsObject instanceof Collection)) return Collections.singletonList(String.valueOf(valueAsObject));
        Collection valueAsCollection = (Collection)valueAsObject;
        if (!valueAsCollection.isEmpty()) return valueAsCollection.stream().map(String::valueOf).collect(Collectors.toList());
        return Collections.emptyList();
    }

    private TransformationResults(@Nullable Map<String, AttributeTransformationResult> attributeTransformationResults, @Nullable Map<String, ? extends Collection<String>> transformedAttributes) {
        this.attributeTransformationResults = new HashMap<String, AttributeTransformationResult>();
        if (attributeTransformationResults != null) {
            attributeTransformationResults.forEach(this.attributeTransformationResults::put);
        }
        this.transformedAttributes = new HashMap<String, Collection<String>>();
        if (transformedAttributes != null) {
            this.transformedAttributes.putAll(transformedAttributes);
        }
    }

    public boolean isDropAll() {
        return this.getDroppedAttribute() != null;
    }

    @Nullable
    public String getDroppedAttribute() {
        return this.attributeTransformationResults.entrySet().stream().filter(en -> ((AttributeTransformationResult)en.getValue()).isDropAll()).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public Map<String, List<String>> getInitial() {
        return this.initial;
    }

    public Map<String, Collection<String>> getTransformedAttributes() {
        return this.transformedAttributes;
    }

    public Map<String, AttributeTransformationResult> getAttributeTransformationResults() {
        return this.attributeTransformationResults;
    }

    @JsonPropertyOrder(alphabetic=true)
    static class MinimizedAttributeTransformationResult {
        private final AttributeTransformationResult result;

        public MinimizedAttributeTransformationResult(AttributeTransformationResult result) {
            this.result = result;
        }

        public boolean isDrop() {
            return this.result.isDrop();
        }

        public boolean isDropAll() {
            return this.result.isDropAll();
        }

        @Nullable
        public String getFirst() {
            return this.result.getFirstValue();
        }

        public List<String> getList() {
            return this.result.getValues();
        }
    }
}

