/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.validate.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.resolution.commons.validate.api.JsonSerializationFailedException;
import de.resolution.commons.validate.api.ValidationMessage;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.commons.validate.api.ValidationResultWithId;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValidationResultWithIdImpl
implements ValidationResultWithId {
    private final String id;
    private final ValidationResult validationResult;
    private final ObjectWriter jsonWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();

    public ValidationResultWithIdImpl(@Nonnull String id) {
        this(ValidationResult.create(), id);
    }

    public ValidationResultWithIdImpl(@Nonnull ValidationResult validationResult, @Nonnull String id) {
        this.id = id;
        this.validationResult = validationResult;
    }

    public ValidationResultWithIdImpl(@Nonnull ValidationResultWithId validationResultWithId) {
        this.id = validationResultWithId.getId();
        this.validationResult = ValidationResult.create(validationResultWithId);
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    public ValidationResult add(ValidationResult child) {
        return this.validationResult.add(child);
    }

    @Override
    public ValidationResult add(int index, ValidationResult child) {
        return this.validationResult.add(index, child);
    }

    @Override
    public ValidationResult add(String key, ValidationResult child) {
        return this.validationResult.add(key, child);
    }

    @Override
    public ValidationResult add(String key, @Nullable ValidationMessage errorMessage, @Nullable ValidationMessage warnMessage) {
        return this.validationResult.add(key, errorMessage, warnMessage);
    }

    @Override
    public ValidationResult add(int index, @Nullable ValidationMessage errorMessage, @Nullable ValidationMessage warnMessage) {
        return this.validationResult.add(index, errorMessage, warnMessage);
    }

    @Override
    public ValidationResult addError(ValidationMessage errorMessage) {
        return this.validationResult.addError(errorMessage);
    }

    @Override
    public ValidationResult addWarning(ValidationMessage warningMessage) {
        return this.validationResult.addWarning(warningMessage);
    }

    @Override
    @Nonnull
    public List<ValidationMessage> getErrors() {
        return this.validationResult.getErrors();
    }

    @Override
    @Nonnull
    public List<ValidationMessage> getWarnings() {
        return this.validationResult.getWarnings();
    }

    @Override
    @Nonnull
    public Map<String, ValidationResult> getMap() {
        return this.validationResult.getMap();
    }

    @Override
    @Nonnull
    public List<ValidationResult> getList() {
        return this.validationResult.getList();
    }

    @Override
    public boolean isValid() {
        return this.validationResult.isValid();
    }

    @Override
    public ValidationResult removeEmptyChildren() {
        return this.validationResult.removeEmptyChildren();
    }

    @Override
    public boolean hasChildren() {
        return this.validationResult.hasChildren();
    }

    @Override
    public boolean isContainsWarnings() {
        return this.validationResult.isContainsWarnings();
    }

    @Override
    public String asJson() {
        try {
            return this.jsonWriter.writeValueAsString(this);
        }
        catch (IOException e) {
            throw new JsonSerializationFailedException(e);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ValidationResultWithId)) {
            return false;
        }
        ValidationResultWithId that = (ValidationResultWithId)other;
        return this.getId().equals(that.getId()) && this.validationResult.equals(that);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.validationResult);
    }
}

