/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.jira;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.icon.IconOwningObjectId;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.AbstractProfilePictureAdapter;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.atlasuser.impl.user.ProfilePictureAdapter;
import de.resolution.atlasuser.impl.user.jira.JiraUtil;
import de.resolution.commons.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class JiraProfilePictureAdapter
extends AbstractProfilePictureAdapter
implements ProfilePictureAdapter {
    public static final String DEFAULT_AVATAR_FILENAME = "Avatar-default.svg";
    private static final Logger logger = LoggerFactory.getLogger(JiraProfilePictureAdapter.class);
    private final JiraUtil jiraUtil;
    private final AvatarService avatarService;
    private final AvatarManager avatarManager;
    private final UserManager jiraUserManager;

    public JiraProfilePictureAdapter(JiraUtil jiraUtil, @JiraImport AvatarService avatarService, @JiraImport AvatarManager avatarManager, @JiraImport(value="jiraUserManager") UserManager jiraUserManager) {
        this.jiraUtil = jiraUtil;
        this.avatarService = avatarService;
        this.avatarManager = avatarManager;
        this.jiraUserManager = jiraUserManager;
    }

    @Override
    public void updateProfilePicture(@Nonnull AtlasUser atlasUser, @Nonnull String userKey, @Nonnull AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        Avatar avatar;
        if (!atlasUser.containsKey("ATTR_PROFILE_PICTURE_DATA")) {
            logger.debug("No profile picture data supplied, skipping JiraProfilePictureAdapter.");
            return;
        }
        Optional<String> optionalProfilePictureData = atlasUser.get("ATTR_PROFILE_PICTURE_DATA");
        ApplicationUser applicationUser = this.jiraUserManager.getUserByKey(userKey);
        if (applicationUser == null) {
            resultBuilder.addMessage("Could not update profile picture because the ApplicationUser was null.");
            return;
        }
        if (!optionalProfilePictureData.isPresent() || StringUtil.isNullOrEmpty(optionalProfilePictureData.get())) {
            logger.debug("Empty profile picture supplied, setting default avatar.");
            this.assignAvatarIfExists(DEFAULT_AVATAR_FILENAME, applicationUser, resultBuilder);
            this.cleanupUnusedAvatars(userKey, null, resultBuilder);
            return;
        }
        String profilePictureData = optionalProfilePictureData.get();
        String[] dataComponents = profilePictureData.split(";");
        if (dataComponents.length != 2) {
            logger.warn("The profile picture attribute for user '{}' contained malformed data: {}", (Object)applicationUser.getUsername(), optionalProfilePictureData);
            resultBuilder.addMessage("The profile picture attribute for user '" + applicationUser.getUsername() + "' contained malformed data.");
            return;
        }
        String hash = dataComponents[0];
        if (StringUtil.isNullOrEmpty(hash)) {
            logger.warn("The profile picture attribute for user '{}' did not contain a valid hash: {}", (Object)applicationUser.getUsername(), optionalProfilePictureData);
            resultBuilder.addMessage("The profile picture attribute for user '" + applicationUser.getUsername() + "' did not contain a valid hash.");
            return;
        }
        String avatarBase64 = dataComponents[1];
        if (StringUtil.isNullOrEmpty(avatarBase64)) {
            logger.warn("The profile picture attribute for user '{}' did not contain valid image data: {}", (Object)applicationUser.getUsername(), optionalProfilePictureData);
            resultBuilder.addMessage("The profile picture attribute for user '" + applicationUser.getUsername() + "' did not contain valid image data.");
            return;
        }
        if (simulatedResultingUserBuilder != null) {
            simulatedResultingUserBuilder.with("ATTR_PROFILE_PICTURE_FILENAME", "filename not available in simulation");
            resultBuilder.operation(resultBuilder.getOperation() == AtlasUserResult.Operation.ADDED ? AtlasUserResult.Operation.ADDED : AtlasUserResult.Operation.UPDATED);
            return;
        }
        String fileName = this.getFilename(hash);
        if (this.assignAvatarIfExists(fileName, applicationUser, resultBuilder)) {
            logger.debug("Existing avatar was assigned");
            return;
        }
        try {
            avatar = this.createAvatar(userKey, avatarBase64, fileName);
        }
        catch (IOException e) {
            resultBuilder.addMessage(e.getMessage()).exceptionInfo(ExceptionInfo.from(e)).errorType(AtlasUserResult.ErrorType.OPERATION_FAILED);
            return;
        }
        this.assignAvatar(avatar, applicationUser, resultBuilder);
        this.cleanupUnusedAvatars(userKey, fileName, resultBuilder);
    }

    private void cleanupUnusedAvatars(@Nonnull String userKey, @Nullable String avatarToKeep, @Nonnull AtlasUserResultBuilder resultBuilder) {
        for (Avatar existingAvatar : this.avatarManager.getCustomAvatarsForOwner(IconType.USER_ICON_TYPE, userKey)) {
            if (!existingAvatar.getFileName().startsWith("atlas-user-") || avatarToKeep != null && existingAvatar.getFileName().startsWith(avatarToKeep)) continue;
            logger.debug("Remove unused avatar: {}", (Object)existingAvatar.getFileName());
            boolean delete = this.avatarManager.delete(existingAvatar.getId());
            if (delete) {
                resultBuilder.operation(resultBuilder.getOperation() == AtlasUserResult.Operation.ADDED ? AtlasUserResult.Operation.ADDED : AtlasUserResult.Operation.UPDATED);
                continue;
            }
            logger.debug("Deleting avatar {} for userKey {} failed", (Object)existingAvatar.getFileName(), (Object)userKey);
        }
    }

    private boolean assignAvatarIfExists(@Nonnull String filename, @Nonnull ApplicationUser applicationUser, @Nonnull AtlasUserResultBuilder resultBuilder) {
        Avatar assignedAvatar = this.avatarService.getAvatar(this.jiraUtil.findExecutionUser(), applicationUser);
        logger.debug("assignedAvatar: {}", (Object)assignedAvatar.getFileName());
        if (assignedAvatar.getFileName().startsWith(filename)) {
            logger.debug("Avatar is already assigned, all fine");
            return true;
        }
        for (Avatar avatar : this.avatarManager.getCustomAvatarsForOwner(IconType.USER_ICON_TYPE, applicationUser.getKey())) {
            if (!avatar.getFileName().startsWith(filename)) continue;
            logger.debug("Avatar already exists");
            this.assignAvatar(avatar, applicationUser, resultBuilder);
            return true;
        }
        return false;
    }

    private void assignAvatar(@Nonnull Avatar avatar, @Nonnull ApplicationUser applicationUser, @Nonnull AtlasUserResultBuilder resultBuilder) {
        logger.debug("Setting custom avatar {} for user {}", (Object)avatar.getFileName(), (Object)applicationUser.getName());
        this.avatarService.setCustomUserAvatar(this.jiraUtil.findExecutionUser(), applicationUser, avatar.getId());
        resultBuilder.operation(resultBuilder.getOperation() == AtlasUserResult.Operation.ADDED ? AtlasUserResult.Operation.ADDED : AtlasUserResult.Operation.UPDATED);
    }

    @Nonnull
    private Avatar createAvatar(@Nonnull String userKey, @Nonnull String avatarBase64, @Nonnull String fileName) throws IOException {
        logger.debug("Create new avatar");
        String mimeType = this.detectMimeType(avatarBase64);
        byte[] image = Base64.getDecoder().decode(avatarBase64);
        ByteArrayInputStream is = new ByteArrayInputStream(image);
        return this.avatarManager.create(fileName, mimeType, IconType.USER_ICON_TYPE, new IconOwningObjectId(userKey), (InputStream)is, null);
    }

    @Override
    public void readProfilePictureAttributes(@Nonnull String userKey, @Nonnull AtlasUserBuilder atlasUserBuilder) {
        ApplicationUser applicationUser = this.jiraUserManager.getUserByKey(userKey);
        Avatar assignedAvatar = this.avatarService.getAvatar(this.jiraUtil.findExecutionUser(), applicationUser);
        atlasUserBuilder.with("ATTR_PROFILE_PICTURE_FILENAME", assignedAvatar.getFileName());
    }
}

