/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api;

import de.resolution.atlasuser.impl.ExceptionInfoImpl;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface ExceptionInfo {
    public ExceptionInfo getCause();

    public String getClassName();

    public String getMessage();

    public long getCreationNanoTime();

    public boolean isLogged();

    public String asJson();

    public static ExceptionInfo from(Throwable throwable) {
        return ExceptionInfo.from(throwable, true);
    }

    public static ExceptionInfo from(Throwable throwable, boolean logException) {
        return new ExceptionInfoImpl(throwable, logException);
    }

    public static ExceptionInfo fromJson(String jsonString) throws IOException {
        return ExceptionInfoImpl.fromJson(jsonString);
    }
}

