/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl.confluence;

import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import de.resolution.atlasauth.impl.AbstractRemoteDirectoryAdapter;
import de.resolution.atlasauth.impl.RemoteDirectoryAdapter;
import java.security.Principal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
@ExportAsService(value={RemoteDirectoryAdapter.class})
public class ConfluenceRemoteDirectoryAdapter
extends AbstractRemoteDirectoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceRemoteDirectoryAdapter.class);
    private final LoginManager loginManager;

    @Autowired
    public ConfluenceRemoteDirectoryAdapter(@ConfluenceImport DirectoryInstanceLoader directoryInstanceLoader, @ConfluenceImport CrowdService crowdService, @ConfluenceImport LoginManager loginManager) {
        super(directoryInstanceLoader, crowdService);
        this.loginManager = loginManager;
    }

    @Override
    protected boolean isFirstLogin(Principal principal) {
        if (principal == null) {
            logger.warn("Principal is null, assuming that this is NOT the first login and returning false");
            return false;
        }
        LoginInfo loginInfo = this.loginManager.getLoginInfo(principal.getName());
        if (loginInfo == null) {
            logger.warn("LoginInfo is null, assuming that this is NOT the first login and returning false");
            return false;
        }
        Date lastLogin = loginInfo.getLastSuccessfulLoginDate();
        if (lastLogin == null) {
            logger.debug("getLastSuccessfulLoginDate() returned null, this is the first login for {}", (Object)principal.getName());
            return true;
        }
        logger.debug("{} has already logged in at {}, returning false", (Object)principal.getName(), (Object)lastLogin.toString());
        return false;
    }
}

