/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.disableInactive;

import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.disableInactive.DisableInactiveConnectorConfiguration;
import de.resolution.usersync.builtin.disableInactive.DisableInactiveConnectorConfigurationImpl;
import de.resolution.usersync.builtin.disableInactive.DisableInactiveUsersConnector;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractConnectorFactory;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DisableInactiveConnectorFactory
extends AbstractConnectorFactory<DisableInactiveUsersConnector, DisableInactiveConnectorConfiguration> {
    private final DirectoryAdapter directoryAdapter;

    @Autowired
    public DisableInactiveConnectorFactory(ConnectorService connectorService, DirectoryAdapter directoryAdapter, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
        this.directoryAdapter = directoryAdapter;
    }

    @Override
    @Nonnull
    public DisableInactiveUsersConnector create(@Nonnull DisableInactiveConnectorConfiguration connectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new DisableInactiveUsersConnector(this.connectorService, this.atlasUserAdapter, connectorConfiguration, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public Class<DisableInactiveUsersConnector> getConnectorClass() {
        return DisableInactiveUsersConnector.class;
    }

    @Override
    @Nonnull
    public Class<DisableInactiveConnectorConfiguration> getConfigurationClass() {
        return DisableInactiveConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Cleanup inactive users";
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Applies the configured cleanup behaviour to inactive users";
    }

    @Override
    @Nonnull
    public DisableInactiveConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        DisableInactiveConnectorConfigurationImpl mutableConfig = new DisableInactiveConnectorConfigurationImpl();
        mutableConfig.setName("Cleanup Inactive Users");
        mutableConfig.setUniqueId(uniqueId);
        mutableConfig.setDirectoryId(this.connectorService.getFirstWritableDirectoryId());
        return mutableConfig;
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editDisableInactiveUsersConnector.json";
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull DisableInactiveConnectorConfiguration config) {
        ValidationResult validationResult = super.validate(config);
        if (!config.isDisableByLastLoginEnabled() && config.getGroupsToDisable().isEmpty()) {
            validationResult.add("disableByLastLoginEnabled", null, "If this setting is disabled and Groups to disable always is empty, this connector as no effect.");
            validationResult.add("groupsToDisable", null, "If this is empty and Disable users who have not logged in for some time is disabled, this connector as no effect.");
        }
        if (config.getMaxDurationSinceLastLogin().isEmpty() || !config.getMaxDurationSinceLastLogin().matches("\\d*S?$")) {
            validationResult.add("maxDurationSinceLastLogin", "Enter a positive numeric value here");
        }
        if (config.getCleanupBehaviour() == CleanupBehaviour.DELETE) {
            validationResult.addWarning("The cleanup behaviour is set to DELETE. Every inactive user will be permanently deleted from the selected directory during the next scheduled sync.");
        }
        if (config.getCleanupBehaviour() == CleanupBehaviour.ANONYMIZE_REVERSIBLE) {
            for (AtlasUserDirectory directory : this.directoryAdapter.getDirectories()) {
                if (directory.getId() != config.getDirectoryId() || directory.isAtlasUser()) continue;
                validationResult.addWarning("The cleanup behaviour is set to \"Anonymize Users (reversible)\", but the selected directory is not managed by User Sync. It is very likely that the user attributes cannot be restored after they have been anonymized.");
                break;
            }
        }
        return validationResult;
    }
}

