/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.Validatable;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.impl.FieldCombinerTransformer;
import de.resolution.retransform.impl.GroovyAttributeTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Source
implements Validatable {
    private final Type type;
    private final String key;
    private final String fieldCombinerExpression;
    private final String groovyCode;
    private final List<String> fields;

    @JsonCreator
    public Source(@JsonProperty(value="type") Type type, @JsonProperty(value="key") String key, @JsonProperty(value="fieldCombinerExpression") String fieldCombinerExpression, @JsonProperty(value="groovyCode") String groovyCode, @JsonProperty(value="fields") List<String> fields) {
        this.type = type == null ? Type.GROOVY : type;
        this.key = key;
        this.fieldCombinerExpression = fieldCombinerExpression;
        this.groovyCode = groovyCode;
        this.fields = fields == null ? new ArrayList<String>() : new ArrayList<String>(fields);
    }

    @Nonnull
    public static Source createGroovy(@Nonnull String groovyCode) {
        return new Source(Type.GROOVY, null, null, groovyCode, null);
    }

    @Nonnull
    public static Source createSingle(@Nonnull String fieldName) {
        return new Source(Type.SINGLE, fieldName, null, null, null);
    }

    @Nonnull
    public static Source createFieldCombiner(@Nonnull String fieldCombinerExpression) {
        return new Source(Type.FIELD_COMBINER, null, fieldCombinerExpression, null, null);
    }

    @Nonnull
    public static Source createFirst(@Nonnull List<String> fields) {
        return new Source(Type.FIRST, null, null, null, fields);
    }

    @Nonnull
    public static Source createUnmapped() {
        return new Source(Type.UNMAPPED, null, null, null, null);
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getFieldCombinerExpression() {
        return this.fieldCombinerExpression;
    }

    public String getGroovyCode() {
        return this.groovyCode;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source other = (Source)o;
        return this.type == other.type && Objects.equals(other.key, this.key) && Objects.equals(this.fieldCombinerExpression, other.fieldCombinerExpression) && Objects.equals(this.groovyCode, other.groovyCode) && Objects.equals(this.fields, other.fields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.fieldCombinerExpression, this.groovyCode, this.fields});
    }

    @Override
    @Nonnull
    public ValidationResult validate() {
        ValidationResult result = ValidationResult.create();
        if (this.type == Type.UNMAPPED) {
            return result;
        }
        if (this.type == Type.SINGLE && StringUtil.isNullOrEmpty(this.key)) {
            result.add("key", "Please enter a value.");
        }
        if (this.type == Type.FIRST) {
            ValidationResult fieldsValidation = ValidationResult.create();
            result.add("fields", fieldsValidation);
            if (CollectionUtil.isNullOrEmpty(this.fields)) {
                fieldsValidation.addError("Please enter at least one value for this transformer.");
            } else {
                int i = 0;
                while (i < this.fields.size()) {
                    if (StringUtil.isNullOrEmpty(this.fields.get(i))) {
                        fieldsValidation.add(i, "Please enter an attribute name.");
                    }
                    ++i;
                }
            }
        }
        if (this.type == Type.FIELD_COMBINER) {
            if (StringUtil.isNullOrEmpty(this.fieldCombinerExpression)) {
                result.add("fieldCombinerExpression", "Please enter a field combiner expression.");
            } else {
                FieldCombinerTransformer transformer = new FieldCombinerTransformer(this.fieldCombinerExpression, true, "DEFAULT");
                result.add("fieldCombinerExpression", transformer.validate());
            }
        }
        if (this.type == Type.GROOVY) {
            if (StringUtil.isNullOrEmpty(this.groovyCode)) {
                result.add("groovyCode", "You must enter some groovy code here.");
            } else {
                GroovyAttributeTransformer groovyAttributeTransformer = new GroovyAttributeTransformer(this.groovyCode, "DEFAULT");
                result.add("groovyCode", groovyAttributeTransformer.validate());
            }
        }
        return result;
    }

    public static enum Type {
        SINGLE,
        FIRST,
        FIELD_COMBINER,
        GROOVY,
        UNMAPPED;

    }
}

