/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.systeminformation;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.util.system.SystemInfoUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.reconfigure.api.SystemInformationApplication;
import de.resolution.reconfigure.api.SystemInformationApplicationProvider;
import de.resolution.reconfigure.systeminformation.SystemInformationApplicationImpl;
import java.util.HashMap;
import java.util.HashSet;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class JiraSystemInformationApplicationProvider
implements SystemInformationApplicationProvider {
    private final DatabaseAccessor databaseAccessor;
    private final SystemInfoUtils systemInfoUtils;
    private final ClusterManager clusterManager;
    private static final Logger logger = LoggerFactory.getLogger(JiraSystemInformationApplicationProvider.class);

    @Inject
    public JiraSystemInformationApplicationProvider(@ComponentImport DatabaseAccessor databaseAccessor, @ComponentImport SystemInfoUtils systemInfoUtils, @ComponentImport ClusterManager clusterManager) {
        this.databaseAccessor = databaseAccessor;
        this.systemInfoUtils = systemInfoUtils;
        this.clusterManager = clusterManager;
    }

    @Override
    public SystemInformationApplication getSystemInformationApplication() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("dbName", this.databaseAccessor.getDatabaseVendor().getHumanReadableName());
        info.put("dbVersion", this.databaseAccessor.getVersion());
        info.put("dbDescriptorValue", this.systemInfoUtils.getDbDescriptorValue());
        info.put("appServer", this.systemInfoUtils.getAppServer());
        info.put("databaseType", this.systemInfoUtils.getDatabaseType());
        info.put("dbDescriptorLabel", this.systemInfoUtils.getDbDescriptorLabel());
        info.put("installationType", this.systemInfoUtils.getInstallationType());
        info.put("jvmInputArguments", this.systemInfoUtils.getJvmInputArguments());
        try {
            info.put("dbCollation", this.systemInfoUtils.getDatabaseMetaData().getCollation());
            info.put("dbProductVersion", this.systemInfoUtils.getDatabaseMetaData().getDatabaseProductVersion());
            info.put("dbDriverName", this.systemInfoUtils.getDatabaseMetaData().getDriverName());
            info.put("dbDriverVersion", this.systemInfoUtils.getDatabaseMetaData().getDriverVersion());
            info.put("dbURL", this.systemInfoUtils.getDatabaseMetaData().getMaskedURL());
        }
        catch (Exception e) {
            logger.error("Error reading Database Meta Data: ", (Throwable)e);
        }
        info.put("clustering", String.valueOf(this.clusterManager.isClustered()));
        info.put("clusterNodeId", this.clusterManager.getNodeId());
        HashSet<String> nodes = new HashSet<String>();
        this.clusterManager.getAllNodes().forEach(node -> nodes.add(node.getNodeId() + " / " + node.getIp() + " / " + node.getNodeVersion() + " / " + node.getState().name()));
        return new SystemInformationApplicationImpl(info, nodes);
    }
}

