/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import java.util.Objects;
import javax.annotation.Nonnull;

public class LabelValue<T>
implements Comparable<LabelValue<T>> {
    private final String label;
    private final T value;
    private final boolean exclusive;
    private final int order;

    public LabelValue(@Nonnull String label, @Nonnull T value, boolean exclusive, int order) {
        this.label = label;
        this.value = value;
        this.exclusive = exclusive;
        this.order = order;
    }

    public LabelValue(@Nonnull String label, @Nonnull T value, boolean exclusive) {
        this(label, value, exclusive, Integer.MAX_VALUE);
    }

    public LabelValue(@Nonnull String label, @Nonnull T value, int order) {
        this(label, value, false, order);
    }

    public LabelValue(@Nonnull String label, @Nonnull T value) {
        this(label, value, false, Integer.MAX_VALUE);
    }

    public String getLabel() {
        return this.label;
    }

    public T getValue() {
        return this.value;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public int compareTo(LabelValue<T> o) {
        if (this.getOrder() == o.getOrder()) {
            return this.getLabel().compareTo(o.getLabel());
        }
        if (this.getOrder() > o.getOrder()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelValue that = (LabelValue)o;
        return this.exclusive == that.exclusive && this.order == that.order && this.label.equals(that.label) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.value, this.exclusive, this.order);
    }
}

