/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.confluence;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import de.resolution.atlasuser.api.HostProduct;
import de.resolution.atlasuser.api.HostProductProvider;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserKeys;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.ApplicationAttributeAdapter;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.atlasuser.impl.user.AtlasUserResultBuilder;
import de.resolution.atlasuser.impl.user.communardo.CommunardoUserProfileAdapter;
import de.resolution.atlasuser.impl.user.confluence.ConfluenceProfilePictureAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
public class ConfluenceApplicationAttributeAdapter
implements ApplicationAttributeAdapter,
HostProductProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceApplicationAttributeAdapter.class);
    private final UserDetailsManager userDetailsManager;
    private static final String PREFIX_USER_DETAILS = "UD.";
    private static final String PREFIX_CONTENT_PROPERTY = "CP.";
    public static final String ATTRIBUTE_CONFLUENCE_KEY_FOR_CREATION = "CONFLUENCE.createWithThisKey";
    private static final int MAX_SIZE = 254;
    private final UserAccessor userAccessor;
    private final Collection<String> userDetailsKeys;
    private final List<String> qualifiedKeys;
    private final ContentPropertyManager contentPropertyManager;
    private final PersonalInformationManager personalInformationManager;
    private final LoginManager loginManager;
    private final CommunardoUserProfileAdapter communardoUserProfileAdapter;
    private final ConfluenceIndexer confluenceIndexer;
    private final ConfluenceProfilePictureAdapter confluenceProfilePictureAdapter;

    @Autowired
    public ConfluenceApplicationAttributeAdapter(@ConfluenceImport UserDetailsManager userDetailsManager, @ConfluenceImport UserAccessor userAccessor, @ConfluenceImport ContentPropertyManager contentPropertyManager, @ConfluenceImport PersonalInformationManager personalInformationManager, @ConfluenceImport LoginManager loginManager, @ConfluenceImport ConfluenceIndexer confluenceIndexer, CommunardoUserProfileAdapter communardoUserProfileAdapter, ConfluenceProfilePictureAdapter confluenceProfilePictureAdapter) {
        this.userDetailsManager = userDetailsManager;
        this.userAccessor = userAccessor;
        this.contentPropertyManager = contentPropertyManager;
        this.personalInformationManager = personalInformationManager;
        this.loginManager = loginManager;
        this.communardoUserProfileAdapter = communardoUserProfileAdapter;
        this.confluenceIndexer = confluenceIndexer;
        this.confluenceProfilePictureAdapter = confluenceProfilePictureAdapter;
        this.userDetailsKeys = this.getUserDetailsKeys();
        this.qualifiedKeys = this.userDetailsKeys.stream().map(key -> "CONFLUENCE.UD." + key).collect(Collectors.toList());
    }

    @Override
    public HostProduct getHostProduct() {
        return HostProduct.CONFLUENCE;
    }

    @Override
    public Collection<String> getKeys() {
        return this.qualifiedKeys;
    }

    @Override
    @Nullable
    public String getUserKeyForUsername(@Nonnull String username) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(username);
        if (confluenceUser == null) {
            return null;
        }
        return confluenceUser.getKey().getStringValue();
    }

    @Override
    @Nullable
    public String getUsernameForKey(@Nonnull String key) {
        ConfluenceUser confluenceUser = this.userAccessor.getExistingUserByKey(new UserKey(key));
        if (confluenceUser == null) {
            return null;
        }
        return confluenceUser.getName();
    }

    @Override
    public AtlasUserBuilder readApplicationAttributes(com.atlassian.crowd.model.user.User crowdUser, AtlasUserBuilder atlasUserBuilder, Collection<String> knownKeys) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(crowdUser.getName());
        atlasUserBuilder.with("ATTR_USER_KEY", confluenceUser.getKey().getStringValue());
        this.userDetailsKeys.forEach(key -> {
            String value = this.userDetailsManager.getStringProperty((User)confluenceUser, key);
            if (value != null) {
                atlasUserBuilder.with("CONFLUENCE.UD." + key, value);
            }
        });
        this.readContentProperties(confluenceUser, atlasUserBuilder, knownKeys);
        long lastAuthenticated = this.getLastAuthenticatedFromApplicationLevel(crowdUser);
        if (lastAuthenticated > 0L) {
            atlasUserBuilder.with("ATTR_CONFLUENCE_LAST_AUTHENTICATED", String.valueOf(lastAuthenticated));
        }
        this.communardoUserProfileAdapter.readProfileAttributes(confluenceUser.getKey().getStringValue(), atlasUserBuilder);
        this.confluenceProfilePictureAdapter.readProfilePictureAttributes(confluenceUser.getKey().getStringValue(), atlasUserBuilder);
        return atlasUserBuilder;
    }

    @Override
    public long getLastAuthenticatedFromApplicationLevel(com.atlassian.crowd.model.user.User crowdUser) {
        Date lastSuccessfulLoginDate;
        LoginInfo loginInfo = this.loginManager.getLoginInfo(crowdUser.getName());
        if (loginInfo != null && (lastSuccessfulLoginDate = loginInfo.getLastSuccessfulLoginDate()) != null) {
            return lastSuccessfulLoginDate.getTime();
        }
        return AtlasUserKeys.NO_TIMESTAMP_AVAILABLE;
    }

    @Override
    public AtlasUserResultBuilder updateApplicationAttributes(com.atlassian.crowd.model.user.User crowdUser, AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(crowdUser.getName());
        this.updateUserDetails(atlasUser, confluenceUser, resultBuilder, simulatedResultingUserBuilder);
        this.updateContentProperties(atlasUser, confluenceUser, resultBuilder, simulatedResultingUserBuilder);
        this.communardoUserProfileAdapter.updateProfileAttributes(confluenceUser.getKey().getStringValue(), atlasUser, resultBuilder, simulatedResultingUserBuilder);
        this.confluenceProfilePictureAdapter.updateProfilePicture(atlasUser, confluenceUser.getKey().getStringValue(), resultBuilder, simulatedResultingUserBuilder);
        return resultBuilder;
    }

    private void updateUserDetails(AtlasUser atlasUser, ConfluenceUser confluenceUser, AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        atlasUser.getAttributeKeys().stream().filter(key -> key.startsWith("CONFLUENCE.UD.")).forEach(key -> {
            String currentValue;
            String strippedKey = key.substring("CONFLUENCE.UD.".length());
            Set<String> values2 = atlasUser.getAttributeValues((String)key);
            if (values2.isEmpty()) {
                if (simulatedResultingUserBuilder != null) {
                    simulatedResultingUserBuilder.without((String)key);
                } else {
                    this.userDetailsManager.removeProperty((User)confluenceUser, strippedKey);
                }
                return;
            }
            String atlasUserValue = values2.iterator().next();
            if (values2.size() > 1) {
                logger.warn("{} contains more than one value, using {}", key, (Object)atlasUserValue);
            }
            if (atlasUserValue.length() >= 254) {
                atlasUserValue = atlasUserValue.substring(0, 254);
                logger.warn("Trimmed value for {} to {}", key, (Object)atlasUserValue);
            }
            if (!Objects.equals(atlasUserValue, currentValue = this.userDetailsManager.getStringProperty((User)confluenceUser, strippedKey))) {
                if (simulatedResultingUserBuilder != null) {
                    simulatedResultingUserBuilder.with((String)key, atlasUserValue);
                } else {
                    this.userDetailsManager.setStringProperty((User)confluenceUser, strippedKey, atlasUserValue);
                }
                if (resultBuilder.getOperation() != AtlasUserResult.Operation.ADDED) {
                    resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                }
            }
        });
    }

    private void readContentProperties(ConfluenceUser confluenceUser, AtlasUserBuilder atlasUserBuilder, Collection<String> knownKeys) {
        Collection<String> filteredKeys = ConfluenceApplicationAttributeAdapter.filterContentPropertyKeys(knownKeys);
        if (filteredKeys.isEmpty()) {
            return;
        }
        UserKey userKey = confluenceUser.getKey();
        if (!this.personalInformationManager.hasPersonalInformation(userKey)) {
            return;
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        for (String key : filteredKeys) {
            String value = this.contentPropertyManager.getTextProperty((ContentEntityObject)personalInformation, key);
            if (value == null) continue;
            atlasUserBuilder.with("CONFLUENCE.CP." + key, value);
        }
    }

    private void updateContentProperties(AtlasUser atlasUser, ConfluenceUser confluenceUser, AtlasUserResultBuilder resultBuilder, @Nullable AtlasUserBuilder simulatedResultingUserBuilder) {
        List cupKeys = atlasUser.getAttributeKeys().stream().filter(key -> key.startsWith("CONFLUENCE.CP.")).collect(Collectors.toList());
        if (cupKeys.isEmpty()) {
            this.debug(atlasUser, "No keys for ContentProperties", new Object[0]);
            return;
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)confluenceUser);
        boolean propChanged = false;
        this.debug(atlasUser, "Content property keys: {}", String.join((CharSequence)",", cupKeys));
        for (String key2 : cupKeys) {
            String strippedKey = key2.substring("CONFLUENCE.CP.".length());
            Set<String> values2 = atlasUser.getAttributeValues(key2);
            if (values2.isEmpty()) {
                this.debug(atlasUser, "Removing property {}", strippedKey);
                if (simulatedResultingUserBuilder == null) {
                    this.contentPropertyManager.removeProperty((ContentEntityObject)personalInformation, strippedKey);
                    continue;
                }
                simulatedResultingUserBuilder.without(key2);
                continue;
            }
            String atlasUserValue = values2.iterator().next();
            if (values2.size() > 1) {
                logger.warn("{}: {} contains more than one value, using {}", new Object[]{atlasUser.getName(), key2, atlasUserValue});
            }
            if (atlasUserValue.length() >= 254) {
                atlasUserValue = atlasUserValue.substring(0, 254);
                logger.warn("{} Trimmed value for {} to {}", new Object[]{atlasUser.getName(), key2, atlasUserValue});
            }
            String currentValue = this.contentPropertyManager.getTextProperty((ContentEntityObject)personalInformation, strippedKey);
            this.debug(atlasUser, "Value for {} is '{}'", strippedKey, currentValue);
            if (!Objects.equals(atlasUserValue, currentValue)) {
                this.debug(atlasUser, "Updating value from '{}' to '{}' for key {}...", currentValue, atlasUserValue, strippedKey);
                if (simulatedResultingUserBuilder == null) {
                    this.contentPropertyManager.setTextProperty((ContentEntityObject)personalInformation, strippedKey, atlasUserValue);
                } else {
                    simulatedResultingUserBuilder.with(key2, atlasUserValue);
                }
                this.debug(atlasUser, "Updated value from {} to {} for key {}", currentValue, atlasUserValue, strippedKey);
                if (resultBuilder.getOperation() != AtlasUserResult.Operation.ADDED) {
                    resultBuilder.operation(AtlasUserResult.Operation.UPDATED);
                }
                propChanged = true;
                continue;
            }
            this.debug(atlasUser, "Value {} for key {} is not changed", currentValue, strippedKey);
        }
        if (propChanged && simulatedResultingUserBuilder != null) {
            this.debug(atlasUser, "Properties updated, triggering index()", new Object[0]);
            this.confluenceIndexer.index((Searchable)personalInformation);
        }
    }

    @Override
    public AtlasUserResultBuilder prepareForCreate(AtlasUser atlasUser, AtlasUserResultBuilder resultBuilder, boolean simulate) {
        if (!atlasUser.containsKey(ATTRIBUTE_CONFLUENCE_KEY_FOR_CREATION)) {
            return resultBuilder;
        }
        resultBuilder.errorType(AtlasUserResult.ErrorType.OPERATION_FAILED).errorString("Key CONFLUENCE.createWithThisKey is no longer supported.");
        return resultBuilder;
    }

    private Collection<String> getUserDetailsKeys() {
        ArrayList ret = new ArrayList();
        this.userDetailsManager.getProfileGroups().forEach(group -> ret.addAll(this.userDetailsManager.getProfileKeys(group)));
        return Collections.unmodifiableCollection(ret);
    }

    @Override
    public boolean canSearchMembershipsForMultipleGroups() {
        return false;
    }

    @Nonnull
    public static Collection<String> filterContentPropertyKeys(@Nullable Collection<String> keys2) {
        if (keys2 == null || keys2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (String key : keys2) {
            if (!key.startsWith("CONFLUENCE.CP.")) continue;
            returnList.add(key.substring("CONFLUENCE.CP.".length()));
        }
        return returnList;
    }

    private void debug(AtlasUser atlasUser, String message, Object ... data) {
        if (logger.isDebugEnabled()) {
            String logString = "{}: " + message;
            ArrayList<Object> al = new ArrayList<Object>();
            al.add(atlasUser.getReference().getFindByAttributeValue());
            al.addAll(Arrays.asList(data));
            logger.debug(logString, al.toArray());
        }
    }
}

