/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.group;

import de.resolution.atlasuser.api.exception.InvalidAtlasUserStateException;
import de.resolution.atlasuser.api.group.AtlasGroup;
import de.resolution.atlasuser.api.group.AtlasGroupReference;
import de.resolution.atlasuser.impl.group.ImmutableAtlasGroup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AtlasGroupBuilder {
    private final Map<String, Set<String>> attributes = new HashMap<String, Set<String>>();
    private String groupName;
    private long directoryId = -2L;

    @Nonnull
    public Optional<Set<String>> get(@Nonnull String key) {
        Set<String> values2 = this.attributes.get(key);
        if (values2 == null) {
            return Optional.empty();
        }
        return Optional.of(new HashSet<String>(values2));
    }

    @Nullable
    public String getFirstIfPresent(@Nonnull String key) {
        Set<String> values2 = this.attributes.get(key);
        if (values2 != null) {
            if (values2.isEmpty()) {
                return null;
            }
            return values2.iterator().next();
        }
        return null;
    }

    public AtlasGroupBuilder from(AtlasGroup atlasUser) {
        this.groupName = atlasUser.getReference().getGroupName();
        this.directoryId = atlasUser.getReference().getDirectoryId();
        Map<String, Set<String>> otherAttributes = atlasUser.getAttributes();
        otherAttributes.keySet().forEach(key -> this.attributes.put((String)key, new HashSet((Collection)otherAttributes.get(key))));
        return this;
    }

    public AtlasGroupBuilder findBy(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public AtlasGroupBuilder findBy(@Nonnull AtlasGroupReference atlasGroupReference) {
        this.directoryId = atlasGroupReference.getDirectoryId();
        this.groupName = atlasGroupReference.getGroupName();
        return this;
    }

    public AtlasGroupBuilder in(long directoryId) {
        this.directoryId = directoryId;
        return this;
    }

    public AtlasGroupBuilder with(@Nonnull String key, String ... values2) {
        if (values2.length == 0) {
            this.attributes.put(key, Collections.emptySet());
        } else {
            this.attributes.put(key, new HashSet(Arrays.stream(values2).filter(Objects::nonNull).collect(Collectors.toSet())));
        }
        return this;
    }

    public AtlasGroupBuilder with(@Nonnull String key, @Nonnull Collection<String> values2) {
        this.attributes.put(key, new HashSet(values2.stream().filter(Objects::nonNull).collect(Collectors.toSet())));
        return this;
    }

    public AtlasGroupBuilder with(@Nonnull String key, boolean value) {
        this.attributes.put(key, Collections.singleton(String.valueOf(value)));
        return this;
    }

    public AtlasGroupBuilder without(@Nonnull String key) {
        this.attributes.remove(key);
        return this;
    }

    public AtlasGroup build() {
        if (this.groupName == null || this.groupName.isEmpty()) {
            throw new InvalidAtlasUserStateException("groupName must not be null or empty");
        }
        if (this.directoryId == -2L) {
            throw new InvalidAtlasUserStateException("Directory reference must not be -2");
        }
        return new ImmutableAtlasGroup(AtlasGroupReference.create(this.groupName, this.directoryId), this.attributes);
    }

    public AtlasGroupBuilder groupName(String groupName) {
        this.attributes.put("ATTR_GROUPNAME", Collections.singleton(String.valueOf(groupName)));
        return this;
    }
}

