/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api.directory;

import de.resolution.atlasuser.api.directory.AtlasUserDirectory;
import java.util.HashMap;
import java.util.Map;

public class AtlasUserDirectoryBuilder {
    private long id = -1L;
    private String name;
    private String description = "";
    private boolean writable = true;
    private boolean atlasUser = true;
    private boolean internal = true;
    private boolean active = true;
    private boolean useNestedGroups = false;
    private Map<String, String> attributes = new HashMap<String, String>();

    AtlasUserDirectoryBuilder() {
    }

    AtlasUserDirectoryBuilder(AtlasUserDirectory directory) {
        this.id = directory.getId();
        this.name = directory.getName();
        this.description = directory.getDescription();
        this.writable = directory.isWritable();
        this.atlasUser = directory.isAtlasUser();
        this.internal = directory.isInternal();
        this.attributes = new HashMap<String, String>(directory.getAttributes());
        this.active = directory.isActive();
    }

    public AtlasUserDirectoryBuilder id(long id) {
        this.id = id;
        return this;
    }

    public AtlasUserDirectoryBuilder name(String name) {
        this.name = name;
        return this;
    }

    public AtlasUserDirectoryBuilder description(String description) {
        this.description = description;
        return this;
    }

    public AtlasUserDirectoryBuilder writable(boolean writable) {
        this.writable = writable;
        return this;
    }

    public AtlasUserDirectoryBuilder atlasUser(boolean atlasUser) {
        this.atlasUser = atlasUser;
        return this;
    }

    public AtlasUserDirectoryBuilder internal(boolean internal) {
        this.internal = internal;
        return this;
    }

    public AtlasUserDirectoryBuilder with(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public AtlasUserDirectoryBuilder active(boolean active) {
        this.active = active;
        return this;
    }

    public AtlasUserDirectoryBuilder useNestedGroups(boolean useNestedGroups) {
        this.useNestedGroups = useNestedGroups;
        return this;
    }

    public AtlasUserDirectory build() {
        return new AtlasUserDirectory(this.id, this.name, this.description, this.writable, this.atlasUser, this.internal, this.active, this.useNestedGroups, this.attributes);
    }
}

