/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasauth.impl;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import de.resolution.atlasauth.api.AuthenticationConfiguration;
import de.resolution.atlasauth.api.AuthenticationInformation;
import de.resolution.atlasauth.api.AuthenticationResult;
import de.resolution.atlasauth.api.AuthenticationService;
import de.resolution.atlasauth.impl.ApplicationSpecificDataProvider;
import de.resolution.atlasauth.impl.AuthenticatorHook;
import de.resolution.atlasauth.impl.PrincipalAndModified;
import de.resolution.atlasauth.impl.PrincipalForLogin;
import de.resolution.atlasauth.impl.PrincipalProvider;
import de.resolution.atlasauth.impl.RedirectChecker;
import de.resolution.atlasauth.impl.UserAuthException;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="authenticationService")
public abstract class AuthenticationServiceImpl
implements AuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    private final AuthenticatorHook authenticatorHook;
    private final ApplicationSpecificDataProvider applicationSpecificDataProvider;
    private final PrincipalProvider principalProvider;
    private final ApplicationProperties applicationProperties;

    @Autowired
    protected AuthenticationServiceImpl(AuthenticatorHook authenticatorHook, ApplicationSpecificDataProvider applicationSpecificDataProvider, PrincipalProvider principalProvider, ApplicationProperties applicationProperties) {
        this.authenticatorHook = authenticatorHook;
        this.applicationSpecificDataProvider = applicationSpecificDataProvider;
        this.principalProvider = principalProvider;
        this.applicationProperties = applicationProperties;
    }

    @Override
    @Nonnull
    public AuthenticationResult injectAuthentication(AuthenticationInformation authenticationInformation, AuthenticationConfiguration authenticationConfiguration, HttpServletRequest request, HttpServletResponse response) {
        PrincipalAndModified principalAndModified;
        try {
            principalAndModified = this.principalProvider.providePrincipal(authenticationInformation, authenticationConfiguration);
        }
        catch (UserAuthException e) {
            logger.warn("Loading principal failed", (Throwable)e);
            return AuthenticationResult.builder().authenticationInformation(authenticationInformation).outcome(AuthenticationResult.Outcome.ERROR).message("Loading user failed: " + e.getMessage()).build();
        }
        String userid = null;
        if (principalAndModified.getPrincipal() == null) {
            return AuthenticationResult.builder().authenticationInformation(authenticationInformation).outcome(AuthenticationResult.Outcome.FAILED).message("User was not found").build();
        }
        userid = principalAndModified.getPrincipal().getName();
        if (this.isThisUserAlreadyLoggedIn(request, principalAndModified.getPrincipal())) {
            return AuthenticationResult.builder().authenticationInformation(authenticationInformation).outcome(AuthenticationResult.Outcome.ALREADY_AUTHORIZED).userid(userid).message("User " + authenticationInformation.getUsername() + " is already authorized").build();
        }
        try {
            boolean success = this.authenticatorHook.authoriseUserAndEstablishSession(request, response, new PrincipalForLogin(authenticationInformation.getUsername()), false, false);
            if (success) {
                logger.debug("Authentication successful");
                return AuthenticationResult.builder().authenticationInformation(authenticationInformation).userid(userid).outcome(AuthenticationResult.Outcome.SUCCESS).build();
            }
            logger.debug("Authentication failed");
            return AuthenticationResult.builder().authenticationInformation(authenticationInformation).userid(userid).outcome(AuthenticationResult.Outcome.FAILED).build();
        }
        catch (Exception e) {
            logger.warn("Exception during authentication: ", (Throwable)e);
            return AuthenticationResult.builder().authenticationInformation(authenticationInformation).userid(userid).outcome(AuthenticationResult.Outcome.ERROR).message(e.getClass().getCanonicalName() + ": " + e.getMessage()).build();
        }
    }

    @Override
    public String getLoginPageUrl() {
        return this.applicationSpecificDataProvider.getLoginPageUrl();
    }

    @Override
    public boolean isLoginUrl(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        boolean isUrl = requestUri.equals(this.getLoginPageUrl());
        boolean isLogout = Boolean.parseBoolean(request.getParameter("logout"));
        return isUrl && !isLogout;
    }

    @Override
    public String getDestinationUrlParameterName() {
        return this.applicationSpecificDataProvider.getDestinationUrlParameterName();
    }

    @Override
    public String getLoggedInUsername(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session == null) {
            logger.debug("No session");
            return null;
        }
        Object userObject = session.getAttribute("seraph_defaultauthenticator_user");
        if (userObject == null) {
            logger.debug("No attribute value for seraph_defaultauthenticator_user in session");
            return null;
        }
        if (userObject instanceof Principal) {
            String name = ((Principal)userObject).getName();
            logger.debug("Username is {}", (Object)name);
            return name;
        }
        logger.warn("Object {} in session is a {} but no Principal", userObject, (Object)userObject.getClass().getCanonicalName());
        return null;
    }

    private boolean isThisUserAlreadyLoggedIn(HttpServletRequest request, Principal principal) {
        if (principal == null) {
            logger.debug("Principal is null");
            return false;
        }
        String username = principal.getName();
        if (username == null) {
            logger.debug("Username is null");
            return false;
        }
        String loggedinusername = this.getLoggedInUsername(request);
        boolean result = username.equals(loggedinusername);
        logger.debug("{} {} Already logged in {}", new Object[]{username, loggedinusername, result});
        return result;
    }

    @Override
    public boolean logout(HttpServletRequest req, HttpServletResponse resp) {
        return this.authenticatorHook.logout(req, resp);
    }

    @Override
    @Nonnull
    public String getRedirectURL(boolean isSkipBaseUrlCheck, @Nullable String redirectTarget, @Nonnull String defaultRelativeRedirectUrl) {
        String baseUrlForRequest = this.getCanonicalBaseUrlWithSlash();
        String relativeBaseUrl = this.getRelativeBaseUrl();
        if (redirectTarget != null) {
            redirectTarget = RedirectChecker.adjustOsDestinationIfNecessary(redirectTarget);
        }
        return RedirectChecker.getRedirectURL(isSkipBaseUrlCheck, baseUrlForRequest, relativeBaseUrl, redirectTarget, defaultRelativeRedirectUrl);
    }

    private String getCanonicalBaseUrlWithSlash() {
        String url = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        logger.trace("returning canonical base URL {}", (Object)url);
        return url.endsWith("/") ? url : url + "/";
    }

    public String getRelativeBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
    }
}

