/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth;

import com.auth0.jwt.interfaces.DecodedJWT;
import de.resolution.commons.data.StructuredData;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.api.LabelValue;
import de.resolution.usersync.api.UserSyncService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class UserSyncRelatedThings {
    public static final String NO_CONNECTOR = "None";
    public static final String NONE_CONNECTOR_NAME = "None";
    public static final String NONE_CONNECTOR_UID = "None";
    public static final AttributeTransformationConfig DEFAULT_USERSYNC_LOOKUP = AttributeTransformationConfig.create("upn", Target.Type.NONE, "US_LOOKUP");

    private UserSyncRelatedThings() {
    }

    public static StructuredData extractClaimsFromIdToken(DecodedJWT decodedToken) {
        if (decodedToken == null) {
            return StructuredData.create();
        }
        return StructuredData.parseJson(StringUtils.newStringUtf8(Base64.decodeBase64(decodedToken.getPayload())));
    }

    public static <L, V> Map<L, V> asMap(List<LabelValue<L, V>> labelValueList) {
        HashMap ret = new HashMap();
        if (labelValueList == null) {
            return ret;
        }
        labelValueList.forEach(item -> ret.put(item.getLabel(), item.getValue()));
        return ret;
    }

    public static Map<String, String> createConnectorList(UserSyncService userSyncService) {
        Map availableConnectorNamesAndIds = UserSyncRelatedThings.asMap(userSyncService.getAvailableConnectorNamesAndUniqueIds());
        HashMap<String, String> ret = new HashMap<String, String>(availableConnectorNamesAndIds);
        ret.put("None", "None");
        return ret;
    }
}

