/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.boundedregex.RegexAndReplacement;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.PrivilegeCheckerImpl;
import de.resolution.reconfigure.frontenddefinition.FrontendDefinitionLoader;
import de.resolution.reconfigure.frontenddefinition.StringLoader;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.retransform.config.Transformations;
import de.resolution.usersync.api.ConnectorFactoryRegistry;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.Notification;
import de.resolution.usersync.api.NotificationService;
import de.resolution.usersync.api.cleanup.GroovyCleanupDecider;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.frontend.FileBasedDynamicFrontendProvider;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.impl.requiredgroups.GroovyBasedRequiredGroupChecker;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import de.resolution.usersync.spi.ConnectorFactory;
import de.resolution.usersync.util.AttributeTransformationMigrator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractConnectorFactory<T extends Connector<C>, C extends ConnectorConfiguration>
implements ConnectorFactory<T, C>,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnectorFactory.class);
    public static final String MSG_ID_MIG_REQ_CONNECTOR_GROUPS = "MIG_CONNECTOR_GROUPS";
    public static final String MSG_WARN_CANNOT_MIGRATE_GROUPS = "For optimal performance, you must change the connector's configuration. Please see <a href=\"https://wiki.resolution.de/go/requiredGroupsMigration\" target=\"_blank\" >https://wiki.resolution.de/go/requiredGroupsMigration</a>";
    public static final String MSG_INFO_MIGRATED_GROUPS = "Moved Required Groups to Required Connector Groups. Please see <a href=\"https://wiki.resolution.de/go/movedRequiredGroups\" target=\"_blank\">https://wiki.resolution.de/go/movedRequiredGroups</a>";
    public static final String KEY_REQUIRED_GROUPS = "requiredGroups";
    public static final String KEY_REQUIRED_CONNECTOR_GROUPS = "requiredConnectorGroups";
    public static final String KEY_ATTRIBUTE_TRANSFORMATION_CONFIGS = "attributeTransformationConfigs";
    public static final String KEY_GROOVY_CLEANUP_DECIDER_CODE = "groovyCleanupDeciderCode";
    public static final String KEY_REQUIRED_CONNECTOR_GROUPS_GROOVY = "requiredConnectorGroupsGroovy";
    public static final String MUST_NOT_BE_NULL_OR_EMPTY = "You must enter something";
    private final ConnectorFactoryRegistry registry;
    protected final ConnectorService connectorService;
    protected final AtlasUserAdapter atlasUserAdapter;
    protected final NotificationService notificationService;
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String VERSION = "version";
    private final PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider;

    protected AbstractConnectorFactory(ConnectorService connectorService, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        this.connectorService = connectorService;
        this.atlasUserAdapter = connectorService.getAtlasUserAdapter();
        this.notificationService = connectorService.getNotificationService();
        this.registry = connectorService.getConnectorFactoryRegistry();
        this.platformSpecificConfigDefaultsProvider = platformSpecificConfigDefaultsProvider;
        this.registry.register(this);
    }

    @Override
    @Nonnull
    public T create(@Nonnull String configurationString, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return (T)this.create(this.parseConfiguration(configurationString), newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public T create(@Nonnull JsonNode configurationNode, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return (T)this.create(this.parseConfiguration(configurationNode), newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public T create(String uniqueId) throws ConfigurationFailedException {
        Object config = this.createEmptyConfiguration(uniqueId);
        this.platformSpecificConfigDefaultsProvider.applyDefaults((ConnectorConfiguration)config);
        return (T)this.create(config, true, 0L);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public C parseConfiguration(@Nullable String configurationJson) throws ConfigurationFailedException {
        try {
            ObjectNode configurationNode = (ObjectNode)objectMapper.readTree(configurationJson);
            return this.parseConfiguration(configurationNode);
        }
        catch (Exception e) {
            throw new ConfigurationFailedException("Loading configurationNode failed", e);
        }
    }

    public C parseConfiguration(@Nonnull JsonNode configurationNode) throws ConfigurationFailedException {
        int configVersion = this.readAndUpdateConfigurationVersion(configurationNode);
        logger.debug("Config with updated version: {}", (Object)configurationNode);
        switch (configVersion) {
            case 0: 
            case 1: {
                logger.debug("Updating version {} to 2", (Object)configVersion);
                this.migrateConfigurationToVersion2(configurationNode);
                break;
            }
            case 2: {
                logger.debug("Version {} is up to date.", (Object)configVersion);
                break;
            }
            default: {
                throw new InvalidConfigurationVersionException(configVersion);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Effective Configuration-JSON: {}", (Object)configurationNode);
        }
        try {
            return (C)((ConnectorConfiguration)objectMapper.readerFor(this.getConfigurationClass()).readValue(configurationNode));
        }
        catch (Exception e) {
            throw new ConfigurationFailedException("Cannot parse config", e);
        }
    }

    private void migrateConfigurationToVersion2(@Nonnull JsonNode jsonNode) throws ConfigurationFailedException {
        logger.info("Migrating Connector Configuration to Version 2");
        if (!jsonNode.isObject()) {
            throw new ConfigurationFailedException("jsonNode is no ObjectNode");
        }
        ObjectNode configurationNode = (ObjectNode)jsonNode;
        List<AttributeTransformationConfig> attributeTransformationConfigs = AttributeTransformationMigrator.migrateAttributeTransformers(configurationNode.get("userAttributeMapping"));
        if (AbstractConnectorFactory.hasGroupTransformations(configurationNode)) {
            Source source2 = Source.createSingle("GROUPS");
            List<RegexAndReplacement> regexAndReplacements = AbstractConnectorFactory.getGroupTransformations(configurationNode);
            Transformations.DropOption dropOption = AbstractConnectorFactory.isDropUnmatchedGroup(configurationNode) ? Transformations.DropOption.DROP_VALUE_IF_NOT_APPLIED : Transformations.DropOption.NONE;
            Transformations.RegexAndReplacementWrapper regexAndReplacementWrapper = new Transformations.RegexAndReplacementWrapper(true, regexAndReplacements, dropOption);
            Transformations transformations = new Transformations(false, regexAndReplacementWrapper, null, null);
            Target target = new Target(Target.Type.SYSTEM, "ATTR_GROUPS");
            AttributeTransformationConfig attributeTransformationConfig = new AttributeTransformationConfig(source2, target, transformations, false, true);
            attributeTransformationConfigs.add(attributeTransformationConfig);
        } else {
            attributeTransformationConfigs.add(AbstractConnectorConfigurationImpl.GROUP_TRANSFORMATION);
        }
        String uniqueId = Optional.ofNullable(configurationNode.get("uniqueId")).orElseThrow(() -> new ConfigurationFailedException("Cannot migrate config, uniqueId is missing")).asText();
        String connectorName = configurationNode.get("name") != null ? configurationNode.get("name").asText() + ": " : "";
        List<String> requiredGroups = AbstractConnectorFactory.getRequiredGroups(configurationNode);
        if (!requiredGroups.isEmpty()) {
            if (AbstractConnectorFactory.hasGroupTransformations(configurationNode)) {
                this.notificationService.add(Notification.createForConnector(connectorName + MSG_WARN_CANNOT_MIGRATE_GROUPS, Notification.Level.WARNING, MSG_ID_MIG_REQ_CONNECTOR_GROUPS, uniqueId));
            } else {
                JsonNode requiredGroupsNode = configurationNode.get(KEY_REQUIRED_GROUPS);
                configurationNode.replace(KEY_REQUIRED_GROUPS, objectMapper.createArrayNode());
                configurationNode.replace(KEY_REQUIRED_CONNECTOR_GROUPS, requiredGroupsNode);
                this.notificationService.add(Notification.createForConnector(connectorName + MSG_INFO_MIGRATED_GROUPS, Notification.Level.INFO, MSG_ID_MIG_REQ_CONNECTOR_GROUPS, uniqueId));
            }
        }
        this.migrateSpecificConfigurationToVersion2(configurationNode, attributeTransformationConfigs);
        configurationNode.remove("userAttributeMapping");
        configurationNode.set(KEY_ATTRIBUTE_TRANSFORMATION_CONFIGS, (JsonNode)objectMapper.valueToTree(attributeTransformationConfigs));
    }

    protected static boolean isDropUnmatchedGroup(@Nonnull ObjectNode configurationNode) {
        JsonNode dropUnmatchedGroupNode = configurationNode.get("dropUnmatchedGroups");
        return dropUnmatchedGroupNode != null && dropUnmatchedGroupNode.asBoolean();
    }

    protected void migrateSpecificConfigurationToVersion2(ObjectNode configurationNode, List<AttributeTransformationConfig> attributeTransformationConfigs) throws ConfigurationFailedException {
    }

    private int readAndUpdateConfigurationVersion(@Nonnull JsonNode jsonNode) throws ConfigurationFailedException {
        if (!jsonNode.isObject()) {
            throw new ConfigurationFailedException("configurationNode must be an ObjectNode");
        }
        ObjectNode configurationNode = (ObjectNode)jsonNode;
        int version = 0;
        JsonNode versionNode = configurationNode.get(VERSION);
        if (versionNode != null) {
            version = versionNode.asInt();
            configurationNode.remove(VERSION);
        }
        configurationNode.set(VERSION, (JsonNode)objectMapper.valueToTree(2));
        return version;
    }

    @Override
    @Nonnull
    public String createConfigurationPage() {
        HashMap<String, String> hashReplacements = new HashMap<String, String>();
        hashReplacements.put("connectorclass", this.getConnectorClass().getCanonicalName());
        return FrontendDefinitionLoader.loadFrontendDefinition("frontend/editConnectorBase.json", StringLoader.create(), new FileBasedDynamicFrontendProvider(this.getFilenameForConfigurationFragment()), hashReplacements);
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editConnectorDefault.json";
    }

    @Override
    public void unregister() {
        if (logger.isDebugEnabled()) {
            logger.debug("Unregistering {} from ConnectorFactoryRegistry", (Object)this.getClass().getName());
        }
        this.registry.unregister(this);
    }

    public void destroy() {
        this.unregister();
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull C config) {
        String serverFilter;
        ValidationResult result = ValidationResult.create();
        if (StringUtil.isNullOrEmpty(config.getName())) {
            result.add("name", "Name must be set.", null);
        } else if (config.getName().length() > 254) {
            result.add("name", "Name must not be longer than 254 characters");
        }
        ValidationResult requiredGroupsValidationResult = ValidationResult.create();
        result.add(KEY_REQUIRED_CONNECTOR_GROUPS, requiredGroupsValidationResult);
        for (int i = 0; i < config.getRequiredConnectorGroups().size(); ++i) {
            String curr = config.getRequiredConnectorGroups().get(i);
            if (StringUtil.isNullOrEmpty(curr)) {
                requiredGroupsValidationResult.add(i, MUST_NOT_BE_NULL_OR_EMPTY);
                continue;
            }
            try {
                Pattern.compile(curr);
                continue;
            }
            catch (PatternSyntaxException exception) {
                requiredGroupsValidationResult.add(i, "Invalid regex: " + curr);
            }
        }
        if (config.getSlowdownDelayInMs() < 0) {
            result.add("slowdownDelayInMs", "Must be >= 0");
        }
        if (config.getRequiredGroups().stream().anyMatch(StringUtil::isNullOrEmpty)) {
            result.add(KEY_REQUIRED_GROUPS, MUST_NOT_BE_NULL_OR_EMPTY);
        }
        if (config.getGroupsToAssignNever().stream().anyMatch(StringUtil::isNullOrEmpty)) {
            result.add("groupsToAssignNever", MUST_NOT_BE_NULL_OR_EMPTY);
        }
        if (config.getGroupsToAssignAlways().stream().anyMatch(StringUtil::isNullOrEmpty)) {
            result.add("groupsToAssignAlways", MUST_NOT_BE_NULL_OR_EMPTY);
        }
        if (config.getGroupsToKeep().stream().anyMatch(StringUtil::isNullOrEmpty)) {
            result.add("groupsToKeep", MUST_NOT_BE_NULL_OR_EMPTY);
        }
        if (config.getGroupsToAssignFilter().stream().anyMatch(StringUtil::isNullOrEmpty)) {
            result.add("groupsToAssignFilter", MUST_NOT_BE_NULL_OR_EMPTY);
        }
        if (config.isScheduled() && StringUtil.isNullOrEmpty(config.getCronExpression())) {
            result.add("cronExpression", "Cron Expression must be set when scheduled synchronization is enabled.", null);
        }
        if (config.getCopyBehaviour() == AtlasUserAdapter.CopyBehaviour.MOVE) {
            result.add("copyBehaviour", null, "Copy Behaviour is set to MOVE. Matching users will be removed from the source directory and updated afterwards with the connector attributes. This only applies to the first sync of a user, if the user does not exist in the connector directory yet.");
        }
        if (StringUtil.isNullOrEmpty(config.getUniqueId())) {
            result.add("uniqueId", "Unique ID must not be empty");
        } else if (config.getUniqueId().length() > 254) {
            result.add("uniqueId", "Unique ID must not be longer than 254 characters");
        }
        if (config.getResultsToKeep() < 0) {
            result.add("resultsToKeep", "Must be >=0");
        }
        ValidationResult transformationConfigResult = ValidationResult.create();
        result.add(KEY_ATTRIBUTE_TRANSFORMATION_CONFIGS, transformationConfigResult);
        HashSet<Target> tmp = new HashSet<Target>();
        AttributeTransformationConfigValidator attributeTransformationConfigValidator = this.connectorService.getAttributeTransformationConfigValidator();
        for (int i = 0; i < config.getAttributeTransformationConfigs().size(); ++i) {
            AttributeTransformationConfig attributeTransformationConfig = config.getAttributeTransformationConfigs().get(i);
            transformationConfigResult.add(i, attributeTransformationConfigValidator.validate(attributeTransformationConfig));
            if (tmp.add(attributeTransformationConfig.getTarget())) continue;
            result.add(KEY_ATTRIBUTE_TRANSFORMATION_CONFIGS, "You added a mapping twice! Delete the duplicate of the '" + attributeTransformationConfig.getTarget().getName() + "' attribute!");
        }
        if (config.isUseGroovyCleanupDecider()) {
            if (config.getGroovyCleanupDeciderCode() == null || config.getGroovyCleanupDeciderCode().trim().isEmpty()) {
                result.add(KEY_GROOVY_CLEANUP_DECIDER_CODE, "Code must be not be empty");
            } else {
                try {
                    new GroovyCleanupDecider(config.getGroovyCleanupDeciderCode());
                }
                catch (GroovyCleanupDecider.GroovyScriptException e) {
                    result.add(KEY_GROOVY_CLEANUP_DECIDER_CODE, e.getMessage());
                }
            }
        }
        if (config.isUseRequiredConnectorGroupsGroovy()) {
            String groovyCode = config.getRequiredConnectorGroupsGroovy();
            if (groovyCode == null || groovyCode.trim().isEmpty()) {
                result.add(KEY_REQUIRED_CONNECTOR_GROUPS_GROOVY, "Groovy code must not be empty");
            } else {
                try {
                    GroovyBasedRequiredGroupChecker.create(groovyCode);
                }
                catch (Exception e) {
                    result.add(KEY_REQUIRED_CONNECTOR_GROUPS_GROOVY, e.getMessage());
                }
            }
        }
        if (config.isUseRequiredConnectorGroupsServerFilter() && ((serverFilter = config.getRequiredConnectorGroupsServerFilter()) == null || serverFilter.trim().isEmpty())) {
            result.add("requiredConnectorGroupsServerFilter", "Server filter expression must not be empty");
        }
        if (config.isRemoveAllGroupAssignmentsOnCleanup() && !config.getGroupsOrRegexNotBeRemoved().isEmpty()) {
            ValidationResult valRes = ValidationResult.create();
            result.add("groupsOrRegexNotBeRemoved", valRes);
            for (int i = 0; i < config.getGroupsOrRegexNotBeRemoved().size(); ++i) {
                String current = config.getGroupsOrRegexNotBeRemoved().get(i);
                if (!StringUtil.isNullOrEmpty(current)) continue;
                valRes.add(i, "Must not be null or empty");
            }
        }
        if (config.getSyncSingleUserRestPermission() != PrivilegeCheckerImpl.Role.ADMIN && config.getSyncSingleUserRestPermission() != PrivilegeCheckerImpl.Role.SYSADMIN) {
            result.add("syncSingleUserRestPermission", "Invalid permission configured");
        }
        return result;
    }

    @Override
    public String getSingleSyncInputTitle() {
        return "Identifier";
    }

    @Override
    public String getSingleSyncInputDescription() {
        return "Enter an identifier to single sync the user";
    }

    public static boolean hasGroupTransformations(ObjectNode configurationNode) {
        JsonNode groupTransformations = configurationNode.get("groupTransformations");
        if (groupTransformations != null && groupTransformations.isArray()) {
            return groupTransformations.size() > 0;
        }
        return false;
    }

    public static List<RegexAndReplacement> getGroupTransformations(ObjectNode configurationNode) throws ConfigurationFailedException {
        JsonNode groupTransformations = configurationNode.get("groupTransformations");
        if (groupTransformations != null) {
            ObjectReader reader = objectMapper.readerFor(new TypeReference<List<RegexAndReplacement>>(){});
            try {
                return (List)reader.readValue(groupTransformations);
            }
            catch (IOException e) {
                throw new ConfigurationFailedException("Reading group transformations failed", e);
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getRequiredGroups(ObjectNode configurationNode) {
        ArrayList<String> ret = new ArrayList<String>();
        JsonNode requiredGroups = configurationNode.get(KEY_REQUIRED_GROUPS);
        if (requiredGroups != null && requiredGroups.isArray() && requiredGroups.size() > 0) {
            requiredGroups.forEach(node -> ret.add(node.textValue()));
        }
        return ret;
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class InvalidConfigurationVersionException
    extends ConfigurationFailedException {
        public InvalidConfigurationVersionException(int version) {
            super("Invalid configuration-version " + version);
        }
    }
}

