/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.resolution.atlasuser.api.exception.AtlasUserRuntimeException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.task.api.Task;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.LinchpinEventSender;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.util.UserSyncUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinchPinEventSenderImpl
implements LinchpinEventSender {
    private static final Logger logger = LoggerFactory.getLogger(LinchPinEventSenderImpl.class);
    private final EventPublisher eventPublisher;

    @Autowired
    public LinchPinEventSenderImpl(@ComponentImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void sendSyncHappenedEvent(@Nonnull SyncStatus syncStatus, @Nonnull Connector<?> connector) {
        if (LinchPinEventSenderImpl.hasNoContentProperties(connector)) {
            return;
        }
        if (syncStatus.getStatus() != Task.Status.DONE) {
            logger.debug("Status is {}, not DONE, nothing to do.", (Object)syncStatus.getStatus());
            return;
        }
        if (syncStatus.getSyncStatusResult() != SyncStatus.Result.SUCCESS && syncStatus.getSyncStatusResult() != SyncStatus.Result.PARTIALLY_FAILED) {
            logger.debug("SyncStatus result {} is not SUCCESS or PARTIALLY_FAILED, done here.", (Object)syncStatus.getSyncStatusResult());
        }
        long directoryId = connector.getConfiguration().getDirectoryId();
        logger.debug("Sending sync-event for Linchpin from Connector {} with directory {}", (Object)connector.getUniqueId(), (Object)directoryId);
        Properties properties = new Properties();
        properties.setProperty("emitter", "de.resolution.usersync.sync");
        properties.setProperty("directoryId", String.valueOf(directoryId));
        this.eventPublisher.publish((Object)properties);
    }

    @Override
    public void sendUserUpdatedEvent(@Nullable AtlasUserResult atlasUserResult, @Nonnull Connector<?> connector) {
        if (LinchPinEventSenderImpl.hasNoContentProperties(connector)) {
            return;
        }
        if (atlasUserResult == null || !atlasUserResult.getResultingUser().isPresent()) {
            logger.debug("Result is null or no resulting user present, done here.");
            return;
        }
        Properties propertiesForChange = LinchPinEventSenderImpl.createPropertiesForEvent(atlasUserResult);
        if (propertiesForChange == null) {
            return;
        }
        this.eventPublisher.publish((Object)propertiesForChange);
    }

    @Nullable
    public static Properties createPropertiesForEvent(@Nullable AtlasUserResult atlasUserResult) {
        if (atlasUserResult == null) {
            logger.debug("AtlasUserResult is null, returning null");
            return null;
        }
        if (!UserSyncUtils.checkSuccess(atlasUserResult)) {
            logger.debug("Result is not successful, returning null");
            return null;
        }
        if (atlasUserResult.getOperation() == AtlasUserResult.Operation.NOT_MODIFIED) {
            logger.debug("User is not modified, returning null");
            return null;
        }
        if (!atlasUserResult.getResultingUser().isPresent()) {
            logger.debug("No resulting user in result, returning null");
            return null;
        }
        AtlasUser resultingUser = atlasUserResult.getResultingUser().orElseThrow(() -> new AtlasUserRuntimeException("No resulting user present!"));
        AtlasUser initialUser = atlasUserResult.getInitialUser().orElse(null);
        if (!resultingUser.get("ATTR_USER_KEY").isPresent()) {
            logger.warn("No user key in resulting user, returning null");
        }
        String userKey = resultingUser.get("ATTR_USER_KEY").orElseThrow(() -> new AtlasUserRuntimeException("No user key in AtlasUser!"));
        Properties properties = new Properties();
        properties.setProperty("emitter", "de.resolution.usersync.single");
        properties.setProperty("userkey", userKey);
        properties.setProperty("directory", String.valueOf(resultingUser.getReference().getDirectoryId()));
        String payload = JSONUtil.asJson(new BeforeAndAfter(LinchPinEventSenderImpl.createAttributeMapFromAtlasUser(initialUser), LinchPinEventSenderImpl.createAttributeMapFromAtlasUser(resultingUser)));
        properties.setProperty("payload", payload);
        return properties;
    }

    public static Map<String, String> createAttributeMapFromAtlasUser(@Nullable AtlasUser atlasUser) {
        if (atlasUser == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (String key : atlasUser.getAttributeKeys()) {
            atlasUser.get(key).ifPresent(value -> retMap.put(key, (String)value));
        }
        return retMap;
    }

    private static boolean hasNoContentProperties(Connector<?> connector) {
        if (connector.getAttributeTransformerMap().keySet().stream().anyMatch(key -> key.contains("CONFLUENCE.CP."))) {
            return false;
        }
        logger.debug("No content properties mapped, no need to send an Event to Linchpin");
        return true;
    }

    private static class BeforeAndAfter {
        private final Map<String, String> before;
        private final Map<String, String> after;

        public BeforeAndAfter(Map<String, String> before, Map<String, String> after) {
            this.before = before;
            this.after = after;
        }

        public Map<String, String> getBefore() {
            return this.before;
        }

        public Map<String, String> getAfter() {
            return this.after;
        }
    }
}

