/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.testconnector;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.builtin.testconnector.TestConnector;
import de.resolution.usersync.builtin.testconnector.TestConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class TestConnectorConfigurationImpl
extends AbstractConnectorConfigurationImpl
implements TestConnectorConfiguration {
    @Nonnull
    private String emailDomain = "example.com";
    private long minimalTimePerUser = 0L;
    private int count = 10;
    private int groupCount = 5;
    private String testData;
    static final String ATT_EMAIL = "EMAIL";
    static final String ATT_USERID = "USERID";
    static final String ATT_FULLNAME = "FULLNAME";
    public static final String ATT_UID = "Unique_ID";
    private static final String DEFAULT_FIND_BY_ATTRIBUTE_NAME = "Unique_ID";
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();

    public TestConnectorConfigurationImpl() {
    }

    public TestConnectorConfigurationImpl(@Nonnull TestConnectorConfiguration other) {
        super(other);
        this.setEmailDomain(other.getEmailDomain());
        this.setMinimalTimePerUser(other.getMinimalTimePerUser());
        this.setCount(other.getCount());
        this.setGroupCount(other.getGroupCount());
        this.testData = other.getTestData();
    }

    @Override
    @Nonnull
    public String getEmailDomain() {
        return this.emailDomain;
    }

    @Override
    public long getMinimalTimePerUser() {
        return this.minimalTimePerUser;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getGroupCount() {
        return this.groupCount;
    }

    @Override
    @Nullable
    @JsonRawValue
    public String getTestData() {
        return this.testData;
    }

    public void setTestData(JsonNode testData) {
        this.setTestDataString(testData.toString());
    }

    @JsonIgnore
    public void setTestDataString(String testData) {
        this.testData = testData;
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return "Unique_ID";
    }

    public void setEmailDomain(String emailDomain) {
        if (emailDomain != null) {
            this.emailDomain = emailDomain;
        }
    }

    public void setMinimalTimePerUser(long minimalTimePerUser) {
        this.minimalTimePerUser = minimalTimePerUser;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setGroupCount(int groupCount) {
        this.groupCount = groupCount;
    }

    @Override
    @Nonnull
    public TestConnectorConfiguration sanitize() {
        return this;
    }

    @Override
    public Class<? extends Connector<? extends ConnectorConfiguration>> tellConnectorClass() {
        return TestConnector.class;
    }

    static {
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle(ATT_USERID), new Target(Target.Type.SYSTEM, "ATTR_NAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle(ATT_EMAIL), new Target(Target.Type.SYSTEM, "ATTR_EMAIL"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle(ATT_FULLNAME), new Target(Target.Type.SYSTEM, "ATTR_FULLNAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("GROUPS"), new Target(Target.Type.SYSTEM, "ATTR_GROUPS"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createSingle("Unique_ID"), new Target(Target.Type.CROWD, "Unique_ID"), true, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createGroovy("true"), new Target(Target.Type.SYSTEM, "ATTR_ACTIVE"), false, true));
    }
}

