/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserWithAttributes;
import de.resolution.atlasuser.api.UserKeyProvider;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedException;
import de.resolution.atlasuser.api.exception.AtlasUserOperationFailedRuntimeException;
import de.resolution.atlasuser.api.exception.AtlasUserRuntimeException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.api.user.SortBy;
import de.resolution.atlasuser.api.user.UserSearchResult;
import de.resolution.atlasuser.impl.user.UserSearchResultEntry;
import de.resolution.commons.util.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSearchResultImpl
implements UserSearchResult {
    private static final Logger logger = LoggerFactory.getLogger(UserSearchResultImpl.class);
    private final AtlasUserAdapter atlasUserAdapter;
    private final DirectoryManager directoryManager;
    private final UserKeyProvider userKeyProvider;
    private final List<UserSearchResultEntry> entries;
    private static final UserSearchResultEntry.UserSearchResultEntryComparator descendingComparator = new UserSearchResultEntry.UserSearchResultEntryComparator(false);
    private static final UserSearchResultEntry.UserSearchResultEntryComparator ascendingComparator = new UserSearchResultEntry.UserSearchResultEntryComparator(true);
    private boolean cancelled = false;
    private final SortBy sortBy;

    UserSearchResultImpl(@Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull DirectoryManager directoryManager, @Nonnull UserKeyProvider userKeyProvider, @Nonnull SortBy sortBy) {
        this.atlasUserAdapter = atlasUserAdapter;
        this.directoryManager = directoryManager;
        this.entries = new ArrayList<UserSearchResultEntry>();
        this.sortBy = sortBy;
        this.userKeyProvider = userKeyProvider;
    }

    void addAll(@Nullable Collection<UserSearchResultEntry> otherEntries) {
        if (otherEntries != null) {
            this.entries.addAll(otherEntries);
        }
    }

    @Override
    @Nonnull
    public List<Optional<AtlasUser>> retrievePage(int startIndex, int pageSize) throws AtlasUserOperationFailedException {
        if (this.size() < startIndex) {
            return Collections.emptyList();
        }
        int endIndex = startIndex + pageSize > this.size() ? this.size() : startIndex + pageSize;
        List<UserSearchResultEntry> entriesForPage = this.entries.subList(startIndex, endIndex);
        UserSearchResultIterator resultIterator = new UserSearchResultIterator(entriesForPage.iterator(), this.atlasUserAdapter);
        ArrayList<Optional<AtlasUser>> result = new ArrayList<Optional<AtlasUser>>();
        while (resultIterator.hasNext()) {
            try {
                result.add((Optional<AtlasUser>)resultIterator.next());
            }
            catch (AtlasUserOperationFailedRuntimeException e) {
                throw e.getCause();
            }
        }
        return result;
    }

    void sort() {
        if (this.sortBy.isAscending()) {
            this.entries.sort(ascendingComparator);
        } else {
            this.entries.sort(descendingComparator);
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    @Nonnull
    public Iterator<Optional<AtlasUser>> iterator() {
        return new UserSearchResultIterator(this.entries.iterator(), this.atlasUserAdapter);
    }

    @Override
    @Nonnull
    public Iterator<Map<String, String>> coreAttributesIterator() {
        return new CoreAttributesIterator(this.entries.iterator(), this.directoryManager);
    }

    @Override
    @Nonnull
    public Iterator<String> keysIterator() {
        return new KeysIterator(this.entries.iterator(), this.userKeyProvider);
    }

    @Override
    @Nonnull
    public List<String> getUserKeys() {
        ArrayList<String> list = new ArrayList<String>();
        this.keysIterator().forEachRemaining(list::add);
        return list;
    }

    private static class CoreAttributesIterator
    implements Iterator<Map<String, String>> {
        private final Iterator<UserSearchResultEntry> searchResultEntryIterator;
        private final DirectoryManager directoryManager;

        public CoreAttributesIterator(Iterator<UserSearchResultEntry> searchResultEntryIterator, DirectoryManager directoryManager) {
            this.searchResultEntryIterator = searchResultEntryIterator;
            this.directoryManager = directoryManager;
        }

        @Override
        public boolean hasNext() {
            return this.searchResultEntryIterator.hasNext();
        }

        @Override
        public Map<String, String> next() {
            UserSearchResultEntry currentEntry = this.searchResultEntryIterator.next();
            try {
                UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(currentEntry.getDirectoryId(), currentEntry.getUsername());
                HashMap<String, String> coreAttributes = new HashMap<String, String>();
                coreAttributes.put("ATTR_ID", userWithAttributes.getExternalId());
                coreAttributes.put("ATTR_ACTIVE", String.valueOf(userWithAttributes.isActive()));
                coreAttributes.put("ATTR_NAME", userWithAttributes.getName());
                coreAttributes.put("ATTR_FULLNAME", userWithAttributes.getDisplayName());
                coreAttributes.put("ATTR_FIRSTNAME", userWithAttributes.getFirstName());
                coreAttributes.put("ATTR_LASTNAME", userWithAttributes.getLastName());
                coreAttributes.put("ATTR_EMAIL", userWithAttributes.getEmailAddress());
                return coreAttributes;
            }
            catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
                throw new AtlasUserOperationFailedRuntimeException(new AtlasUserOperationFailedException("Reading user failed!"));
            }
        }
    }

    private static class UserSearchResultIterator
    implements Iterator<Optional<AtlasUser>> {
        private final Iterator<UserSearchResultEntry> searchResultEntryIterator;
        private final AtlasUserAdapter atlasUserAdapter;

        private UserSearchResultIterator(Iterator<UserSearchResultEntry> searchResultEntryIterator, AtlasUserAdapter atlasUserAdapter) {
            this.searchResultEntryIterator = searchResultEntryIterator;
            this.atlasUserAdapter = atlasUserAdapter;
        }

        @Override
        public boolean hasNext() {
            return this.searchResultEntryIterator.hasNext();
        }

        @Override
        public Optional<AtlasUser> next() {
            UserSearchResultEntry currentEntry = this.searchResultEntryIterator.next();
            AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create("ATTR_NAME", currentEntry.getUsername(), currentEntry.getDirectoryId()));
            if (readResult.getOperation() != AtlasUserResult.Operation.FAILED) {
                return Optional.of(readResult.getResultingUser()).orElseThrow(() -> new AtlasUserRuntimeException(new AtlasUserOperationFailedException("Resulting user not present in result with success")));
            }
            if (readResult.isNotFound()) {
                return Optional.empty();
            }
            if (logger.isErrorEnabled()) {
                logger.error("Reading user failed: {}", (Object)JSONUtil.asJson(readResult));
            }
            throw new AtlasUserOperationFailedRuntimeException(new AtlasUserOperationFailedException("Reading user failed!"));
        }
    }

    private static class KeysIterator
    implements Iterator<String> {
        private final Iterator<UserSearchResultEntry> searchResultEntryIterator;
        private final UserKeyProvider userKeyProvider;

        public KeysIterator(Iterator<UserSearchResultEntry> searchResultEntryIterator, UserKeyProvider userKeyProvider) {
            this.searchResultEntryIterator = searchResultEntryIterator;
            this.userKeyProvider = userKeyProvider;
        }

        @Override
        public boolean hasNext() {
            return this.searchResultEntryIterator.hasNext();
        }

        @Override
        public String next() {
            UserSearchResultEntry currentEntry = this.searchResultEntryIterator.next();
            return this.userKeyProvider.getUserKeyForUsername(currentEntry.getUsername());
        }
    }
}

