/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth.auditlogservice;

import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.albauth.auditlogservice.AuditLogService;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class JiraAuditLogService
implements AuditLogService {
    private final UserManager userManager;
    private final AuditingManager auditingManager;

    @Autowired
    public JiraAuditLogService(@JiraImport AuditingManager auditingManager, @JiraImport UserManager userManager) {
        this.auditingManager = auditingManager;
        this.userManager = userManager;
    }

    @Override
    public void postMessage(@Nonnull String appName, @Nonnull String msg, @Nonnull UserProfile author) {
        ApplicationUser aAuthor = this.userManager.getUserByKey(author.getUserKey().getStringValue());
        RecordRequest recordRequest = new RecordRequest(AuditingCategory.APPLICATIONS, appName + ": " + msg, appName, aAuthor, null);
        this.auditingManager.store(recordRequest);
    }

    @Override
    public void postMessage(@Nonnull String appName, @Nonnull String msg) {
        RecordRequest recordRequest = new RecordRequest(AuditingCategory.APPLICATIONS, appName + ": " + msg, appName);
        this.auditingManager.store(recordRequest);
    }
}

