/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.albauth;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserProfile;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.albauth.AlbAuthenticationConfiguration;
import de.resolution.albauth.AlbAuthenticationFilter;
import de.resolution.albauth.AlbAuthenticationFrontendDTO;
import de.resolution.albauth.AlbAuthenticationResult;
import de.resolution.albauth.AlbJwtUtils;
import de.resolution.albauth.AppSpecificDataProvider;
import de.resolution.albauth.Defaults;
import de.resolution.albauth.JsonConfigurationLoader;
import de.resolution.albauth.UserSyncRelatedThings;
import de.resolution.albauth.activeobjects.AoConfigurationActiveObjectsProxy;
import de.resolution.albauth.auditlogservice.AuditLogService;
import de.resolution.albauth.configloading.ConfigurationLoadException;
import de.resolution.atlasauth.api.AuthenticationInformation;
import de.resolution.atlasauth.api.AuthenticationResult;
import de.resolution.atlasauth.api.AuthenticationService;
import de.resolution.atlasauth.api.Utils;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.net.IPRangeChecker;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.api.ConfigurationLoadFailedException;
import de.resolution.reconfigure.api.ConfigurationSaveFailedException;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.api.FrontendDTO;
import de.resolution.reconfigure.frontenddefinition.DynamicFragmentProvider;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.retransform.config.AttributeTransformationConfigTranslator;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.retransform.frontend.AttributeMappingOptionProvider;
import de.resolution.usersync.api.SupportInformationGenerator;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.UserSyncService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.frontend.UserSyncFrontendService;
import inet.ipaddr.IPAddressString;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={AlbAuthenticationService.class})
public class AlbAuthenticationService
implements ConfigurationService<AlbAuthenticationConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(AlbAuthenticationService.class);
    private static final Logger loginDebugLogger = LoggerFactory.getLogger((String)"de.resolution.albauth.loginDebugLogger");
    private static final String APP_NAME = "AWS ALB and Amazon Cognito Authentication";
    private static final String CONFIGURATION_UPDATED_MSG = "Configuration updated";
    private static final String APP_NAME_ANALYTICS = "albauth";
    private final AuthenticationService authenticationService;
    private final PluginSettings pluginSettings;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final LicenseChecker licenseChecker;
    private final AppSpecificDataProvider applicationSpecificDataProvider;
    private static final String CONFIG_KEY = "de.resolution.albauth.configuration";
    private static final String MSG_CFG_LOAD_ERROR = "Could not load configuration";
    private static final String AMZN_OIDC_IDENTITY_HEADER_NAME = "x-amzn-oidc-identity";
    private static final String MSG_OIDC_VERIFICATION_FAILURE = "OIDC data token verification failed. See log file for more details.";
    private static final String USER_SYNC_CONNECTOR_UID = "userSyncConnectorUID";
    private final UserSyncService userSyncService;
    private final AtlasUserAdapter atlasUserAdapter;
    private final UserSyncFrontendService userSyncFrontendService;
    private final AttributeMappingOptionProvider attributeMappingOptionProvider;
    private final AttributeTransformationConfigValidator attributeTransformationConfigValidator;
    private final AoConfigurationActiveObjectsProxy aoConfigProxy;
    private final AuditLogService auditLogService;
    private final SupportInformationGenerator userSyncSupportInfosGenerator;

    @Autowired
    public AlbAuthenticationService(AuthenticationService authenticationService, AppSpecificDataProvider applicationSpecificDataProvider, @ComponentImport PluginSettingsFactory pluginSettingsFactory, LicenseChecker licenseChecker, UserSyncService userSyncService, UserSyncFrontendService userSyncFrontendService, AtlasUserAdapter atlasUserAdapter, AttributeMappingOptionProvider attributeMappingOptionProvider, AttributeTransformationConfigValidator attributeTransformationConfigValidator, AoConfigurationActiveObjectsProxy aoConfigProxy, AuditLogService auditLogService, SupportInformationGenerator userSyncSupportInfosGenerator) {
        this.licenseChecker = licenseChecker;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.authenticationService = authenticationService;
        this.applicationSpecificDataProvider = applicationSpecificDataProvider;
        this.userSyncService = userSyncService;
        this.atlasUserAdapter = atlasUserAdapter;
        this.userSyncFrontendService = userSyncFrontendService;
        this.attributeMappingOptionProvider = attributeMappingOptionProvider;
        this.attributeTransformationConfigValidator = attributeTransformationConfigValidator;
        this.aoConfigProxy = aoConfigProxy;
        this.auditLogService = auditLogService;
        this.userSyncSupportInfosGenerator = userSyncSupportInfosGenerator;
    }

    @Override
    public AlbAuthenticationConfiguration update(AlbAuthenticationConfiguration config, ValidationResult validationResult, String uiPath, UserProfile user) throws ConfigurationSaveFailedException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Updating config {}", (Object)Utils.toJson(config));
            }
            String configString = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(config);
            if (user != null && user.getUsername() != null) {
                this.aoConfigProxy.storeConfig(user.getUsername(), System.currentTimeMillis(), config.getVersion(), configString);
                this.auditLogService.postMessage(APP_NAME, CONFIGURATION_UPDATED_MSG, user);
            } else {
                logger.warn("Cannot get user who saved the config, using 'someAdmin' instead.");
                this.aoConfigProxy.storeConfig("someAdmin", System.currentTimeMillis(), config.getVersion(), configString);
                this.auditLogService.postMessage(APP_NAME, CONFIGURATION_UPDATED_MSG);
            }
        }
        catch (Exception e) {
            throw new ConfigurationSaveFailedException(e);
        }
        return config;
    }

    @Override
    public String getPluginFamily() {
        return APP_NAME_ANALYTICS;
    }

    @Override
    public AlbAuthenticationConfiguration getConfiguration(HttpServletRequest request, UserProfile userProfile, String uipath) throws ConfigurationLoadFailedException {
        return this.loadConfiguration();
    }

    public AlbAuthenticationConfiguration getConfiguration() throws ConfigurationLoadFailedException {
        return this.loadConfiguration();
    }

    public AlbAuthenticationConfiguration loadAndMigrate(String configString) throws ConfigurationLoadFailedException {
        try {
            return JsonConfigurationLoader.migrateAndLoadConfig(configString);
        }
        catch (ConfigurationLoadException e) {
            throw new ConfigurationLoadFailedException(e);
        }
    }

    public AlbAuthenticationConfiguration applyEmptyConfig() {
        try {
            return this.update(this.emptyConfig(), (ValidationResult)null, (String)null, (UserProfile)null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AlbAuthenticationConfiguration emptyConfig() {
        return new AlbAuthenticationConfiguration(AlbAuthenticationConfiguration.OidcType.AZURE, "x-amzn-oidc-accesstoken", "upn", true, true, "", true, "", true, false, Collections.emptyList(), this.applicationSpecificDataProvider.getDefaultInjectAuthenticationUrls(), true, "nosso", false, 1, false, "None", UserSyncRelatedThings.DEFAULT_USERSYNC_LOOKUP, false, "<html>\n <head>\n  <title>Login failed</title>\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n  <body class=\"aui-page-focused aui-page-medium\" >\n   <div class=\"aui-page-panel\">\n    <div class=\"aui-page-panel-inner\">\n     <section class=\"aui-page-panel-content\">\n      <h1>Login failed</h1>\n      <br>\n      <div>Your login failed because\n      #if($message)\n       <div class=\"aui-message error\">$message</div>\n      #end\n     </section>\n    </div>\n   </div>\n </body>\n</html>", false, false, "", Defaults.getNoInjectUrls(), 2);
    }

    private AlbAuthenticationConfiguration loadConfiguration() throws ConfigurationLoadFailedException {
        String configFromOurTable = this.aoConfigProxy.retrieveLastConfig();
        if (configFromOurTable != null) {
            logger.debug("Fetched a config from the database and will apply this");
            return this.loadAndMigrate(configFromOurTable);
        }
        logger.debug("Will load config from user properties");
        String configFromProperties = (String)this.pluginSettings.get(CONFIG_KEY);
        if (configFromProperties == null) {
            return this.emptyConfig();
        }
        return this.loadAndMigrate(configFromProperties);
    }

    @Nonnull
    AlbAuthenticationResult injectAuthentication(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        AuthenticationResult resultFromService;
        String userName;
        AlbAuthenticationConfiguration config;
        LicenseStatus licenseStatus = this.licenseChecker.checkLicense();
        if (licenseStatus.isEnforced() && !licenseStatus.isLicensed()) {
            logger.warn("No valid license {}", (Object)licenseStatus.getMessage());
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.SKIPPED, "Not licensed: " + licenseStatus.getMessage(), null, null);
        }
        try {
            config = this.loadConfiguration();
        }
        catch (ConfigurationLoadFailedException e) {
            logger.warn("Loading configuration failed {}", (Object)e.getMessage());
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, MSG_CFG_LOAD_ERROR, null, null);
        }
        if (config.isSkipLogin() && servletRequest.getHeader(config.getSkipHeaderName()) != null) {
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.SKIPPED, "Skipped login because of present header", null, null);
        }
        if (config.isRedirectOnLogout()) {
            HttpSession session = servletRequest.getSession(false);
            if (session != null && session.getAttribute(AlbAuthenticationFilter.DO_SD_LOGOUT) != null) {
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.SD_LOGOUT_STEP_2, "SD Users wants to perform logout - step 2", null, null);
            }
            if (this.authenticationService.isSdLogoutUrl(servletRequest) && this.authenticationService.getLoggedInUsername(servletRequest) != null) {
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.SD_LOGOUT_STEP_1, "SD Users wants to perform logout - step 1", null, null);
            }
            if (this.authenticationService.isLogoutUrl(servletRequest) && this.authenticationService.getLoggedInUsername(servletRequest) != null) {
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.LOGOUT, "Users wants to perform logout", null, null);
            }
        }
        String requestUri = servletRequest.getRequestURI();
        String destination = null;
        if (AlbAuthenticationService.urlMatches(requestUri, config.getNoInjectUrls())) {
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.SKIPPED, "URL " + requestUri + " is not for authentication", null, AlbAuthenticationResult.Reason.NONAUTHURL);
        }
        if (this.authenticationService.isLoginUrl(servletRequest)) {
            destination = servletRequest.getParameter(this.authenticationService.getDestinationUrlParameterName());
            if (destination == null || destination.isEmpty()) {
                destination = "/";
            }
        } else {
            if (!AlbAuthenticationService.urlMatches(requestUri, config.getInjectAuthenticationUrls())) {
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.SKIPPED, "URL " + requestUri + " is not for authentication", null, AlbAuthenticationResult.Reason.NONAUTHURL);
            }
            if (this.authenticationService.getLoggedInUsername(servletRequest) != null) {
                String loggedInUserName = this.authenticationService.getLoggedInUsername(servletRequest);
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ALREADY_AUTHORIZED, "Username " + loggedInUserName + " is already logged in", AuthenticationInformation.builder().username(loggedInUserName).build(), AlbAuthenticationResult.Reason.USER_PRESENT);
            }
        }
        if (config.getTokenHeaderName() == null) {
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.SKIPPED, "No token header name configured", null, AlbAuthenticationResult.Reason.OTHER);
        }
        String jwtFromHeader = servletRequest.getHeader(config.getTokenHeaderName());
        logger.debug("Content of {} header is: {}", (Object)config.getTokenHeaderName(), (Object)servletRequest.getHeader(config.getTokenHeaderName()));
        if (jwtFromHeader == null) {
            return new AlbAuthenticationResult(AuthenticationResult.builder().outcome(AuthenticationResult.Outcome.ERROR).message("No content in header " + config.getTokenHeaderName()).authenticationInformation(AuthenticationInformation.builder().username("NONE").build()).build(), AlbAuthenticationResult.Reason.OTHER);
        }
        DecodedJWT jwt = null;
        if (!config.getTokenHeaderName().equalsIgnoreCase(AMZN_OIDC_IDENTITY_HEADER_NAME)) {
            try {
                jwt = JWT.decode(jwtFromHeader);
            }
            catch (JWTDecodeException jwtDecodeException) {
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, "Could not decode JWT: " + jwtDecodeException.getMessage(), null, null);
            }
        }
        if (!(config.getTokenHeaderName().equalsIgnoreCase(AMZN_OIDC_IDENTITY_HEADER_NAME) || jwt != null && jwt.getClaim(config.getUserNameClaim()) != null)) {
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, "Could not read username from claim name \"" + config.getUserNameClaim() + "\"", null, null);
        }
        String oidcDataToken = servletRequest.getHeader("x-amzn-oidc-data");
        logger.trace("oidcDataToken: {}", (Object)oidcDataToken);
        boolean isValidOidcDataToken = this.isValidOidcDataToken(oidcDataToken, config);
        logger.debug("isValidOidcDataToken = {}", (Object)isValidOidcDataToken);
        if (!isValidOidcDataToken) {
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, MSG_OIDC_VERIFICATION_FAILURE, null, null);
        }
        if (config.getTokenHeaderName().equalsIgnoreCase(AMZN_OIDC_IDENTITY_HEADER_NAME)) {
            userName = servletRequest.getHeader(config.getTokenHeaderName());
            if (loginDebugLogger.isDebugEnabled()) {
                loginDebugLogger.debug("Searching user to login by username={}", (Object)userName);
            }
        } else {
            if (jwt == null) {
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, "Decoded JWT is null, can't proceed with authentication.", null, null);
            }
            userName = jwt.getClaim(config.getUserNameClaim()).asString();
            if (loginDebugLogger.isDebugEnabled()) {
                loginDebugLogger.debug("Found the following claims for login\n{}", (Object)JSONUtil.asJson(UserSyncRelatedThings.extractClaimsFromIdToken(jwt)));
                loginDebugLogger.debug("Searching for username with following claim: \"{}\"", (Object)config.getUserNameClaim());
                loginDebugLogger.debug("Searching user to login by username: {}", (Object)userName);
            }
        }
        logger.debug("userName: {}", (Object)userName);
        if (userName == null) {
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.FAILED, "Could not find a username in JWT.", null, AlbAuthenticationResult.Reason.OTHER);
        }
        AuthenticationInformation authenticationInformation = AuthenticationInformation.builder().username(userName).build();
        String remoteAddress = servletRequest.getRemoteAddr();
        if (!IPRangeChecker.isInRange(remoteAddress, config.getAllowedIpRanges())) {
            return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, "Remote address " + remoteAddress + " is not in allowed ranges", authenticationInformation, AlbAuthenticationResult.Reason.INVALIDIP);
        }
        if (config.isCheckIal() && jwt != null) {
            Claim ialValueFromToken = jwt.getClaim("ial");
            if (ialValueFromToken == null) {
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, "Skipped login because of missing ial", null, null);
            }
            try {
                int parsedIal = Integer.parseInt(ialValueFromToken.asString());
                if (parsedIal < config.getIalLevel()) {
                    return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, "Retrieved ial is smaller than configured value, abort login", null, null);
                }
            }
            catch (NumberFormatException e) {
                logger.error("Could not parse ial to integer, because {}", (Object)e.getMessage());
                return this.createAlbAuthenticationResult(AuthenticationResult.Outcome.ERROR, "Error during ial parsing, please see logs", null, null);
            }
        }
        if (config.isUpdateWithUserSync()) {
            String usernameFromUserSync;
            if (config.getUserSyncConnectorUID() != null && !config.getUserSyncConnectorUID().equals("None") && (usernameFromUserSync = this.handleUserSyncUpdate(config, jwt, servletRequest)) != null) {
                authenticationInformation = AuthenticationInformation.builder().username(usernameFromUserSync).build();
            }
        } else {
            logger.error("Cannot sync user. Usersync connector id={} is either null or 'NONE'", (Object)config.getUserSyncConnectorUID());
        }
        if ((resultFromService = this.authenticationService.injectAuthentication(authenticationInformation, config, servletRequest, servletResponse)).getOutcome() == AuthenticationResult.Outcome.SUCCESS) {
            if (destination != null) {
                destination = this.authenticationService.getRedirectURL(false, destination, "/");
                try {
                    servletResponse.sendRedirect(destination);
                }
                catch (IOException e) {
                    logger.error("Redirection to {} failed: ", (Object)destination, (Object)e);
                    return new AlbAuthenticationResult(AuthenticationResult.builder().outcome(AuthenticationResult.Outcome.ERROR).responseCommitted(false).authenticationInformation(authenticationInformation).message("Redirection failed: " + e.getMessage()).build(), AlbAuthenticationResult.Reason.OTHER);
                }
            }
            return new AlbAuthenticationResult(AuthenticationResult.builder(resultFromService).responseCommitted(destination != null).build(), AlbAuthenticationResult.Reason.OTHER);
        }
        return new AlbAuthenticationResult(resultFromService, AlbAuthenticationResult.Reason.OTHER);
    }

    @Nullable
    private String handleUserSyncUpdate(@Nonnull AlbAuthenticationConfiguration config, @Nullable DecodedJWT jwt, @Nonnull HttpServletRequest servletRequest) {
        AtlasUserResult result;
        SyncSingleUserResult syncSingleUserResult;
        StructuredData attributeData = UserSyncRelatedThings.extractClaimsFromIdToken(jwt);
        String connectorLookupAttributeValue = this.getConnectorLookupAttributeValue(config, servletRequest, attributeData);
        if (connectorLookupAttributeValue == null) {
            logger.error("Cannot lookup a user with UserSync if there is no connectorLookupAttributeValue present");
            return null;
        }
        try {
            syncSingleUserResult = this.userSyncService.syncSingleUser(connectorLookupAttributeValue, attributeData.asMap(), null, config.getUserSyncConnectorUID());
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException | ConnectorNotAvailableException | ConnectorNotFoundException e) {
            logger.error("Updating user from connector failed: {}", (Object)e.getMessage());
            return null;
        }
        if (loginDebugLogger.isTraceEnabled()) {
            loginDebugLogger.trace("SyncSingleUserResult has status {}", (Object)syncSingleUserResult.getStatus());
        }
        if (loginDebugLogger.isDebugEnabled()) {
            loginDebugLogger.debug("SyncSingleUserResult: {} ", (Object)Utils.toJson(syncSingleUserResult));
        }
        if ((result = syncSingleUserResult.getUpdateUserResult()) == null) {
            logger.info("SyncSingleUserResult contained no AtlasUserResult");
            if (logger.isDebugEnabled()) {
                logger.debug("SyncSingleUserResult: {} ", (Object)Utils.toJson(syncSingleUserResult));
            }
            return null;
        }
        Optional<AtlasUser> optionalResultingUser = result.getResultingUser();
        if (result.isSuccess() && optionalResultingUser.isPresent()) {
            AtlasUser resultingUser = optionalResultingUser.get();
            return resultingUser.getName();
        }
        String messages = String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)result.getMessages().orElse(Collections.singletonList("undefined error")));
        logger.error("Updating user from connector failed, result was not SUCCESS or resulting user was not present: {}", (Object)messages);
        return null;
    }

    @Nullable
    private String getConnectorLookupAttributeValue(@Nonnull AlbAuthenticationConfiguration config, @Nonnull HttpServletRequest servletRequest, @Nonnull StructuredData attributeData) {
        AttributeTransformationResult userSyncLookupTransformerResult;
        if (config.getTokenHeaderName().equalsIgnoreCase(AMZN_OIDC_IDENTITY_HEADER_NAME)) {
            return servletRequest.getHeader(config.getTokenHeaderName());
        }
        AttributeTransformer userSyncLookupTransformer = new AttributeTransformationConfigTranslator(Collections.singletonList(config.getUserSyncLookupTransformation())).withAtlasUserAdapter(this.atlasUserAdapter).translate().values().iterator().next();
        try {
            userSyncLookupTransformerResult = userSyncLookupTransformer.transform(attributeData.asMap());
        }
        catch (TransformationFailedException e) {
            logger.error("userSyncLookupTransformation failed");
            return null;
        }
        if (userSyncLookupTransformerResult != null) {
            return userSyncLookupTransformerResult.getFirstValue();
        }
        logger.error("User lookup transform failed");
        return null;
    }

    @Nonnull
    private AlbAuthenticationResult createAlbAuthenticationResult(@Nullable AuthenticationResult.Outcome outcome, @Nullable String message, @Nullable AuthenticationInformation authenticationInformation, @Nullable AlbAuthenticationResult.Reason reason) {
        if (authenticationInformation == null) {
            authenticationInformation = AuthenticationInformation.builder().username("NONE").build();
        }
        if (reason == null) {
            reason = AlbAuthenticationResult.Reason.OTHER;
        }
        if (outcome == null) {
            outcome = AuthenticationResult.Outcome.ERROR;
        }
        if (message == null) {
            message = "No message";
        }
        return new AlbAuthenticationResult(AuthenticationResult.builder().outcome(outcome).message(message).authenticationInformation(authenticationInformation).build(), reason);
    }

    private boolean isValidOidcDataToken(String oidcDataToken, AlbAuthenticationConfiguration albAuthenticationConfiguration) {
        String oidcDataTokenArn;
        String oidcDataTokenIssuer;
        DecodedJWT decodedOidcDataToken;
        try {
            decodedOidcDataToken = JWT.decode(oidcDataToken);
        }
        catch (JWTDecodeException jwtDecodeException) {
            logger.debug("Could not decode oidcDataToken: {}", (Object)jwtDecodeException.getMessage());
            return false;
        }
        String kid = decodedOidcDataToken.getKeyId();
        String signer = decodedOidcDataToken.getHeaderClaim("signer").asString();
        String region = AlbJwtUtils.extractRegion(signer);
        if (region == null) {
            logger.error("Could not extract region from signer: {}", (Object)signer);
            return false;
        }
        String oidcDataTokenAlgorithm = decodedOidcDataToken.getAlgorithm();
        logger.debug("oidcDataTokenAlgorithm: {}, oidcDataToken region: {}, oidcDataToken keyId: {}", new Object[]{oidcDataTokenAlgorithm, region, kid});
        String publicKeyString = AlbJwtUtils.getPublicKeyString(region, kid);
        if (publicKeyString == null) {
            logger.error("Could not retrieve public key required for oidcDataToken verification. Aborting.");
            return false;
        }
        if (publicKeyString.isEmpty()) {
            logger.error("Public Key String is empty.");
            return false;
        }
        logger.debug("publicKeyString: {}", (Object)publicKeyString);
        PublicKey publicKey = AlbJwtUtils.createPublicKeyFromString(publicKeyString);
        Algorithm algorithm = Algorithm.ECDSA256((ECPublicKey)publicKey, null);
        try {
            JWTVerifier jwtVerifier = albAuthenticationConfiguration.isVerifyIssuer() && albAuthenticationConfiguration.getIssuerUrl() != null && !albAuthenticationConfiguration.getIssuerUrl().isEmpty() ? JWT.require(algorithm).withIssuer(albAuthenticationConfiguration.getIssuerUrl()).build() : JWT.require(algorithm).build();
            jwtVerifier.verify(oidcDataToken);
        }
        catch (JWTVerificationException jwtVerificationException) {
            logger.error("oidcDataToken verification failed: {}", (Object)jwtVerificationException.getMessage());
            return false;
        }
        if (albAuthenticationConfiguration.isVerifyIssuer() && !(oidcDataTokenIssuer = decodedOidcDataToken.getHeaderClaim("iss").asString()).equalsIgnoreCase(albAuthenticationConfiguration.getIssuerUrl())) {
            logger.error("Issuer verification failed. Issuer in token: {}, issuer according to config: {}", (Object)oidcDataTokenIssuer, (Object)albAuthenticationConfiguration.getIssuerUrl());
            return false;
        }
        if (albAuthenticationConfiguration.isVerifyArn() && !(oidcDataTokenArn = decodedOidcDataToken.getHeaderClaim("signer").asString()).equalsIgnoreCase(albAuthenticationConfiguration.getArn())) {
            logger.error("ARN verification failed. ARN in token: {}, ARN according to config: {}", (Object)oidcDataTokenArn, (Object)albAuthenticationConfiguration.getArn());
            return false;
        }
        return true;
    }

    @Override
    public Predicate<UserProfile> getRequiredPrivilege(PrivilegeChecker.PrivilegeFactory privilegeFactory, PrivilegeChecker.AccessMode accessMode, String uiPath) {
        return privilegeFactory.isSysadmin();
    }

    @Override
    public FrontendDTO<AlbAuthenticationConfiguration> getFrontendDTO(HttpServletRequest request, UserProfile userProfile, String uipath) throws ConfigurationLoadFailedException {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("injectAuthenticationUrls", this.applicationSpecificDataProvider.getDefaultInjectAuthenticationUrls());
        defaults.put("userIdDefaultAttribute", UserSyncRelatedThings.DEFAULT_USERSYNC_LOOKUP);
        defaults.put("errorPageTemplate", "<html>\n <head>\n  <title>Login failed</title>\n  <meta name=\"decorator\" content=\"atl.general\">\n </head>\n  <body class=\"aui-page-focused aui-page-medium\" >\n   <div class=\"aui-page-panel\">\n    <div class=\"aui-page-panel-inner\">\n     <section class=\"aui-page-panel-content\">\n      <h1>Login failed</h1>\n      <br>\n      <div>Your login failed because\n      #if($message)\n       <div class=\"aui-message error\">$message</div>\n      #end\n     </section>\n    </div>\n   </div>\n </body>\n</html>");
        defaults.put("noInjectUrls", Defaults.getNoInjectUrls());
        HashMap<String, Object> frontendState = new HashMap<String, Object>();
        this.userSyncFrontendService.addUserSyncFrontendState(frontendState);
        HashMap<String, Object> backendState = new HashMap<String, Object>();
        backendState.put("newAttributeMappings", this.attributeMappingOptionProvider.getOptions());
        backendState.put("connectorDescriptions", this.userSyncFrontendService.getConnectorDescriptions());
        HashMap<String, Map<String, String>> selectionLists = new HashMap<String, Map<String, String>>();
        selectionLists.put("connectors", UserSyncRelatedThings.createConnectorList(this.userSyncService));
        return new AlbAuthenticationFrontendDTO(this.loadConfiguration(), this.licenseChecker.checkLicense(), this.validate(this.loadConfiguration(), uipath), defaults, frontendState, backendState, selectionLists);
    }

    @Override
    public ValidationResult validate(AlbAuthenticationConfiguration configuration, String uipath) {
        ValidationResult validationResult = ValidationResult.create();
        if (configuration.getTokenHeaderName() == null || configuration.getTokenHeaderName().isEmpty()) {
            validationResult.add("tokenHeaderName", "Token header name must not be empty", null);
        }
        if (!configuration.getTokenHeaderName().equalsIgnoreCase(AMZN_OIDC_IDENTITY_HEADER_NAME) && (configuration.getUserNameClaim() == null || configuration.getUserNameClaim().isEmpty())) {
            validationResult.add("userNameClaim", "Username claim must not be empty", null);
        }
        if (configuration.isVerifyIssuer() && (configuration.getIssuerUrl() == null || configuration.getIssuerUrl().isEmpty())) {
            validationResult.add("issuerUrl", "Please provide the issuer which you can find in the ALB OIDC settings", null);
        }
        if (configuration.isVerifyArn() && (configuration.getArn() == null || configuration.getArn().isEmpty())) {
            validationResult.add("arn", "Please provide the Amazon Resource Name (ARN)", null);
        }
        if (configuration.getAllowedIpRanges() != null && !configuration.getAllowedIpRanges().isEmpty()) {
            ValidationResult ipRangeResult = ValidationResult.create();
            int ipindex = 0;
            for (String current : configuration.getAllowedIpRanges()) {
                if (current == null || current.trim().isEmpty()) {
                    ipRangeResult.add(ipindex, "this value must not be empty", null);
                } else {
                    IPAddressString currentIp = new IPAddressString(current);
                    if (!currentIp.isValid()) {
                        ipRangeResult.add(ipindex, "this is no valid IP-address range", null);
                    } else {
                        ipRangeResult.add(ipindex, ValidationResult.create());
                    }
                }
                ++ipindex;
            }
            validationResult.add("allowedIpRanges", ipRangeResult);
        }
        validationResult.add("injectAuthenticationUrls", this.validateRegexList(configuration.getInjectAuthenticationUrls()));
        validationResult.add("noInjectUrls", this.validateRegexList(configuration.getNoInjectUrls()));
        if (configuration.isSkipLogin() && (configuration.getSkipHeaderName() == null || configuration.getSkipHeaderName().isEmpty())) {
            validationResult.add("skipHeaderName", "Please enter the name of the skip login header!");
        }
        if (configuration.isCheckIal() && Stream.of(1, 2, 3).noneMatch(i -> configuration.getIalLevel() == i.intValue())) {
            validationResult.add("ialLevel", "The Identity Assurance Level is not 1,2 or 3");
        }
        if (configuration.isUpdateWithUserSync()) {
            validationResult.add("userSyncLookupTransformation", this.attributeTransformationConfigValidator.validate(configuration.getUserSyncLookupTransformation()));
            if (this.userSyncService.getAvailableConnectorNamesAndUniqueIds().isEmpty()) {
                validationResult.add(USER_SYNC_CONNECTOR_UID, "No UserSync connectors are configured, please configure UserSync first.", null);
            } else if (configuration.getUserSyncConnectorUID() == null || configuration.getUserSyncConnectorUID().equals("None")) {
                validationResult.add(USER_SYNC_CONNECTOR_UID, "You have to choose the connector that corresponds with your IdP to use this functionality.", null);
            } else if (this.userSyncService.getAvailableConnectorNamesAndUniqueIds().stream().noneMatch(curr -> ((String)curr.getValue()).equals(configuration.getUserSyncConnectorUID()))) {
                validationResult.add(USER_SYNC_CONNECTOR_UID, "The configured connector is no longer available, probably it got deleted. Please finish/fix the UserSync configuration first before enabling this functionality.", null);
            }
        }
        if (configuration.isShowErrorPage() && (configuration.getErrorPageTemplate() == null || configuration.getErrorPageTemplate().isEmpty())) {
            validationResult.add("errorPageTemplate", "You must enter an error page template. Use the 'Reset to Default' button when in doubt!");
        }
        if (configuration.isRedirectOnLogout() && (configuration.getRedirectTargetOnLogout() == null || configuration.getRedirectTargetOnLogout().isEmpty())) {
            validationResult.add("redirectTargetOnLogout", "You must provide an url to redirect users to after logout!");
        }
        return validationResult;
    }

    private ValidationResult validateRegexList(List<String> regexList) {
        ValidationResult injectAuthenticationUrlsResult = ValidationResult.create();
        int urlindex = 0;
        for (String current : regexList) {
            if (current == null || current.trim().isEmpty()) {
                injectAuthenticationUrlsResult.add(urlindex, "this value must not be empty", null);
            } else {
                try {
                    Pattern.compile(current);
                    injectAuthenticationUrlsResult.add(ValidationResult.create());
                }
                catch (Exception e) {
                    injectAuthenticationUrlsResult.add(urlindex, "this is no valid Regex: " + e.getMessage(), null);
                }
            }
            ++urlindex;
        }
        return injectAuthenticationUrlsResult;
    }

    @Override
    public Map<String, Object> getSupportInformation(HttpServletRequest request, UserProfile userProfile, String uiPath, Map<String, Object> supportInformation, List<String> trackerIds) throws ConfigurationLoadFailedException {
        supportInformation.put("config", this.loadConfiguration());
        if (this.userSyncSupportInfosGenerator != null) {
            supportInformation.put("userSyncConfiguration", this.userSyncSupportInfosGenerator.generate(true));
        }
        return supportInformation;
    }

    private static boolean urlMatches(String url, List<String> patternsToMatch) {
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        for (String pattern : patternsToMatch) {
            try {
                if (!url.matches(pattern)) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                logger.warn("Pattern {}  is not valid", (Object)pattern, (Object)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public DynamicFragmentProvider getDynamicFragmentProvider() {
        return this.userSyncFrontendService.getDynamicFrontendProvider();
    }

    @Override
    public ValidationResult validateFrontendStateFragment(String jsonString, String uiPath, String frontendStatePath) throws IOException {
        return this.userSyncFrontendService.validateFrontendStateFragment(jsonString, uiPath, frontendStatePath);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse resp) {
        return this.authenticationService.logout(request, resp);
    }
}

