/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.GsonJsonValue;
import com.github.wnameless.json.base.JsonCore;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.Reader;

public class GsonJsonCore
implements JsonCore<GsonJsonValue> {
    private final Gson gson;

    public GsonJsonCore() {
        this.gson = new GsonBuilder().serializeNulls().create();
    }

    public GsonJsonCore(Gson gson) {
        if (gson == null) {
            throw new NullPointerException();
        }
        this.gson = gson;
    }

    public GsonJsonValue parse(String json) {
        return new GsonJsonValue(this.gson.fromJson(json, JsonElement.class));
    }

    public GsonJsonValue parse(Reader jsonReader) throws IOException {
        return new GsonJsonValue(this.gson.fromJson(jsonReader, JsonElement.class));
    }
}

