/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.commons.validate.api.ValidationResultWithId;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.Notification;
import de.resolution.usersync.api.NotificationService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="importExportRestResource")
@Path(value="/usersync/importexport")
public class ImportExportRestResource {
    private static final Logger logger = LoggerFactory.getLogger(ImportExportRestResource.class);
    private static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorService connectorService;
    private final NotificationService notificationService;

    @Inject
    public ImportExportRestResource(PrivilegeChecker privilegeChecker, ConnectorService connectorService, NotificationService notificationService) {
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
        this.notificationService = notificationService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response exportAll(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        List configs = this.connectorService.getConnectors().stream().map(cvr -> cvr.getConnector().getConfiguration()).collect(Collectors.toList());
        String configsAsJson = JSONUtil.asJson(configs);
        return Response.ok().entity((Object)configsAsJson).cacheControl(ccNoCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response exportSingle(@PathParam(value="id") String id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, ConfigurationFailedException, ConnectorFactoryNotAvailableException {
        this.privilegeChecker.checkSysAdmin(request);
        try {
            ConnectorAndValidationResult conn = this.connectorService.getConnectorByUniqueId(id);
            String configAsJson = JSONUtil.asJson(conn.getConnector().getConfiguration());
            return Response.ok().entity((Object)configAsJson).cacheControl(ccNoCache).build();
        }
        catch (ConnectorNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(ccNoCache).build();
        }
    }

    boolean jsonLooksOk(JsonNode jsonNode) {
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (JsonNode current : arrayNode) {
                if (this.connectorJsonLooksOk(current)) continue;
                return false;
            }
            return true;
        }
        return this.connectorJsonLooksOk(jsonNode);
    }

    boolean connectorJsonLooksOk(JsonNode jsonNode) {
        return jsonNode.hasNonNull("uniqueId") && jsonNode.hasNonNull("connectorClass") && jsonNode.hasNonNull("name");
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    public Response importConnectors(String jsonString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        JsonNode jsonNode = JSONUtil.asJsonNode(jsonString);
        if (!this.jsonLooksOk(jsonNode)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)" {\"message\": \"JSON does not look like a connector or a list of connectors\"}").build();
        }
        ArrayList<ValidationResultWithId> validationResults = new ArrayList<ValidationResultWithId>();
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (JsonNode currentNode : arrayNode) {
                ValidationResultWithId currentValidationResult = this.importSingleConnector(currentNode);
                validationResults.add(currentValidationResult);
            }
            return Response.ok().entity((Object)ImportExportRestResource.createResponseEntityString(validationResults)).cacheControl(ccNoCache).build();
        }
        ValidationResultWithId result = this.importSingleConnector(jsonNode);
        return Response.ok().entity((Object)ImportExportRestResource.createResponseEntityString(Collections.singletonList(result))).cacheControl(ccNoCache).build();
    }

    public static String createResponseEntityString(List<ValidationResultWithId> validationResultWithIds) {
        return JSONUtil.asJsonWithoutNullOrEmpty(validationResultWithIds);
    }

    @Nonnull
    public ValidationResultWithId importSingleConnector(@Nonnull JsonNode configurationNode) {
        boolean addedNotification = false;
        String uniqueId = JSONUtil.readString(configurationNode, "uniqueId");
        if (StringUtil.isNullOrEmpty(uniqueId)) {
            ValidationResult result = ValidationResult.create();
            result.add("uniqueId", "uniqueId must be set");
            this.notificationService.add(Notification.createForConnector("Unique ID must be set", Notification.Level.ERROR, "UNKNOWN_UID"));
            return ValidationResultWithId.create(result, "unknown");
        }
        String connectorClass = JSONUtil.readString(configurationNode, "connectorClass");
        if (connectorClass == null) {
            ValidationResult result = ValidationResult.create();
            result.add("connectorClass", "connectorClass must be set");
            this.notificationService.add(Notification.createForConnector(uniqueId + ": connectorClass must be set", Notification.Level.ERROR, uniqueId));
            return ValidationResultWithId.create(result, uniqueId);
        }
        logger.debug("Connector class is {}", (Object)connectorClass);
        if (this.connectorService.connectorExists(uniqueId)) {
            logger.debug("Connector {} exists already, applying configuration", (Object)uniqueId);
            try {
                Object existingConfig = this.connectorService.getConnectorByUniqueId(uniqueId).getConnector().getConfiguration();
                long existingDirectory = existingConfig.getDirectoryId();
                long newDirectory = JSONUtil.readLong(configurationNode, "directoryId");
                String directoryMessage = null;
                if (newDirectory != existingDirectory) {
                    JSONUtil.updateValue(configurationNode, "directoryId", existingDirectory);
                    directoryMessage = "Kept existing directory id " + existingDirectory + " instead of updating it to " + newDirectory;
                }
                ConnectorAndValidationResult cvr = this.connectorService.configure(uniqueId, configurationNode);
                ValidationResultWithId validationResult = ValidationResultWithId.create(cvr.getValidationResult());
                validationResult.removeEmptyChildren();
                if (directoryMessage != null) {
                    validationResult.add("directoryId", null, directoryMessage);
                    this.notificationService.add(Notification.createForConnector(cvr.getConnector().getName() + ": " + directoryMessage, Notification.Level.WARNING, uniqueId));
                    addedNotification = true;
                }
                if (!validationResult.isValid()) {
                    String msgId = Notification.generateMessageId();
                    this.notificationService.add(Notification.createForConnector(cvr.getConnector().getName() + ": Connector configuration is not valid and has not been applied. Search logs for " + msgId + " for details.", Notification.Level.ERROR, msgId, uniqueId));
                    if (logger.isErrorEnabled()) {
                        logger.warn(" {}: Imported configuration is invalid and was not applied to existing connector: {}", (Object)msgId, (Object)JSONUtil.asJson(validationResult));
                    }
                    addedNotification = true;
                }
                if (!addedNotification) {
                    this.notificationService.add(Notification.createForConnector(cvr.getConnector().getName() + " has been updated.", Notification.Level.INFO, uniqueId));
                }
                return validationResult;
            }
            catch (Exception e) {
                ValidationResult result = ValidationResult.create();
                result.addError(e.getClass().getName() + ": " + e.getMessage());
                this.notificationService.add(Notification.createForConnector(e.getClass().getName() + ": " + e.getMessage(), Notification.Level.ERROR, uniqueId));
                return ValidationResultWithId.create(result, uniqueId);
            }
        }
        logger.debug("Connector {} seems to be an new connector", (Object)uniqueId);
        return this.importNewConnector(configurationNode, addedNotification);
    }

    @Nonnull
    private ValidationResultWithId importNewConnector(@Nonnull JsonNode configurationNode, boolean addedNotification) {
        String uniqueId = JSONUtil.readString(configurationNode, "uniqueId");
        if (StringUtil.isNullOrEmpty(uniqueId)) {
            uniqueId = "unknown";
        }
        long directoryIdInJson = JSONUtil.readLong(configurationNode, "directoryId");
        try {
            Object connector = this.connectorService.createWithConfiguration(configurationNode);
            ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.configure(connector.getUniqueId(), configurationNode);
            long createdDirectoryId = connectorAndValidationResult.getConnector().getConfiguration().getDirectoryId();
            ValidationResultWithId validationResult = ValidationResultWithId.create(connectorAndValidationResult.getValidationResult());
            if (directoryIdInJson != createdDirectoryId) {
                String message = "Using newly created directory " + createdDirectoryId + " instead of " + directoryIdInJson;
                validationResult.add("directoryId", null, message);
                this.notificationService.add(Notification.createForConnector(connector.getName() + ": " + message, Notification.Level.WARNING, uniqueId));
                addedNotification = true;
            }
            validationResult.removeEmptyChildren();
            if (!validationResult.isValid()) {
                this.notificationService.add(Notification.createForConnector(connector.getName() + ": Connector configuration is not valid, edit the configuration to fix.", Notification.Level.ERROR, uniqueId));
                addedNotification = true;
            }
            if (!addedNotification) {
                this.notificationService.add(Notification.createForConnector(connector.getName() + " has been created.", Notification.Level.INFO, uniqueId));
            }
            return validationResult;
        }
        catch (Exception e) {
            logger.warn("Importing new connector failed", (Throwable)e);
            ValidationResult validationResult = ValidationResult.create();
            validationResult.addError(e.getMessage());
            this.notificationService.add(Notification.createForConnector("Failed to create Connector " + uniqueId + ": " + e.getMessage(), Notification.Level.ERROR, uniqueId));
            return ValidationResultWithId.create(validationResult, uniqueId);
        }
    }
}

