/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.disableInactive;

import de.resolution.atlasuser.api.AtlasUserStatusObject;
import de.resolution.atlasuser.api.exception.InvalidAtlasUserStateException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserFunction;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.api.cleanup.UserCleanup;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupInactiveUsersFunction
extends UserCleanup
implements AtlasUserFunction {
    private static final Logger logger = LoggerFactory.getLogger(CleanupInactiveUsersFunction.class);
    private static final String ATTRIBUTE_LAST_AUTHENTICATION_TIMESTAMP = "lastAuthenticationTimestamp";
    private final long maxDurationSinceLastLogin;
    private final SyncStatus syncStatus;
    private final boolean cleanupUsersWithoutTimestamp;
    private final List<String> groupWhitelist;

    public CleanupInactiveUsersFunction(@Nonnull String maxDurationSinceLastLoginAsDaysOrSeconds, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull SyncStatus syncStatus, boolean cleanupUsersWithoutTimestamp, @Nonnull List<String> groupWhitelist, @Nonnull CleanupBehaviour behaviour, boolean removeAllGroupAssignmentsOnCleanup, @Nonnull List<String> groupsOrRegexNotBeRemoved) {
        super(behaviour, atlasUserAdapter, null, removeAllGroupAssignmentsOnCleanup, groupsOrRegexNotBeRemoved);
        if (maxDurationSinceLastLoginAsDaysOrSeconds.endsWith("S")) {
            this.maxDurationSinceLastLogin = Long.parseLong(maxDurationSinceLastLoginAsDaysOrSeconds.substring(0, maxDurationSinceLastLoginAsDaysOrSeconds.length() - 1)) * 1000L;
            logger.debug("{} seconds is {} milliseconds", (Object)maxDurationSinceLastLoginAsDaysOrSeconds, (Object)this.maxDurationSinceLastLogin);
        } else {
            this.maxDurationSinceLastLogin = Long.parseLong(maxDurationSinceLastLoginAsDaysOrSeconds) * 24L * 60L * 60L * 1000L;
            logger.debug("{} days is {} milliseconds", (Object)maxDurationSinceLastLoginAsDaysOrSeconds, (Object)this.maxDurationSinceLastLogin);
        }
        this.syncStatus = syncStatus;
        this.cleanupUsersWithoutTimestamp = cleanupUsersWithoutTimestamp;
        this.groupWhitelist = new ArrayList<String>(groupWhitelist);
    }

    private static boolean isMatchingAnyRegex(@Nonnull String grp, Collection<String> regexes) {
        return regexes.stream().anyMatch(regex -> grp.contains((CharSequence)regex) || Pattern.compile(regex).matcher(grp).matches());
    }

    @Override
    public Optional<AtlasUserResult> apply(AtlasUser atlasUser, AtlasUserStatusObject atlasUserStatusObject) {
        String usedAttribute;
        String lastAuthenticatedString;
        Set<String> userGroups = atlasUser.getAttributeValues("ATTR_GROUPS");
        if (userGroups.stream().anyMatch(grp -> CleanupInactiveUsersFunction.isMatchingAnyRegex(grp, this.groupWhitelist))) {
            AtlasUserResult atlasUserResult = AtlasUserResult.builder(atlasUser.getReference()).inputUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).addMessage("User is member of whitelisted group").build();
            atlasUserStatusObject.add(atlasUserResult);
            return Optional.of(atlasUserResult);
        }
        if (this.userIsAlreadyCleanedUp(atlasUser)) {
            AtlasUserResult atlasUserResult = this.removeAllGroupAssignmentsOnCleanup ? this.atlasUserAdapter.update(AtlasUser.builder().findBy(atlasUser.getReference()).active(atlasUser.isActive()).with("ATTR_GROUPS", this.getGroupsToRemain(atlasUser)).build(), null) : AtlasUserResult.builder(atlasUser.getReference()).inputUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            atlasUserStatusObject.add(atlasUserResult);
            return Optional.of(atlasUserResult);
        }
        if (Boolean.parseBoolean(atlasUser.get("ATTR_IS_SYSADMIN").orElse("false")) || Boolean.parseBoolean(atlasUser.get("ATTR_IS_ADMIN").orElse("false"))) {
            this.syncStatus.addMessage("Skipping admin or sysadmin <" + atlasUser.getName() + ">");
            AtlasUserResult atlasUserResult = AtlasUserResult.builder(atlasUser.getReference()).inputUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            atlasUserStatusObject.add(atlasUserResult);
            return Optional.of(atlasUserResult);
        }
        long now = new Date().getTime();
        Optional<String> loginLastLoginMillisOptional = atlasUser.get("login.lastLoginMillis");
        Optional<String> lastAuthenticatedOptional = atlasUser.get("lastAuthenticated");
        Optional<String> lastAuthenticationTimestampOptional = atlasUser.get(ATTRIBUTE_LAST_AUTHENTICATION_TIMESTAMP);
        Optional<String> lastAuthConfluenceOptional = atlasUser.get("ATTR_CONFLUENCE_LAST_AUTHENTICATED");
        if (loginLastLoginMillisOptional.isPresent()) {
            lastAuthenticatedString = loginLastLoginMillisOptional.get();
            usedAttribute = "login.lastLoginMillis";
        } else if (lastAuthConfluenceOptional.isPresent()) {
            lastAuthenticatedString = lastAuthConfluenceOptional.get();
            usedAttribute = "ATTR_CONFLUENCE_LAST_AUTHENTICATED";
        } else if (lastAuthenticatedOptional.isPresent()) {
            lastAuthenticatedString = lastAuthenticatedOptional.get();
            usedAttribute = "lastAuthenticated";
        } else if (lastAuthenticationTimestampOptional.isPresent()) {
            lastAuthenticatedString = lastAuthenticationTimestampOptional.get();
            usedAttribute = ATTRIBUTE_LAST_AUTHENTICATION_TIMESTAMP;
        } else {
            usedAttribute = null;
            lastAuthenticatedString = "0";
        }
        long lastAuthenticatedMillis = Long.parseLong(lastAuthenticatedString);
        if (lastAuthenticatedMillis == 0L && !this.cleanupUsersWithoutTimestamp) {
            this.syncStatus.addMessage("User <" + atlasUser.getName() + "> has no lastAuthenticated timestamp and cleanup users without timestamp is disabled. Therefore the user will not be cleaned up.");
            AtlasUserResult atlasUserResult = AtlasUserResult.builder(atlasUser.getReference()).initialUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
            atlasUserStatusObject.add(atlasUserResult);
            return Optional.of(atlasUserResult);
        }
        long duration = now - lastAuthenticatedMillis;
        if (logger.isDebugEnabled()) {
            if (usedAttribute == null) {
                logger.debug("User {} has no last login attribute.", (Object)atlasUser.getName());
            } else {
                logger.debug("User {} has attribute {}={}. Time since last authenticated: {}", new Object[]{atlasUser.getName(), usedAttribute, lastAuthenticatedString, Duration.ofMillis(duration)});
            }
        }
        if (duration > this.maxDurationSinceLastLogin) {
            logger.debug("Duration since last login for user {} is {}, disabling as this is longer than {}", new Object[]{atlasUser.getName(), duration, this.maxDurationSinceLastLogin});
            try {
                AtlasUserResult atlasUserResult = super.cleanupUser(atlasUser);
                atlasUserStatusObject.add(atlasUserResult);
                return Optional.of(atlasUserResult);
            }
            catch (InvalidAtlasUserStateException e) {
                AtlasUserResult atlasUserResult = AtlasUserResult.builder(atlasUser.getReference()).errorType(AtlasUserResult.ErrorType.VALIDATION_FAILED).errorString(e.getMessage()).build();
                atlasUserStatusObject.add(atlasUserResult);
                return Optional.of(atlasUserResult);
            }
        }
        logger.debug("Duration since last login for user {} is {}, NOT disabling as this is shorter than {}", new Object[]{atlasUser.getName(), duration, this.maxDurationSinceLastLogin});
        AtlasUserResult atlasUserResult = AtlasUserResult.builder(atlasUser.getReference()).initialUser(atlasUser).operation(AtlasUserResult.Operation.NOT_MODIFIED).build();
        atlasUserStatusObject.add(atlasUserResult);
        return Optional.of(atlasUserResult);
    }
}

