/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.TransformationResults;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"status", "transformationResults", "updateUserResult"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncSingleUserResult {
    private final AtlasUserResult updateUserResult;
    private final String errorMessage;
    private final TransformationResults transformationResults;
    private final Status status;
    private final Map<String, ?> userAttributes;
    private final ExceptionInfo exceptionInfo;
    private final ResultingUserStatus resultingUserStatus;

    public static SyncSingleUserResult createFound(Map<String, List<String>> userAttributes, TransformationResults transformationResults, AtlasUserResult updateUserResult) {
        return new SyncSingleUserResult(Status.FOUND, userAttributes, transformationResults, updateUserResult, null, null, SyncSingleUserResult.concludeResultingUserStatus(updateUserResult));
    }

    private static ResultingUserStatus concludeResultingUserStatus(@Nullable AtlasUserResult updateUserResult) {
        if (updateUserResult == null) {
            return ResultingUserStatus.OTHER;
        }
        if (!updateUserResult.isSuccess() || updateUserResult.isNotFound()) {
            return ResultingUserStatus.OTHER;
        }
        Optional<AtlasUser> oInitialUser = updateUserResult.getInitialUser();
        Optional<AtlasUser> oResultingUser = updateUserResult.getResultingUser();
        if (oInitialUser.isPresent() && oResultingUser.isPresent()) {
            AtlasUser initialUser = oInitialUser.get();
            AtlasUser resultingUser = oResultingUser.get();
            if (initialUser.isActive() && !resultingUser.isActive()) {
                return ResultingUserStatus.DISABLED;
            }
        }
        if (updateUserResult.isModified()) {
            return ResultingUserStatus.MODIFIED;
        }
        return ResultingUserStatus.NOT_MODIFIED;
    }

    public static SyncSingleUserResult createFound(AtlasUserResult updateUserResult) {
        return new SyncSingleUserResult(Status.FOUND, null, null, updateUserResult, null, null, SyncSingleUserResult.concludeResultingUserStatus(updateUserResult));
    }

    public static SyncSingleUserResult createFiltered(Map<String, List<String>> userAttributes, TransformationResults transformationResults) {
        return new SyncSingleUserResult(Status.FILTERED, userAttributes, transformationResults, null, null, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createFiltered(Map<String, List<String>> userAttributes, AtlasUserResult atlasUserResult, TransformationResults transformationResults) {
        return new SyncSingleUserResult(Status.FILTERED, userAttributes, transformationResults, atlasUserResult, null, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createPreFiltered(Map<String, ?> userAttributes) {
        return new SyncSingleUserResult(Status.PREFILTERED, userAttributes, null, null, null, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createPreFiltered(Map<String, ?> userAttributes, AtlasUserResult updateUserResult) {
        return new SyncSingleUserResult(Status.PREFILTERED, userAttributes, null, updateUserResult, null, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createNotUnique() {
        return new SyncSingleUserResult(Status.NOT_UNIQUE, null, null, null, null, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createNotFound() {
        return new SyncSingleUserResult(Status.NOT_FOUND, null, null, null, null, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createNotFound(@Nullable AtlasUserResult disableResult) {
        return new SyncSingleUserResult(Status.NOT_FOUND, null, null, disableResult, null, null, SyncSingleUserResult.concludeResultingUserStatus(disableResult));
    }

    public static SyncSingleUserResult createNotFound(@Nullable String errorMessage, @Nullable Exception exception) {
        if (exception != null) {
            return new SyncSingleUserResult(Status.NOT_FOUND, null, null, null, errorMessage, ExceptionInfo.from(exception), ResultingUserStatus.OTHER);
        }
        return new SyncSingleUserResult(Status.NOT_FOUND, null, null, null, errorMessage, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createOther(String message) {
        return new SyncSingleUserResult(Status.OTHER, null, null, null, message, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createFailure(@Nonnull String errorMessage) {
        return new SyncSingleUserResult(Status.FAILED, null, null, null, errorMessage, null, ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createFailure(@Nullable Exception e) {
        if (e == null) {
            return new SyncSingleUserResult(Status.FAILED, null, null, null, "Undefined error", null, ResultingUserStatus.OTHER);
        }
        return new SyncSingleUserResult(Status.FAILED, null, null, null, e.getMessage(), SyncSingleUserResult.createExceptionInfo(e), ResultingUserStatus.OTHER);
    }

    public static SyncSingleUserResult createFoundOrFailed(@Nonnull FindUserResult findUserResult, @Nonnull SyncUserResult syncUserResult) {
        MapStructuredData attributesFromConnector = null;
        if (findUserResult.getAttributesFromConnector().isMap()) {
            attributesFromConnector = findUserResult.getAttributesFromConnector().asMap();
        }
        TransformationResults transformationResults = syncUserResult.getTransformationResults();
        AtlasUserResult atlasUserResult = syncUserResult.getAtlasUserResult();
        Status status = Status.FAILED;
        if (atlasUserResult != null && atlasUserResult.isSuccess()) {
            status = Status.FOUND;
        }
        return new SyncSingleUserResult(status, attributesFromConnector, transformationResults, atlasUserResult, syncUserResult.getMessage(), null, SyncSingleUserResult.concludeResultingUserStatus(atlasUserResult));
    }

    public static SyncSingleUserResult createFailure(@Nullable String messagePrefix, @Nonnull Exception e) {
        String prefix = "";
        if (messagePrefix != null) {
            prefix = messagePrefix + ": ";
        }
        String stackTraceLine = "";
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        if (stackTraceElements.length > 0) {
            stackTraceLine = stackTraceElements[0].toString();
        }
        String exMessage = "";
        if (e.getMessage() != null) {
            exMessage = e.getMessage() + ": ";
        }
        return new SyncSingleUserResult(Status.FAILED, null, null, null, prefix + exMessage + e.getClass() + " at " + stackTraceLine, SyncSingleUserResult.createExceptionInfo(e), ResultingUserStatus.OTHER);
    }

    @JsonCreator
    public SyncSingleUserResult(@Nonnull @JsonProperty(value="status") Status status, @Nullable @JsonProperty(value="userProperties") Map<String, ?> userAttributes, @Nullable @JsonProperty(value="transformationResults") TransformationResults transformationResults, @Nullable @JsonProperty(value="updateUserResult") AtlasUserResult updateUserResult, @Nullable @JsonProperty(value="errorMessage") String errorMessage, @Nullable @JsonProperty(value="exceptionInfo") ExceptionInfo exceptionInfo, @Nullable @JsonProperty(value="resultingUserStatus") ResultingUserStatus resultingUserStatus) {
        this.status = status;
        this.userAttributes = userAttributes == null ? Collections.emptyMap() : userAttributes;
        this.transformationResults = transformationResults;
        this.updateUserResult = updateUserResult;
        this.errorMessage = errorMessage;
        this.exceptionInfo = exceptionInfo;
        this.resultingUserStatus = resultingUserStatus;
    }

    @Nullable
    public AtlasUserResult getUpdateUserResult() {
        return this.updateUserResult;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public TransformationResults getTransformationResults() {
        return this.transformationResults;
    }

    @Nullable
    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    @Nonnull
    public Status getStatus() {
        return this.status;
    }

    public Map<String, ?> getUserAttributes() {
        return this.userAttributes;
    }

    @Nullable
    private static ExceptionInfo createExceptionInfo(Exception ex) {
        if (ex != null) {
            return ExceptionInfo.from(ex);
        }
        return null;
    }

    @Nonnull
    public ResultingUserStatus getResultingUserStatus() {
        return this.resultingUserStatus;
    }

    public static enum ResultingUserStatus {
        DISABLED,
        NOT_MODIFIED,
        MODIFIED,
        OTHER;

    }

    public static enum Status {
        FOUND,
        NOT_FOUND,
        NOT_UNIQUE,
        FILTERED,
        FAILED,
        PREFILTERED,
        OTHER;

    }
}

