/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user.jira;

import com.atlassian.jira.user.UserKeyService;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import de.resolution.atlasuser.api.exception.AtlasUserValidationFailedException;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.impl.user.UserRenamingBreaksMappingValidator;
import de.resolution.commons.util.JSONUtil;
import java.util.Optional;
import javax.inject.Inject;

@JiraComponent
public class JiraAtlasUserValidator
extends UserRenamingBreaksMappingValidator {
    private static final int MAX_NAME_LENGTH = 60;
    private final UserKeyService userKeyService;

    @Inject
    public JiraAtlasUserValidator(@JiraImport UserKeyService userKeyService) {
        this.userKeyService = userKeyService;
    }

    @Override
    public void validateForCreate(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        super.validateForCreate(atlasUser);
        String name = atlasUser.get("ATTR_NAME").orElse("");
        if (name.length() > 60) {
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), "ATTR_NAME", name, " must not exceed 60 characters due to https://jira.atlassian.com/browse/JRASERVER-42614");
        }
        this.validateEntityProperties(atlasUser);
    }

    @Override
    public void validateForRenaming(AtlasUser userToUpdate) throws AtlasUserValidationFailedException {
        String newName = userToUpdate.get("ATTR_NEW_NAME").orElse(userToUpdate.get("ATTR_NAME").orElse(null));
        if (newName == null) {
            throw new AtlasUserValidationFailedException(userToUpdate.getReference(), "newUsername", null, "newUsername not given");
        }
        String key = this.userKeyService.getKeyForUsername(newName);
        if (key != null) {
            super.validateForRenaming(userToUpdate);
        }
        this.validateEntityProperties(userToUpdate);
    }

    @Override
    public void validateForUpdate(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        super.validateForUpdate(atlasUser);
        this.validateEntityProperties(atlasUser);
    }

    public void validateEntityProperties(AtlasUser atlasUser) throws AtlasUserValidationFailedException {
        for (String key : atlasUser.getAttributeKeys()) {
            Optional<String> valueOpt;
            if (!key.startsWith("JIRA.EPROP.") || !(valueOpt = atlasUser.get(key)).isPresent() || JSONUtil.isValidJson(valueOpt.get())) continue;
            throw new AtlasUserValidationFailedException(atlasUser.getReference(), key, valueOpt.get(), "is no valid JSON");
        }
    }
}

