/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import de.resolution.atlasuser.api.user.AttributeFilter;
import de.resolution.atlasuser.api.user.SearchFilter;
import de.resolution.atlasuser.impl.user.SearchFilterImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class SearchFilterBuilder {
    private long directoryId = -4L;
    private Boolean activityState = null;
    private String baseAttributesContain = null;
    private Set<String> inGroups = null;
    private Set<String> notInGroups = null;
    private Set<String> applicationAccess = null;
    private Set<String> includedUsernames = null;
    private Set<String> excludedUsernames = null;
    private List<AttributeFilter> attributeFilters = null;
    private Boolean lastKnownActivityPresent = null;
    private Long lastKnownActivityBefore = null;
    private Long lastKnownActivityOnOrAfter = null;
    @Nonnull
    private List<String> attributesForLastKnownActivity = Arrays.asList("lastAuthenticated", "login.lastLoginMillis", "lastActivityMillis");

    public SearchFilterBuilder directoryId(long directoryId) {
        this.directoryId = directoryId;
        return this;
    }

    public SearchFilterBuilder activityState(boolean activityState) {
        this.activityState = activityState;
        return this;
    }

    public SearchFilterBuilder baseAttributesContain(String baseAttributesContain) {
        this.baseAttributesContain = baseAttributesContain;
        return this;
    }

    public SearchFilterBuilder inGroups(Set<String> inGroups) {
        this.inGroups = inGroups;
        return this;
    }

    public SearchFilterBuilder inGroups(String ... inGroups) {
        return this.inGroups(Stream.of(inGroups).collect(Collectors.toSet()));
    }

    public SearchFilterBuilder notInGroups(Set<String> notInGroups) {
        this.notInGroups = notInGroups;
        return this;
    }

    public SearchFilterBuilder notInGroups(String ... notInGroups) {
        return this.notInGroups(Stream.of(notInGroups).collect(Collectors.toSet()));
    }

    public SearchFilterBuilder applicationAccess(Set<String> applicationAccess) {
        this.applicationAccess = applicationAccess;
        return this;
    }

    public SearchFilterBuilder applicationAccess(String ... applicationAccess) {
        return this.applicationAccess(Stream.of(applicationAccess).collect(Collectors.toSet()));
    }

    public SearchFilterBuilder includedUsernames(Set<String> includedUsernames) {
        this.includedUsernames = includedUsernames;
        return this;
    }

    public SearchFilterBuilder includedUsernames(String ... includedUsernames) {
        return this.includedUsernames(Stream.of(includedUsernames).collect(Collectors.toSet()));
    }

    public SearchFilterBuilder excludedUsernames(Set<String> excludedUsernames) {
        this.excludedUsernames = excludedUsernames;
        return this;
    }

    public SearchFilterBuilder excludedUsernames(String ... excludedUsernames) {
        return this.excludedUsernames(Stream.of(excludedUsernames).collect(Collectors.toSet()));
    }

    public SearchFilterBuilder lastKnownActivityBefore(Long lastKnownActivityBefore) {
        this.lastKnownActivityBefore = lastKnownActivityBefore;
        return this;
    }

    public SearchFilterBuilder lastKnownActivityOnOrAfter(Long lastKnownActivityNotOnOrAfter) {
        this.lastKnownActivityOnOrAfter = lastKnownActivityNotOnOrAfter;
        return this;
    }

    public SearchFilterBuilder lastKnownActivityPresent(Boolean lastKnownActivityPresent) {
        this.lastKnownActivityPresent = lastKnownActivityPresent;
        return this;
    }

    public SearchFilterBuilder attributeFilters(List<AttributeFilter> attributeFilters) {
        this.attributeFilters = attributeFilters;
        return this;
    }

    public SearchFilterBuilder attributeFilters(AttributeFilter ... attributeFilters) {
        return this.attributeFilters(Arrays.asList(attributeFilters));
    }

    public SearchFilterBuilder attributesForLastKnownActivity(@Nonnull List<String> attributesForLastKnownActivity) {
        this.attributesForLastKnownActivity = attributesForLastKnownActivity;
        return this;
    }

    public SearchFilterBuilder attributesForLastKnownActivity(String ... attributesForLastKnownActivity) {
        return this.attributesForLastKnownActivity(Arrays.asList(attributesForLastKnownActivity));
    }

    public SearchFilter build() {
        return new SearchFilterImpl(this.directoryId, this.activityState, this.baseAttributesContain, this.inGroups, this.notInGroups, this.applicationAccess, this.includedUsernames, this.excludedUsernames, this.attributeFilters, this.lastKnownActivityPresent, this.lastKnownActivityBefore, this.lastKnownActivityOnOrAfter, this.attributesForLastKnownActivity);
    }
}

