/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.api.directory;

import de.resolution.atlasuser.api.directory.AtlasUserDirectoryBuilder;
import de.resolution.commons.util.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AtlasUserDirectory {
    private final long id;
    private final String name;
    private final String description;
    private final boolean writable;
    private final boolean atlasUser;
    private final boolean internal;
    private final Map<String, String> attributes;
    private final boolean active;
    private final boolean useNestedGroups;

    public static AtlasUserDirectoryBuilder builder() {
        return new AtlasUserDirectoryBuilder();
    }

    public static AtlasUserDirectoryBuilder builder(AtlasUserDirectory fromDirectory) {
        return new AtlasUserDirectoryBuilder(fromDirectory);
    }

    AtlasUserDirectory(long id, @Nonnull String name, @Nonnull String description, boolean writable, boolean atlasUser, boolean internal, boolean active, boolean useNestedGroups, Map<String, String> attributes) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.writable = writable;
        this.atlasUser = atlasUser;
        this.internal = internal;
        this.active = active;
        this.useNestedGroups = useNestedGroups;
        this.attributes = new HashMap<String, String>(attributes);
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isAtlasUser() {
        return this.atlasUser;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isUseNestedGroups() {
        return this.useNestedGroups;
    }

    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.attributes);
    }

    public String getAttribute(@Nonnull String key) {
        return this.attributes.get(key);
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof AtlasUserDirectory) {
            AtlasUserDirectory other = (AtlasUserDirectory)otherObj;
            return other.id == this.id && Objects.equals(this.description, other.description) && Objects.equals(this.name, other.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description);
    }

    public String asJson() {
        return JSONUtil.asJson(this);
    }
}

