/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.task.api.Task;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.exception.SyncCanceledException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class SyncStatusFacadeImpl
implements SyncStatusFacade {
    private static final String JSON_KEY_ERROR_DESCRIPTION = "error_description";
    private static final String JSON_KEY_MESSAGE = "message";
    private static final String JSON_KEY_ERROR_SUMMARY = "errorSummary";
    private final SyncStatus syncStatus;

    public SyncStatusFacadeImpl() {
        this(null);
    }

    @Override
    public int getId() {
        return this.syncStatus.getId();
    }

    public SyncStatusFacadeImpl(@Nullable SyncStatus syncStatus) {
        this.syncStatus = syncStatus;
    }

    @Override
    @Nullable
    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    @Override
    public void fail(@Nonnull String message, @Nonnull Logger logger) {
        this.fail(message, null, -1, null, null, logger);
    }

    @Override
    public void fail(@Nonnull String message, @Nonnull Exception exception, @Nonnull Logger logger) {
        this.fail(message, exception, -1, null, null, logger);
    }

    @Override
    public void fail(@Nonnull Exception exception, @Nonnull Logger logger) {
        this.fail(exception.getMessage(), exception, -1, null, null, logger);
    }

    @Override
    public void fail(@Nonnull String message, int statusCode, @Nullable String statusText, @Nullable String body, Logger logger) {
        this.fail(message, null, statusCode, statusText, body, logger);
    }

    @Override
    public void fail(@Nonnull String message, @Nullable Exception exception, int statusCode, @Nullable String statusText, @Nullable String body, @Nonnull Logger logger) {
        if (statusCode == -1) {
            this.add(message, exception, SyncStatusFacade.LogLevel.ERROR, logger);
        } else {
            this.add(message, statusCode, statusText, body, exception, logger);
        }
        if (this.syncStatus != null) {
            this.syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
            this.syncStatus.setStatus(Task.Status.DONE);
        }
    }

    @Override
    public void failPartially(@Nonnull String message, @Nonnull Logger logger) {
        this.failPartially(message, null, -1, null, null, logger);
    }

    @Override
    public void failPartially(@Nonnull String message, @Nonnull Exception exception, @Nonnull Logger logger) {
        this.failPartially(message, exception, -1, null, null, logger);
    }

    @Override
    public void failPartially(@Nonnull String message, int statusCode, @Nullable String statusText, @Nullable String body, @Nonnull Logger logger) {
        this.failPartially(message, null, statusCode, statusText, body, logger);
    }

    @Override
    public void failPartially(@Nonnull String message, @Nullable Exception exception, int statusCode, @Nullable String statusText, @Nullable String body, @Nonnull Logger logger) {
        if (statusCode == -1) {
            this.add(message, exception, SyncStatusFacade.LogLevel.ERROR, logger);
        } else {
            this.add(message, statusCode, statusText, body, exception, logger);
        }
        if (this.syncStatus != null) {
            this.syncStatus.setSyncStatusResult(SyncStatus.Result.PARTIALLY_FAILED);
        }
    }

    @Override
    public void addFiltered() {
        if (this.syncStatus != null) {
            this.syncStatus.addFiltered();
        }
    }

    @Override
    public void add(@Nonnull AtlasUserResult result) {
        if (this.syncStatus != null) {
            this.syncStatus.add(result);
        }
    }

    @Override
    public void add(@Nonnull SyncUserResult result) {
        if (this.syncStatus != null) {
            this.syncStatus.add(result);
        }
    }

    @Override
    public boolean isNullFacade() {
        return this.syncStatus == null;
    }

    @Override
    public void add(@Nonnull String message, @Nonnull SyncStatusFacade.LogLevel logLevel, @Nonnull Logger logger) {
        this.add(message, null, logLevel, logger);
    }

    @Override
    public void add(@Nonnull String message, @Nullable Throwable throwable, @Nonnull SyncStatusFacade.LogLevel logLevel, @Nonnull Logger logger) {
        if (this.syncStatus != null) {
            if (throwable != null && throwable.getMessage() != null && !throwable.getMessage().isEmpty()) {
                this.syncStatus.addMessage(message + " because: " + throwable.getMessage());
            } else {
                this.syncStatus.addMessage(message);
            }
        }
        this.printToLogger(message, throwable, logLevel, logger);
    }

    @Override
    public void setResultFilePath(String resultFilePath) {
        this.syncStatus.setResultFilePath(resultFilePath);
    }

    @Override
    public void checkCancel() {
        if (Thread.interrupted()) {
            throw new SyncCanceledException(Task.Status.CANCELLED, "Thread was interrupted!");
        }
        if (this.syncStatus != null && this.syncStatus.isCancelled()) {
            throw new SyncCanceledException(Task.Status.CANCELLED, "Stopping sync because it was cancelled");
        }
        if (this.syncStatus != null && this.syncStatus.getStatus() == Task.Status.DONE) {
            throw new SyncCanceledException(Task.Status.DONE, "Stopping sync because process was interrupted");
        }
    }

    @Override
    public void cancel() {
        if (this.syncStatus != null) {
            this.syncStatus.cancel();
        }
    }

    @Override
    public boolean isRunning() {
        return this.isNullFacade() || this.syncStatus != null && this.syncStatus.getStatus() == Task.Status.RUNNING;
    }

    @Override
    public void setStatusMessage(@Nonnull String newStatusMessage) {
        if (this.syncStatus != null) {
            this.syncStatus.setStatusMessage(newStatusMessage);
        }
    }

    @Override
    public void clearStatusMessage() {
        if (this.syncStatus != null) {
            this.syncStatus.clearStatusMessage();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.syncStatus != null && this.syncStatus.isCancelled();
    }

    private void add(@Nonnull String message, int statusCode, @Nullable String statusText, @Nullable String body, @Nullable Throwable throwable, @Nonnull Logger logger) {
        block9: {
            this.clearStatusMessage();
            if (statusCode != -1) {
                this.printToLogger(message + ", Status " + statusCode + ": " + statusText, throwable, SyncStatusFacade.LogLevel.ERROR, logger);
                this.printToLogger("Response Body: " + body, throwable, SyncStatusFacade.LogLevel.DEBUG, logger);
                if (body != null) {
                    try {
                        JsonNode jsonNode = new ObjectMapper().readTree(body);
                        if (jsonNode.hasNonNull(JSON_KEY_ERROR_DESCRIPTION)) {
                            this.add(jsonNode.get(JSON_KEY_ERROR_DESCRIPTION).asText(), throwable, SyncStatusFacade.LogLevel.ERROR, logger);
                            break block9;
                        }
                        if (jsonNode.hasNonNull(JSON_KEY_MESSAGE)) {
                            this.add(jsonNode.get(JSON_KEY_MESSAGE).asText(), throwable, SyncStatusFacade.LogLevel.ERROR, logger);
                            break block9;
                        }
                        if (jsonNode.hasNonNull(JSON_KEY_ERROR_SUMMARY)) {
                            this.add(message + " / " + statusText + " / Error summary: " + jsonNode.get(JSON_KEY_ERROR_SUMMARY).asText(), throwable, SyncStatusFacade.LogLevel.ERROR, logger);
                            break block9;
                        }
                        this.add(body, throwable, SyncStatusFacade.LogLevel.ERROR, logger);
                    }
                    catch (JsonProcessingException e) {
                        this.add(body, throwable, SyncStatusFacade.LogLevel.ERROR, logger);
                    }
                } else {
                    this.add(message + " / " + statusText, throwable, SyncStatusFacade.LogLevel.ERROR, logger);
                }
            }
        }
        if (throwable != null) {
            this.add(throwable.getMessage(), throwable, SyncStatusFacade.LogLevel.ERROR, logger);
        }
    }

    private void printToLogger(@Nonnull String message, @Nullable Throwable throwable, @Nonnull SyncStatusFacade.LogLevel logLevel, @Nonnull Logger logger) {
        switch (logLevel) {
            case DEBUG: {
                logger.debug(message, throwable);
                break;
            }
            case INFO: {
                logger.info(message, throwable);
                break;
            }
            case WARN: {
                logger.warn(message, throwable);
                break;
            }
            default: {
                logger.error(message, throwable);
            }
        }
    }
}

