/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.groovyconnector;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.usersync.api.cleanup.CleanupBehaviour;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnector;
import de.resolution.usersync.builtin.groovyconnector.GroovyConnectorConfiguration;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class GroovyConnectorConfigurationImpl
extends AbstractConnectorConfigurationImpl
implements GroovyConnectorConfiguration {
    @Nonnull
    private String groovyCode = "";
    private static final List<AttributeTransformationConfig> DEFAULT_TRANSFORMATION_CONFIGS = new ArrayList<AttributeTransformationConfig>();

    public GroovyConnectorConfigurationImpl() {
        this.cleanupBehaviour = CleanupBehaviour.NONE;
    }

    public GroovyConnectorConfigurationImpl(GroovyConnectorConfiguration other) {
        super(other);
        this.groovyCode = other.getGroovyCode();
    }

    @Override
    @Nonnull
    public String getGroovyCode() {
        return this.groovyCode;
    }

    @Override
    @Nonnull
    public List<AttributeTransformationConfig> createDefaultAttributeTransformationConfigs() {
        return DEFAULT_TRANSFORMATION_CONFIGS;
    }

    @Override
    @Nonnull
    public String getDefaultFindByAttributeName() {
        return "ATTR_NAME";
    }

    public void setGroovyCode(String groovyCode) {
        if (groovyCode != null) {
            this.groovyCode = groovyCode;
        }
    }

    @Override
    @Nonnull
    public ConnectorConfiguration sanitize() {
        return this;
    }

    public Class<GroovyConnector> tellConnectorClass() {
        return GroovyConnector.class;
    }

    static {
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createUnmapped(), new Target(Target.Type.SYSTEM, "ATTR_NAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createUnmapped(), new Target(Target.Type.SYSTEM, "ATTR_FULLNAME"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createUnmapped(), new Target(Target.Type.SYSTEM, "ATTR_EMAIL"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createGroovy("true"), new Target(Target.Type.SYSTEM, "ATTR_ACTIVE"), false, true));
        DEFAULT_TRANSFORMATION_CONFIGS.add(new AttributeTransformationConfig(Source.createUnmapped(), new Target(Target.Type.SYSTEM, "ATTR_GROUPS"), false, true));
    }
}

