/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class SetUtil {
    private SetUtil() {
    }

    public static <T> Set<T> union(@Nonnull Set<T> a, @Nonnull Set<T> b) {
        HashSet<T> result = new HashSet<T>();
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    public static <T> Set<T> intersect(@Nonnull Set<T> a, @Nonnull Set<T> b) {
        return a.stream().filter(b::contains).collect(Collectors.toSet());
    }

    public static <T> Set<T> difference(@Nonnull Set<T> a, @Nonnull Set<T> b) {
        return a.stream().filter(i -> !b.contains(i)).collect(Collectors.toSet());
    }

    public static <T> Set<T> of(@Nonnull T a) {
        return new HashSet<T>(Collections.singletonList(a));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b) {
        return new HashSet<Object>(Arrays.asList(a, b));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b, @Nonnull T c) {
        return new HashSet<Object>(Arrays.asList(a, b, c));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b, @Nonnull T c, @Nonnull T d) {
        return new HashSet<Object>(Arrays.asList(a, b, c, d));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b, @Nonnull T c, @Nonnull T d, @Nonnull T e) {
        return new HashSet<Object>(Arrays.asList(a, b, c, d, e));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b, @Nonnull T c, @Nonnull T d, @Nonnull T e, @Nonnull T f) {
        return new HashSet<Object>(Arrays.asList(a, b, c, d, e, f));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b, @Nonnull T c, @Nonnull T d, @Nonnull T e, @Nonnull T f, @Nonnull T g) {
        return new HashSet<Object>(Arrays.asList(a, b, c, d, e, f, g));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b, @Nonnull T c, @Nonnull T d, @Nonnull T e, @Nonnull T f, @Nonnull T g, @Nonnull T h) {
        return new HashSet<Object>(Arrays.asList(a, b, c, d, e, f, g, h));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b, @Nonnull T c, @Nonnull T d, @Nonnull T e, @Nonnull T f, @Nonnull T g, @Nonnull T h, @Nonnull T i) {
        return new HashSet<Object>(Arrays.asList(a, b, c, d, e, f, g, h, i));
    }

    public static <T> Set<T> of(@Nonnull T a, @Nonnull T b, @Nonnull T c, @Nonnull T d, @Nonnull T e, @Nonnull T f, @Nonnull T g, @Nonnull T h, @Nonnull T i, @Nonnull T j) {
        return new HashSet<Object>(Arrays.asList(a, b, c, d, e, f, g, h, i, j));
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... a) {
        return new HashSet<T>(Arrays.asList(a));
    }
}

