/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.net;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.JSONUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWrapper.class);
    @Nullable
    private String bodyString;
    @Nullable
    private Response wrappedResponse;
    @Nullable
    private Exception exception;
    @Nullable
    private String errorMessage;
    @Nullable
    private ObjectMapper objectMapper;

    public ResponseWrapper(@Nonnull Exception e) {
        logger.warn("HTTP Request failed", (Throwable)e);
        this.exception = e;
    }

    public ResponseWrapper(@Nonnull Response response) {
        this.wrappedResponse = response;
        ResponseBody body = this.wrappedResponse.body();
        if (body == null) {
            this.bodyString = null;
            this.wrappedResponse.close();
        } else {
            try {
                this.bodyString = body.string();
            }
            catch (IOException e) {
                this.bodyString = null;
                this.exception = e;
            }
        }
    }

    @Nonnull
    public ResponseWrapper setErrorMessage(@Nonnull String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    public String getHeader(@Nonnull String name) {
        if (this.wrappedResponse == null) {
            return null;
        }
        return this.wrappedResponse.header(name);
    }

    @Nonnull
    public List<String> getHeaders(@Nonnull String name) {
        if (this.wrappedResponse == null) {
            return Collections.emptyList();
        }
        return this.wrappedResponse.headers(name);
    }

    @Nullable
    public String getBody() {
        return this.bodyString;
    }

    @Nonnull
    public StructuredData getBodyAsStructuredData() {
        if (this.bodyString == null) {
            return StructuredData.create();
        }
        return StructuredData.parseJson(this.bodyString);
    }

    @Nonnull
    public JsonNode getBodyAsJsonNode() {
        try {
            return this.getObjectMapper().readTree(this.bodyString);
        }
        catch (JsonProcessingException e) {
            throw new JSONUtil.JsonDeserializationFailedException(e);
        }
    }

    @Nonnull
    public <T> T getBodyAs(@Nonnull Class<T> clazz) {
        try {
            return this.getObjectMapper().readValue(this.bodyString, clazz);
        }
        catch (IOException e) {
            throw new JSONUtil.JsonDeserializationFailedException(e);
        }
    }

    public int getCode() {
        if (this.wrappedResponse == null) {
            return -1;
        }
        return this.wrappedResponse.code();
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public boolean isSuccess() {
        return this.wrappedResponse != null && this.wrappedResponse.isSuccessful() && this.exception == null;
    }

    public boolean isNotFound() {
        return this.wrappedResponse != null && this.wrappedResponse.code() == 404;
    }

    @Nullable
    public String getMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        if (this.wrappedResponse == null) {
            return null;
        }
        return this.wrappedResponse.message();
    }

    @Nullable
    public Response getWrappedResponse() {
        return this.wrappedResponse;
    }

    @Nonnull
    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }
}

