/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import de.resolution.atlasuser.api.ExceptionInfo;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUserResult;
import de.resolution.commons.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AtlasUserResultBuilder {
    private final AtlasUserReference atlasUserReference;
    private boolean success = true;
    private AtlasUserResult.Operation operation = AtlasUserResult.Operation.NOT_MODIFIED;
    private AtlasUser inputUser;
    private AtlasUser initialUser;
    private AtlasUser resultingUser;
    private AtlasUserResult.ErrorType errorType = AtlasUserResult.ErrorType.NONE;
    private List<String> messages = new ArrayList<String>();
    private ExceptionInfo exceptionInfo;
    private ImmutableAtlasUserResult removeInOtherResult = null;

    public AtlasUserResultBuilder(AtlasUserReference atlasUserReference) {
        this.atlasUserReference = atlasUserReference;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isFailure() {
        return !this.success;
    }

    public AtlasUserResultBuilder operation(AtlasUserResult.Operation operation) {
        this.operation = operation;
        return this;
    }

    public AtlasUserResult.Operation getOperation() {
        return this.operation;
    }

    public AtlasUserResultBuilder inputUser(AtlasUser inputUser) {
        this.inputUser = inputUser;
        return this;
    }

    public AtlasUserResultBuilder initialUser(AtlasUser initialUser) {
        this.initialUser = initialUser;
        return this;
    }

    public AtlasUserResultBuilder resultingUser(AtlasUser resultingUser) {
        this.resultingUser = resultingUser;
        return this;
    }

    public AtlasUserResultBuilder errorType(AtlasUserResult.ErrorType errorType) {
        this.errorType = errorType;
        this.success = false;
        return this;
    }

    public AtlasUserResultBuilder errorString(String errorString) {
        this.addMessage(errorString);
        this.success = false;
        return this;
    }

    @Nonnull
    public AtlasUserResultBuilder addMessage(@Nonnull String message) {
        if (!StringUtil.isNullOrEmpty(message)) {
            this.messages.add(message);
        }
        return this;
    }

    public AtlasUserResultBuilder messages(List<String> messages) {
        this.messages = new ArrayList<String>(messages);
        return this;
    }

    @Nonnull
    public AtlasUserResultBuilder exceptionInfo(@Nonnull ExceptionInfo exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        this.success = false;
        if (this.messages.isEmpty()) {
            this.addMessage(exceptionInfo.getMessage());
        }
        if (this.errorType == null) {
            this.errorType(AtlasUserResult.ErrorType.OPERATION_FAILED);
        }
        return this;
    }

    public AtlasUserResultBuilder removeInOtherResult(AtlasUserResult removeInOtherResult) {
        this.removeInOtherResult = ImmutableAtlasUserResult.from(removeInOtherResult);
        return this;
    }

    public AtlasUserResult build() {
        Objects.requireNonNull(this.atlasUserReference);
        return new ImmutableAtlasUserResult(this.atlasUserReference, this.success, this.operation, this.inputUser, this.initialUser, this.resultingUser, this.errorType, this.messages, this.exceptionInfo, this.removeInOtherResult);
    }
}

