/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl;

import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import de.resolution.atlasuser.api.LicenseCountProvider;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
@ExportAsService(value={LicenseCountProvider.class})
public class BitbucketLicenseCountProvider
implements LicenseCountProvider {
    private final LicenseService licenseService;

    @Autowired
    public BitbucketLicenseCountProvider(@BitbucketImport LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @Override
    public int getAvailableBitbucketUserLicenses() {
        BitbucketServerLicense license = this.licenseService.get();
        if (license == null) {
            return 0;
        }
        if (license.isUnlimitedNumberOfUsers()) {
            return Integer.MAX_VALUE;
        }
        int maxUsers = license.getMaximumNumberOfUsers();
        int currentUsers = this.licenseService.getLicensedUsersCount();
        if (currentUsers > maxUsers) {
            return 0;
        }
        return maxUsers - currentUsers;
    }
}

