/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.flattener;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IndexedPeekIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private E peek;
    private boolean hasPeek = false;
    private int index = -1;
    private E current = null;

    public static <T> IndexedPeekIterator<T> newIndexedPeekIterator(Iterable<T> iter) {
        return new IndexedPeekIterator<T>(iter.iterator());
    }

    public IndexedPeekIterator(Iterator<? extends E> iterator2) {
        if (iterator2 == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator2;
    }

    private void peeking() {
        this.peek = this.iterator.next();
        this.hasPeek = true;
    }

    public int getIndex() {
        return this.index;
    }

    public E getCurrent() {
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.hasPeek || this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        if (this.hasPeek) {
            this.hasPeek = false;
            this.current = this.peek;
            return this.current;
        }
        this.peeking();
        return this.next();
    }

    @Override
    public void remove() {
        if (this.hasPeek) {
            throw new IllegalStateException();
        }
        this.iterator.remove();
    }

    public E peek() {
        if (!this.hasPeek) {
            if (this.hasNext()) {
                this.peeking();
            } else {
                throw new NoSuchElementException();
            }
        }
        return this.peek;
    }
}

