/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.user;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import de.resolution.commons.util.JSONUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScimCoreUser {
    public static final String SCHEMA_USER = "urn:ietf:params:scim:schemas:core:2.0:User";
    @Nonnull
    private final Map<String, Object> attributes;

    public ScimCoreUser(@Nonnull Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public static List<String> getFlatAttributes() {
        ArrayList<String> attr = new ArrayList<String>();
        attr.add("id");
        attr.add("active");
        attr.add("externalId");
        attr.add("userName");
        attr.add("name.formatted");
        attr.add("name.familyName");
        attr.add("name.givenName");
        attr.add("name.middleName");
        attr.add("name.honorificPrefix");
        attr.add("displayName");
        attr.add("nickName");
        attr.add("profileUrl");
        attr.add("emails[0].value");
        attr.add("emails[0].type");
        attr.add("userType");
        attr.add("title");
        attr.add("preferredLanguage");
        attr.add("locale");
        attr.add("timezone");
        return Collections.unmodifiableList(attr);
    }

    @Nonnull
    public static ScimCoreUserBuilder builder() {
        return new ScimCoreUserBuilder();
    }

    @Nullable
    @JsonIgnore
    public String getId() {
        Object id = this.attributes.get("id");
        if (id instanceof String) {
            return (String)id;
        }
        return null;
    }

    @Nonnull
    @JsonAnyGetter
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static class ScimCoreUserBuilder {
        @Nonnull
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        public ScimCoreUserBuilder() {
            this.attributes.put("schemas", Collections.singleton(ScimCoreUser.SCHEMA_USER));
        }

        @Nonnull
        public ScimCoreUserBuilder active(boolean active) {
            this.attributes.put("active", active);
            return this;
        }

        @Nonnull
        public ScimCoreUserBuilder with(@Nonnull String key, @Nullable Object value) {
            if (value == null && this.attributes.containsKey(key)) {
                this.attributes.remove(key);
            } else {
                this.attributes.put(key, value);
            }
            return this;
        }

        @Nonnull
        public ScimCoreUserBuilder without(@Nonnull String key) {
            this.attributes.remove(key);
            return this;
        }

        @Nonnull
        public ScimCoreUser build() throws ScimException {
            Map<String, Object> unflattenedMap;
            String flattenedJson = JSONUtil.asJson(this.attributes);
            String unflattenedJson = new JsonUnflattener(flattenedJson).withFlattenMode(FlattenMode.NORMAL).unflatten();
            ObjectMapper mapper = new ObjectMapper();
            try {
                unflattenedMap = mapper.readValue(unflattenedJson, new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new ServerErrorException("Building SCIM user failed: " + e.getMessage(), null, e);
            }
            return new ScimCoreUser(unflattenedMap);
        }
    }
}

