/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.azure;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.validate.api.ValidationMessage;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryAlreadyRegisteredException;
import de.resolution.usersync.builtin.azure.AzureConnector;
import de.resolution.usersync.builtin.azure.AzureConnectorConfiguration;
import de.resolution.usersync.builtin.azure.AzureConnectorConfigurationImpl;
import de.resolution.usersync.impl.PlatformSpecificConfigDefaultsProvider;
import de.resolution.usersync.spi.AbstractOAuthConnectorFactory;
import de.resolution.usersync.util.UserSyncUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="azureConnectorFactory")
@JsonAutoDetect
public class AzureConnectorFactory
extends AbstractOAuthConnectorFactory<AzureConnector, AzureConnectorConfiguration> {
    private final ApplicationProperties applicationProperties;

    @Inject
    public AzureConnectorFactory(ConnectorService connectorService, @ComponentImport ApplicationProperties applicationProperties, PlatformSpecificConfigDefaultsProvider platformSpecificConfigDefaultsProvider) throws ConnectorFactoryAlreadyRegisteredException {
        super(connectorService, platformSpecificConfigDefaultsProvider);
        this.applicationProperties = applicationProperties;
    }

    @Override
    @Nonnull
    public AzureConnector create(@Nonnull AzureConnectorConfiguration azureConnectorConfiguration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        return new AzureConnector(this.connectorService, this.atlasUserAdapter, azureConnectorConfiguration, newConnector, lastUpdated);
    }

    @Override
    @Nonnull
    public AzureConnectorConfiguration createEmptyConfiguration(String uniqueId) {
        AzureConnectorConfigurationImpl mutableConfig = new AzureConnectorConfigurationImpl();
        mutableConfig.setName("new Azure");
        mutableConfig.setUniqueId(uniqueId);
        return mutableConfig;
    }

    @Override
    @Nonnull
    public Class<AzureConnector> getConnectorClass() {
        return AzureConnector.class;
    }

    @Override
    @Nonnull
    public Class<AzureConnectorConfiguration> getConfigurationClass() {
        return AzureConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Azure";
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "This is a connector for Azure Active Directory.";
    }

    @Override
    @Nonnull
    public String getFilenameForConfigurationFragment() {
        return "frontend/editAzureConnector.json";
    }

    @Override
    protected void migrateSpecificConfigurationToVersion2(ObjectNode configurationNode, List<AttributeTransformationConfig> attributeTransformationConfigs) {
        attributeTransformationConfigs.add(AzureConnectorConfigurationImpl.ACTIVE_TRANSFORMATION);
        JsonNode userAttributeMappings = configurationNode.get("userAttributeMapping");
        if (userAttributeMappings instanceof ArrayNode) {
            userAttributeMappings.forEach(mapping -> {
                JsonNode connectorFieldExpression = mapping.get("connectorFieldExpression");
                if (!connectorFieldExpression.isNull() && connectorFieldExpression.isTextual() && connectorFieldExpression.asText().contains("manager.")) {
                    configurationNode.put("fetchManager", true);
                }
            });
        }
    }

    @Override
    public String getSingleSyncInputTitle() {
        return "Azure Identifier";
    }

    @Override
    public String getSingleSyncInputDescription() {
        return "Please enter the objectID or the userPrincipalName of the Azure user to update.";
    }

    @Override
    @Nonnull
    public ValidationResult validate(@Nonnull AzureConnectorConfiguration config) {
        boolean profilePictureDataIsMapped;
        ValidationResult validationResult = super.validate(config);
        if (StringUtil.isNullOrEmpty(config.getAzureEndpoint())) {
            validationResult.add("azureEndpoint", "Azure API Endpoint must be set");
        }
        if (StringUtil.isNullOrEmpty(config.getGraphEndpoint())) {
            validationResult.add("graphEndpoint", "Graph API Endpoint must be set");
        }
        if (StringUtil.isNullOrEmpty(config.getDirectoryTenantId())) {
            validationResult.add("directoryTenantId", "Directory (tenant) ID must be set", null);
        }
        if (config.isFetchDistributionGroups()) {
            validationResult.add("fetchDistributionGroups", null, ValidationMessage.create("Fetching Distribution Groups is enabled. This may have security implications", "https://wiki.resolution.de/go/usersync/azure/grouptypes"));
        }
        if (config.isFetchOffice365GroupsNonSecurityEnabled()) {
            validationResult.add("fetchOffice365GroupsNonSecurityEnabled", null, ValidationMessage.create("Fetching Office 365 Groups (Non-Security-Enabled) is enabled. This may have security implications", "https://wiki.resolution.de/go/usersync/azure/grouptypes"));
        }
        if (config.isGroupSyncDisabled() && !config.getRequiredConnectorGroups().isEmpty()) {
            validationResult.addWarning("Synchronization of all Azure group types is disabled and one or more required groups are configured. This would filter out all users during the sync and would apply the cleanup behaviour to all existing users in the directory");
        }
        String azureEndpoint = StringUtil.isNullOrEmpty(config.getAzureEndpoint()) ? "https://portal.azure.com" : config.getAzureEndpoint();
        String appUrlBase = String.format("%s/#blade/Microsoft_AAD_RegisteredApps/ApplicationMenuBlade", azureEndpoint);
        String appUrlOverview = String.format("%s/Overview/appId/%s/isMSAApp/", appUrlBase, config.getClientId());
        Optional<String> refreshToken = this.connectorService.getConnectorStorageManager().get(config.getUniqueId(), "REFRESH_TOKEN");
        if (refreshToken.isPresent()) {
            validationResult.addError(ValidationMessage.create("This connector is using a no longer supported authorization method. Please follow these steps to switch to the new authorization method or downgrade to the latest SAML Single Sign On 4.0.x or User Sync 1.9.x version."));
            String appUrlAPIPermissions = String.format("%s/CallAnAPI/appId/%s/isMSAApp/", appUrlBase, config.getClientId());
            validationResult.addError(ValidationMessage.create("First, set the required permissions and grant admin consent for your application in the Azure portal as described in our documentation.", appUrlAPIPermissions));
            String resetUrl = String.format("%s/plugins/servlet/de.resolution.usersync/oauth2/resetAuthorization?connectorId=%s", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE), config.getUniqueId());
            validationResult.addError(ValidationMessage.create("Afterwards, click the following link to switch to the new authorization method. This cannot be undone. Reload this page afterwards.", resetUrl));
        }
        if ("common".equals(config.getDirectoryTenantId())) {
            String message = "Please enter the directory (tenant) ID of your application, as \"common\" is no longer a supported endpoint.";
            String link = null;
            if (!StringUtil.isNullOrEmpty(config.getClientId())) {
                message = message + " You can find the directory (tenant) ID in the Overview section of your application config in the Azure portal.";
                link = appUrlOverview;
            }
            validationResult.add("directoryTenantId", ValidationMessage.create(message, link), null);
        }
        if (config.isFetchProfilePicture() && !(profilePictureDataIsMapped = UserSyncUtils.mappingWithTargetNameExists(config, "ATTR_PROFILE_PICTURE_DATA"))) {
            validationResult.add("fetchProfilePicture", null, ValidationMessage.create("The attribute mapping does not contain a mapping for \"Profile Picture\". Syncing profile pictures will only work correctly if this attribute is mapped."));
        }
        return validationResult;
    }
}

