/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.frontend;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.retransform.frontend.AttributeMappingOptionGroup;
import de.resolution.retransform.frontend.AttributeMappingOptionProvider;
import de.resolution.retransform.frontend.ResourceLoader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAttributeMappingOptionProvider
implements AttributeMappingOptionProvider {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public List<AttributeMappingOptionGroup> getOptions() {
        List<AttributeMappingOptionGroup> optionGroups = this.load("generalAttributeMappingOptions");
        optionGroups.addAll(this.getSpecificOptions());
        return optionGroups;
    }

    public abstract List<AttributeMappingOptionGroup> getSpecificOptions();

    protected List<AttributeMappingOptionGroup> load(String name) {
        String json = ResourceLoader.load("data/attributeMappingOptions/" + name + ".json");
        if (json != null && !json.isEmpty()) {
            try {
                return objectMapper.readValue(json, new TypeReference<List<AttributeMappingOptionGroup>>(){});
            }
            catch (IOException e) {
                throw new ResourceLoader.LoadingFailedException("Failed to load AttributeMappingGroups: " + e.getMessage(), e);
            }
        }
        return Collections.emptyList();
    }
}

