/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.resolution.atlasuser.api.ExceptionInfo;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class ExceptionInfoImpl
implements ExceptionInfo {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionInfoImpl.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
    private final ExceptionInfoImpl cause;
    private final String className;
    private final String message;
    private final long creationNanoTime;
    private final boolean logged;

    @JsonCreator
    public ExceptionInfoImpl(@JsonProperty(value="cause") ExceptionInfoImpl cause, @JsonProperty(value="className") String className, @JsonProperty(value="message") String message, @JsonProperty(value="creationTime") long creationNanoTime, @JsonProperty(value="logged") boolean logged) {
        this.cause = cause;
        this.className = className;
        this.message = message;
        this.creationNanoTime = creationNanoTime;
        this.logged = logged;
    }

    public ExceptionInfoImpl(Throwable ex, boolean logException) {
        this.creationNanoTime = System.nanoTime();
        if (logException) {
            logger.debug("Creating ExceptionInfo with creationNanoTime =={}== for:", (Object)this.creationNanoTime, (Object)ex);
        }
        this.logged = logException;
        Throwable causeEx = ex.getCause();
        this.cause = causeEx != null ? new ExceptionInfoImpl(causeEx, false) : null;
        this.className = ex.getClass().getCanonicalName();
        this.message = ex.getMessage();
    }

    @Override
    public ExceptionInfoImpl getCause() {
        return this.cause;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public long getCreationNanoTime() {
        return this.creationNanoTime;
    }

    @Override
    public boolean isLogged() {
        return this.logged;
    }

    @Override
    public String asJson() {
        try {
            return objectWriter.writeValueAsString(this);
        }
        catch (Exception e) {
            logger.error("Writing JSON failed", (Throwable)e);
            return "{\"error\" : \"" + e.getClass().getCanonicalName() + ": " + e.getMessage() + "\"}";
        }
    }

    public static ExceptionInfoImpl fromJson(@Nonnull String jsonString) throws IOException {
        return objectMapper.readValue(jsonString, ExceptionInfoImpl.class);
    }
}

