/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.types.AttributeDefinition;

public class Address {
    @Attribute(description="The full mailing address, formatted for display or use with a mailing label. This attribute MAY contain newlines.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String formatted;
    @Attribute(description="The full street address component, which may include house number, street name, PO BOX, and multi-line extended street address information. This attribute MAY contain newlines.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String streetAddress;
    @Attribute(description="The city or locality component.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String locality;
    @Attribute(description="The state or region component.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String region;
    @Attribute(description="The zipcode or postal code component.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String postalCode;
    @Attribute(description="The country name component.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String country;
    @Attribute(description="A label indicating the attribute's function; e.g., 'work' or 'home'.", isRequired=false, isCaseExact=false, canonicalValues={"work", "home", "other"}, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String type;
    @Attribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred address. The primary attribute value 'true' MUST appear no more than once.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Boolean primary;

    public String getFormatted() {
        return this.formatted;
    }

    public Address setFormatted(String formatted) {
        this.formatted = formatted;
        return this;
    }

    public String getStreetAddress() {
        return this.streetAddress;
    }

    public Address setStreetAddress(String streetAddress) {
        this.streetAddress = streetAddress;
        return this;
    }

    public String getLocality() {
        return this.locality;
    }

    public Address setLocality(String locality) {
        this.locality = locality;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public Address setRegion(String region) {
        this.region = region;
        return this;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public Address setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public String getCountry() {
        return this.country;
    }

    public Address setCountry(String country) {
        this.country = country;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Address setType(String type) {
        this.type = type;
        return this;
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public Address setPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        if (this.formatted != null ? !this.formatted.equals(address.formatted) : address.formatted != null) {
            return false;
        }
        if (this.streetAddress != null ? !this.streetAddress.equals(address.streetAddress) : address.streetAddress != null) {
            return false;
        }
        if (this.locality != null ? !this.locality.equals(address.locality) : address.locality != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(address.region) : address.region != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(address.postalCode) : address.postalCode != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(address.country) : address.country != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(address.type) : address.type != null) {
            return false;
        }
        return !(this.primary == null ? address.primary != null : !this.primary.equals(address.primary));
    }

    public int hashCode() {
        int result = this.formatted != null ? this.formatted.hashCode() : 0;
        result = 31 * result + (this.streetAddress != null ? this.streetAddress.hashCode() : 0);
        result = 31 * result + (this.locality != null ? this.locality.hashCode() : 0);
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.primary != null ? this.primary.hashCode() : 0);
        return result;
    }
}

