/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.wnameless.json.base.JacksonJsonObject;
import com.github.wnameless.json.base.JacksonJsonValue;
import com.github.wnameless.json.base.JsonArrayCore;
import com.github.wnameless.json.base.JsonSource;
import com.github.wnameless.json.base.TransformIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Objects;

public final class JacksonJsonArray
implements JsonArrayCore<JacksonJsonValue> {
    private final ArrayNode jsonArray;

    public JacksonJsonArray(ArrayNode jsonArray) {
        if (jsonArray == null) {
            throw new NullPointerException();
        }
        this.jsonArray = jsonArray;
    }

    @Override
    public void add(JsonSource jsonValue) {
        this.jsonArray.add((JsonNode)jsonValue.getSource());
    }

    @Override
    public void set(int index, JsonSource jsonValue) {
        this.jsonArray.set(index, (JsonNode)jsonValue.getSource());
    }

    @Override
    public JacksonJsonValue remove(int index) {
        return new JacksonJsonValue(this.jsonArray.remove(index));
    }

    @Override
    public JacksonJsonValue get(int index) {
        return new JacksonJsonValue(this.jsonArray.get(index));
    }

    @Override
    public int size() {
        return this.jsonArray.size();
    }

    @Override
    public Iterator<JacksonJsonValue> iterator() {
        return new TransformIterator<JsonNode, JacksonJsonValue>(this.jsonArray.iterator(), JacksonJsonValue::new);
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JacksonJsonObject asObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JacksonJsonArray asArray() {
        return this;
    }

    @Override
    public JacksonJsonValue asValue() {
        return new JacksonJsonValue(this.jsonArray);
    }

    @Override
    public Object getSource() {
        return this.jsonArray;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public int hashCode() {
        return this.jsonArray.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonJsonArray)) {
            return false;
        }
        return Objects.equals(this.jsonArray, ((JacksonJsonArray)o).jsonArray);
    }

    public String toString() {
        return this.jsonArray.toString();
    }
}

