/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import de.resolution.usersync.api.exception.UserSyncRuntimeException;
import de.resolution.usersync.impl.requiredgroups.GroovyBasedRequiredGroupChecker;
import de.resolution.usersync.impl.requiredgroups.RegexBasedRequiredGroupChecker;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.impl.requiredgroups.ServerFilterBasedRequiredGroupChecker;
import de.resolution.usersync.rest.entities.PreviewRequiredGroupsEntity;
import de.resolution.usersync.spi.ConnectorConfiguration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface RequiredGroupChecker {
    @Nonnull
    public static RequiredGroupCheckerHolder create(@Nonnull ConnectorConfiguration configuration) {
        return RequiredGroupChecker.create(configuration.isUseRequiredConnectorGroupsServerFilter(), configuration.getRequiredConnectorGroupsServerFilter(), configuration.isUseRequiredConnectorGroupsGroovy(), configuration.getRequiredConnectorGroupsGroovy(), configuration.getRequiredConnectorGroups());
    }

    @Nonnull
    public static RequiredGroupCheckerHolder create(@Nonnull PreviewRequiredGroupsEntity previewRequiredGroupsEntity) {
        return RequiredGroupChecker.create(previewRequiredGroupsEntity.isUseRequiredConnectorGroupsServerFilter(), previewRequiredGroupsEntity.getRequiredConnectorGroupsServerFilter(), previewRequiredGroupsEntity.isUseRequiredConnectorGroupsGroovy(), previewRequiredGroupsEntity.getRequiredConnectorGroupsGroovy(), previewRequiredGroupsEntity.getRequiredConnectorGroups());
    }

    @Nonnull
    public static RequiredGroupCheckerHolder create(boolean useRequiredConnectorGroupsServerFilter, @Nullable String requiredConnectorGroupsServerFilter, boolean useRequiredConnectorGroupsGroovy, @Nullable String requiredConnectorGroupsGroovy, @Nullable List<String> requiredConnectorGroups) {
        RequiredGroupCheckerHolder requiredGroupCheckerHolder = new RequiredGroupCheckerHolder();
        try {
            if (useRequiredConnectorGroupsServerFilter) {
                if (requiredConnectorGroupsServerFilter == null || requiredConnectorGroupsServerFilter.isEmpty()) {
                    throw new UserSyncRuntimeException("Invalid configuration. getRequiredConnectorGroupsServerFilter cannot be null or empty when this option is enabled");
                }
                requiredGroupCheckerHolder.setServerFilterBasedRequiredGroupChecker(new ServerFilterBasedRequiredGroupChecker(requiredConnectorGroupsServerFilter));
            }
            if (useRequiredConnectorGroupsGroovy) {
                if (requiredConnectorGroupsGroovy == null || requiredConnectorGroupsGroovy.isEmpty()) {
                    throw new UserSyncRuntimeException("Invalid configuration. getRequiredConnectorGroupsGroovy cannot be null or empty when this option is enabled");
                }
                requiredGroupCheckerHolder.setLocalRequiredGroupChecker(GroovyBasedRequiredGroupChecker.create(requiredConnectorGroupsGroovy));
            } else if (requiredConnectorGroups != null && !requiredConnectorGroups.isEmpty()) {
                requiredGroupCheckerHolder.setLocalRequiredGroupChecker(new RegexBasedRequiredGroupChecker(requiredConnectorGroups));
            }
        }
        catch (Exception e) {
            throw new UserSyncRuntimeException("Failed to create RequiredGroupChecker, this should have been handled during validation", e);
        }
        return requiredGroupCheckerHolder;
    }
}

