/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.commons.util.boundedregex;

import de.resolution.commons.util.boundedregex.CancelControl;
import java.util.stream.IntStream;

public class InterruptableCharSequence
implements CharSequence {
    private final String inner;
    private final CancelControl cancelControl;

    InterruptableCharSequence(String inner, CancelControl cancelControl) {
        this.inner = inner;
        this.cancelControl = cancelControl;
    }

    @Override
    public int length() {
        this.checkForInterruption();
        return this.inner.length();
    }

    @Override
    public char charAt(int index) {
        this.checkForInterruption();
        return this.inner.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.checkForInterruption();
        return this.inner.subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        this.checkForInterruption();
        return this.inner.chars();
    }

    @Override
    public IntStream codePoints() {
        this.checkForInterruption();
        return this.inner.codePoints();
    }

    private void checkForInterruption() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CharSequenceInterruptedException();
        }
        if (this.cancelControl.isCancelled()) {
            throw new CharSequenceInterruptedException();
        }
    }

    @Override
    public String toString() {
        return this.inner;
    }

    static class CharSequenceInterruptedException
    extends RuntimeException {
        CharSequenceInterruptedException() {
        }
    }
}

