/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlasuser.impl.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.impl.user.ImmutableAtlasUserReference;
import de.resolution.commons.util.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ImmutableAtlasUser
implements AtlasUser {
    private final Map<String, Set<String>> attributes;
    private final AtlasUserReference atlasUserReference;

    ImmutableAtlasUser(@Nonnull AtlasUserReference atlasUserReference, @Nonnull Map<String, Set<String>> attributes) {
        this.atlasUserReference = atlasUserReference;
        this.attributes = new HashMap<String, Set<String>>();
        attributes.forEach((key, val) -> this.attributes.put((String)key, new HashSet(val)));
    }

    @JsonCreator
    ImmutableAtlasUser(@JsonProperty(value="reference") ImmutableAtlasUserReference atlasUserReference, @JsonProperty(value="attributes") Map<String, Set<String>> attributes) {
        this((AtlasUserReference)atlasUserReference, attributes);
    }

    @Override
    @Nonnull
    public AtlasUserReference getReference() {
        return this.atlasUserReference;
    }

    @Override
    @Nonnull
    public Map<String, Set<String>> getAttributes() {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        this.attributes.forEach((key, value) -> ret.put((String)key, new HashSet(value)));
        return ret;
    }

    @Override
    @Nonnull
    public Set<String> getAttributeValues(@Nonnull String key) {
        Collection value = this.attributes.get(key);
        if (value == null || value.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(value);
    }

    @Override
    public boolean containsKey(@Nonnull String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    @Nonnull
    public Set<String> getAttributeKeys() {
        return new HashSet<String>(this.attributes.keySet());
    }

    @Override
    public boolean isEqualSuperset(AtlasUser other, Collection<String> ignoreTheseAttributes) {
        return other.getAttributes().keySet().stream().allMatch(key -> {
            if (ignoreTheseAttributes.contains(key)) {
                return true;
            }
            Set<String> mySet = this.attributes.get(key);
            return CollectionUtil.containsSame(mySet, (Collection<String>)other.getAttributes().get(key));
        });
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.get("ATTR_NAME").orElse(null);
    }
}

