/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.task.api.Task;
import de.resolution.reconfigure.Utils;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.frontend.AttributeMappingTemplateMap;
import de.resolution.retransform.frontend.AttributeMappingUtils;
import de.resolution.retransform.frontend.TargetTypeMap;
import de.resolution.usersync.api.ConfluenceReadOnlyModeDetector;
import de.resolution.usersync.api.ConnectorAndValidationResult;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.LabelValue;
import de.resolution.usersync.api.LinchpinEventSender;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncFunctionFactory;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.api.UserSyncService;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.api.exception.SyncAlreadyRunningException;
import de.resolution.usersync.api.exception.SyncCanceledException;
import de.resolution.usersync.impl.SyncJobRunner;
import de.resolution.usersync.impl.SyncStatusAoProxy;
import de.resolution.usersync.spi.Connector;
import de.resolution.usersync.spi.ConnectorConfiguration;
import de.resolution.usersync.spi.ProfilePictureCapableConnectorConfiguration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService(value={UserSyncService.class})
public class UserSyncServiceImpl
implements UserSyncService {
    private static final Logger logger = LoggerFactory.getLogger(UserSyncServiceImpl.class);
    private final ConnectorService connectorService;
    private final SyncFunctionFactory syncFunctionFactory;
    private final SyncStatusRepository syncStatusRepository;
    private final DirectoryAdapter directoryAdapter;
    private final LicenseChecker licenseChecker;
    private final SchedulerService schedulerService;
    private final ConfluenceReadOnlyModeDetector confluenceReadOnlyModeDetector;
    private final LinchpinEventSender linchpinEventSender;

    @Inject
    public UserSyncServiceImpl(ConnectorService connectorService, SyncStatusRepository syncStatusRepository, SyncFunctionFactory syncFunctionFactory, DirectoryAdapter directoryAdapter, LicenseChecker licenseChecker, ConfluenceReadOnlyModeDetector confluenceReadOnlyModeDetector, @ComponentImport SchedulerService schedulerService, LinchpinEventSender linchpinEventSender) {
        this.connectorService = connectorService;
        this.syncFunctionFactory = syncFunctionFactory;
        this.syncStatusRepository = syncStatusRepository;
        this.directoryAdapter = directoryAdapter;
        this.licenseChecker = licenseChecker;
        this.confluenceReadOnlyModeDetector = confluenceReadOnlyModeDetector;
        this.schedulerService = schedulerService;
        this.linchpinEventSender = linchpinEventSender;
    }

    @Override
    public SyncStatus sync(String connectorUID) {
        SyncStatusAoProxy syncStatus = this.syncStatusRepository.create(connectorUID);
        try {
            ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.getConnectorByUniqueId(connectorUID);
            if (!connectorAndValidationResult.getValidationResult().isValid()) {
                syncStatus.facade().fail("Connector is not valid, cannot start sync", logger);
                return syncStatus;
            }
        }
        catch (Exception e) {
            syncStatus.facade().fail("Loading connector failed", e, logger);
            return syncStatus;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("CONNECTOR_UID", connectorUID);
        parameters.put("SYNCSTATUS_ID", syncStatus.getId());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)SyncJobRunner.JOB_RUNNER_KEY).withSchedule(Schedule.runOnce((Date)new Date())).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withParameters(parameters);
        try {
            JobId jobId = this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            syncStatus.addMessage("Scheduled with jobid " + jobId);
        }
        catch (SchedulerServiceException e) {
            logger.error("Scheduling job for immediate sync failed!", (Throwable)e);
        }
        return syncStatus;
    }

    @Override
    public void sync(String connectorUID, int syncStatusId) throws SyncAlreadyRunningException {
        Object connector;
        SyncStatus syncStatus = this.syncStatusRepository.get(syncStatusId).orElseThrow(() -> new RuntimeException("SyncStatus " + syncStatusId + " was not found!"));
        try {
            connector = this.connectorService.getConnectorByUniqueId(connectorUID).getConnector();
        }
        catch (Exception e) {
            syncStatus.facade().fail(e, logger);
            return;
        }
        if (this.syncStatusRepository.isRunning(connector.getUniqueId())) {
            syncStatus.setStatus(Task.Status.DONE);
            syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
            syncStatus.addMessage("There is already a sync in progress. Check history for more details.");
            throw new SyncAlreadyRunningException();
        }
        LicenseStatus licenseStatus = this.licenseChecker.checkLicense();
        if (!licenseStatus.isLicensed()) {
            syncStatus.addMessage(licenseStatus.getMessage());
            syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
            syncStatus.setStatus(Task.Status.DONE);
            return;
        }
        this.syncStatusRepository.cleanup(connectorUID, connector.getConfiguration().getResultsToKeep());
        this.syncStatusRepository.cleanupLegacy(604800L);
        if (this.confluenceReadOnlyModeDetector.isReadOnlyMode()) {
            syncStatus.addMessage("Read only mode is active, but we behave like LDAP-directories and sync.");
        }
        Object config = connector.getConfiguration();
        if (connector.isCanSync()) {
            if (!this.directoryAdapter.exists(connector.getConfiguration().getDirectoryId())) {
                syncStatus.addMessage(String.format("Directory %d does not exist", config.getDirectoryId()));
                syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
                syncStatus.setStatus(Task.Status.DONE);
            } else if (!this.directoryAdapter.isActive(config.getDirectoryId())) {
                syncStatus.addMessage(String.format("Directory %d is inactive.", config.getDirectoryId()));
                syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
                syncStatus.setStatus(Task.Status.DONE);
            } else if (!(config.isOverrideReadOnlyDirectoryCheck() || this.directoryAdapter.isWritable(config.getDirectoryId()) || connector.isReadOnly())) {
                syncStatus.addMessage(String.format("Directory %d is not writable", config.getDirectoryId()));
                syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
                syncStatus.setStatus(Task.Status.DONE);
            } else {
                SyncFunction syncFunction = this.syncFunctionFactory.create((Connector<? extends ConnectorConfiguration>)connector, syncStatus);
                try {
                    if (this.connectorService.validate(connector).isValid()) {
                        connector.sync(syncFunction, syncStatus);
                    }
                    syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
                    syncStatus.addMessage("Connector is not valid or unconfigured, cannot start sync");
                    syncStatus.setStatus(Task.Status.DONE);
                }
                catch (SyncCanceledException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    syncStatus.setStatus(e.getStatus());
                }
                catch (Exception e) {
                    if (e.getClass().getName().contains("ServiceProxyDestroyedException")) {
                        logger.warn("ServiceProxyDestroyedException during sync {} in connector {}, this usually happens if the Plugin is disabled or uninstalled while a sync is running.", (Object)syncStatusId, (Object)connectorUID);
                        logger.warn("The sync-status will stay RUNNING, but this will change to DEAD when the Plugin is enabled again.");
                        logger.warn("", (Throwable)e);
                    }
                    logger.error("Unexpected exception during sync {} in connector {}", new Object[]{syncStatusId, connectorUID, e});
                    syncStatus.addMessage(String.format("Unexpected Exception: %s: %s", e.getClass().getCanonicalName(), e.getMessage()));
                    syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
                    syncStatus.setStatus(Task.Status.DONE);
                }
                catch (Error e) {
                    logger.error("Unexpected error during sync {} in connector {}", new Object[]{syncStatusId, connectorUID, e});
                    syncStatus.addMessage(String.format("Unexpected Error: %s: %s", e.getClass().getCanonicalName(), e.getMessage()));
                    syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
                    syncStatus.setStatus(Task.Status.DONE);
                    throw e;
                }
            }
        } else {
            syncStatus.addMessage("This connector does not support synchronization");
            syncStatus.setSyncStatusResult(SyncStatus.Result.FAILED);
            syncStatus.setStatus(Task.Status.DONE);
        }
    }

    @Override
    public SyncSingleUserResult syncSingleUser(@Nonnull String identifier, @Nullable MapStructuredData additionalData, @Nullable Map<String, Set<String>> attributesToOverride, @Nonnull String connectorUID) throws ConfigurationFailedException, ConnectorFactoryNotAvailableException, ConnectorNotFoundException {
        return this.syncSingleUser(identifier, additionalData, attributesToOverride, null, connectorUID);
    }

    @Override
    public SyncSingleUserResult syncSingleUser(@Nonnull String identifier, @Nullable MapStructuredData additionalData, @Nullable Map<String, Set<String>> attributesToOverride, @Nullable String overridingPrimaryAttribute, @Nonnull String connectorUID) throws ConfigurationFailedException, ConnectorFactoryNotAvailableException, ConnectorNotFoundException {
        ConnectorAndValidationResult connectorAndValidationResult = this.connectorService.getConnectorByUniqueId(connectorUID);
        Object connector = connectorAndValidationResult.getConnector();
        Object configuration = connector.getConfiguration();
        LicenseStatus licenseStatus = this.licenseChecker.checkLicense();
        if (!licenseStatus.isLicensed()) {
            return SyncSingleUserResult.createFailure(licenseStatus.getMessage());
        }
        if (connector.isCanSyncSingleUser()) {
            if (!this.directoryAdapter.exists(configuration.getDirectoryId())) {
                return SyncSingleUserResult.createFailure(String.format("Directory %d does not exist", configuration.getDirectoryId()));
            }
            if (!this.directoryAdapter.isActive(configuration.getDirectoryId())) {
                return SyncSingleUserResult.createFailure(String.format("Directory %d is inactive.", configuration.getDirectoryId()));
            }
            if (!this.directoryAdapter.isWritable(configuration.getDirectoryId())) {
                return SyncSingleUserResult.createFailure(String.format("Directory %d is not writable", configuration.getDirectoryId()));
            }
            if (logger.isInfoEnabled() && this.confluenceReadOnlyModeDetector.isReadOnlyMode()) {
                logger.info("Readonly mode is active, but we behave like an LDAP-directory and update the user.");
            }
            if (connectorAndValidationResult.getValidationResult().isValid()) {
                try {
                    SyncSingleUserResult syncSingleUserResult = connector.syncSingleUser(identifier, additionalData, attributesToOverride, overridingPrimaryAttribute);
                    this.linchpinEventSender.sendUserUpdatedEvent(syncSingleUserResult.getUpdateUserResult(), (Connector<?>)connector);
                    return syncSingleUserResult;
                }
                catch (Exception e) {
                    return SyncSingleUserResult.createFailure(e);
                }
            }
            return SyncSingleUserResult.createFailure("Connector is invalid");
        }
        return SyncSingleUserResult.createFailure("Single User Sync is not supported by this connector");
    }

    @Override
    public List<LabelValue<String, String>> getAvailableConnectorNamesAndUniqueIds() {
        return this.connectorService.getAvailableConnectorNamesAndUniqueIds();
    }

    @Override
    @Nullable
    public String getConnectorUIDforLegacyId(int connectorId) {
        return this.connectorService.getConnectorUIDforLegacyId(connectorId);
    }

    @Override
    public boolean isUserSyncInitialized() {
        return this.connectorService.isInitialized();
    }

    @Override
    public void initUserSync() {
        this.connectorService.initUserSyncConnectors();
    }

    @Override
    public Map<String, Object> getAnalyticsData(int consentLevel) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> connectorData = new ArrayList<HashMap<String, Object>>();
        data.put("len", this.connectorService.getConnectors().size());
        for (ConnectorAndValidationResult connectorAndValidationResult : this.connectorService.getConnectors()) {
            HashMap<String, Object> currentData = new HashMap<String, Object>();
            Object connector = connectorAndValidationResult.getConnector();
            String type = connector.getClass().getSimpleName();
            currentData.put("type", type);
            TargetTypeMap targetTypeMap = connector.getAttributeMappingTemplates();
            AttributeMappingTemplateMap attributeMappingTemplateMap = new AttributeMappingTemplateMap();
            attributeMappingTemplateMap.put(type, targetTypeMap);
            Map<String, Object> attributes = AttributeMappingUtils.getMatchingPresetsForAnalytics(connector.getConfiguration().getAttributeTransformationConfigs(), type, attributeMappingTemplateMap);
            Utils.flattenAndIntegrateWithPrefix(currentData, "attributes", attributes);
            currentData.put("usesToLowerCaseTransformation", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().isToLowerCase()));
            currentData.put("usesSplitTransformation", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getSplitAttribute().isEnabled()));
            currentData.put("usesAddConstantTransformation", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getAddConstant().isEnabled()));
            currentData.put("usesRegexAndReplacementTransformation", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getTransformations().getRegexAndReplacement().isEnabled()));
            currentData.put("isGroovySourceType", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.GROOVY)));
            currentData.put("isFirstSourceType", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.FIRST)));
            currentData.put("isFieldcombinerSourceType", connector.getConfiguration().getAttributeTransformationConfigs().stream().anyMatch(atc -> atc.getSource().getType().equals((Object)Source.Type.FIELD_COMBINER)));
            currentData.put("customFindByAttributeName", !connector.getConfiguration().getFindByAttributeName().equals(connector.getConfiguration().getDefaultFindByAttributeName()));
            currentData.put("groupsToKeepContainWildcard", connector.getConfiguration().getGroupsToKeep().stream().anyMatch(s -> s.equals(".*")));
            currentData.put("isScheduled", connector.getConfiguration().isScheduled());
            currentData.put("cleanupBehaviour", (Object)connector.getConfiguration().getCleanupBehaviour());
            currentData.put("isRemoveAllGroupAssignmentsOnCleanup", connector.getConfiguration().isRemoveAllGroupAssignmentsOnCleanup());
            if (connector.getConfiguration() instanceof ProfilePictureCapableConnectorConfiguration) {
                ProfilePictureCapableConnectorConfiguration conf = (ProfilePictureCapableConnectorConfiguration)connector.getConfiguration();
                currentData.put("isFetchProfilePicture", conf.isFetchProfilePicture());
            }
            connectorData.add(currentData);
        }
        data.put("connectors", connectorData);
        return data;
    }
}

