/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.TransformationResults;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"success", "operation", "transformationResults", "atlasUserResult"})
public class ImmutableSyncUserResult
implements SyncUserResult {
    private final AtlasUserResult atlasUserResult;
    private final TransformationResults transformationResults;
    private final String message;

    public ImmutableSyncUserResult(@Nullable TransformationResults transformationResults, @Nullable AtlasUserResult atlasUserResult, @Nullable String message) {
        this.transformationResults = transformationResults;
        this.atlasUserResult = atlasUserResult;
        this.message = message;
    }

    @Override
    @Nullable
    public AtlasUserResult getAtlasUserResult() {
        return this.atlasUserResult;
    }

    @Override
    @Nullable
    public TransformationResults getTransformationResults() {
        return this.transformationResults;
    }

    @Override
    public boolean isSuccess() {
        if (this.atlasUserResult != null) {
            return this.atlasUserResult.isSuccess();
        }
        if (this.transformationResults != null) {
            return this.transformationResults.isDropAll();
        }
        return false;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    public SyncUserResult.Operation getOperation() {
        if (this.transformationResults != null && this.transformationResults.isDropAll()) {
            return SyncUserResult.Operation.FILTERED;
        }
        if (this.atlasUserResult == null) {
            return SyncUserResult.Operation.NONE;
        }
        switch (this.atlasUserResult.getOperation()) {
            case ADDED: {
                return SyncUserResult.Operation.ADDED;
            }
            case DELETED: {
                return SyncUserResult.Operation.DELETED;
            }
            case UPDATED: {
                return SyncUserResult.Operation.UPDATED;
            }
            case NOT_MODIFIED: {
                return SyncUserResult.Operation.NOT_MODIFIED;
            }
            case FILTERED: {
                return SyncUserResult.Operation.FILTERED;
            }
        }
        return SyncUserResult.Operation.NONE;
    }
}

