/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.okta;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.HTTPRequestFailedException;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.ConnectorGroup;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.ConfigurationFailedException;
import de.resolution.usersync.builtin.okta.OktaConnectorConfiguration;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckFailedException;
import de.resolution.usersync.impl.requiredgroups.RequiredGroupCheckerHolder;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.AbstractHTTPConnector;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaConnector
extends AbstractHTTPConnector<OktaConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(OktaConnector.class);
    public static final int HTTP_STATUS_TOO_MANY_REQUESTS = 429;
    public static final String PATH_SEGMENT_USERS = "users";
    public static final String PATH_SEGMENT_GROUPS = "groups";
    public static final String PARAMETER_LIMIT = "limit";
    public static final String OKTA_ATTRIBUTE_ID = "id";
    public static final Pattern HEADER_LINK_REGEX = Pattern.compile("<(.*)>; rel=\"next\"");
    public static final String STATUS = "status";
    public static final String STATUS_DEPROVISIONED = "DEPROVISIONED";
    private static final Random RANDOM = new SecureRandom();
    private static final List<String> CONNECTOR_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("id", "status", "activated", "statusChanged", "lastLogin", "lastUpdated", "passwordChanged", "profile.login", "profile.firstName", "profile.lastName", "profile.nickName", "profile.displayName", "profile.email", "profile.secondEmail", "profile.profileUrl", "profile.preferredLanguage", "profile.userType", "profile.organization", "profile.title", "profile.division", "profile.department", "profile.costCenter", "profile.employeeNumber", "profile.mobilePhone", "profile.primaryPhone", "profile.streetAddress", "profile.city", "profile.state", "profile.zipCode", "profile.countryCode", "GROUPS"));

    OktaConnector(ConnectorService connectorService, AtlasUserAdapter atlasUserAdapter, OktaConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/OktaConnector.json");
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        if (this.getRequiredGroupCheckerHolder().hasRequiredGroupsConfigured()) {
            this.fetchUsersFromRequiredGroups(syncFunction, syncStatusFacade);
        } else {
            this.fetchAllUsers(syncFunction, syncStatusFacade);
        }
    }

    @Override
    @Nonnull
    public FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        SyncStatusFacade syncStatusFacade = SyncStatusFacade.nullFacade();
        HttpUrl url = this.getUsersUrlBase().addPathSegment(identifier).build();
        ResponseWrapper oktaResponse = this.performGetRequest(url, true, syncStatusFacade);
        if (oktaResponse.isNotFound()) {
            return FindUserResult.notFound();
        }
        if (!oktaResponse.isSuccess()) {
            return FindUserResult.failed(oktaResponse.getMessage());
        }
        StructuredData userAttributes = oktaResponse.getParsedJson();
        if (STATUS_DEPROVISIONED.equals(userAttributes.findString(STATUS))) {
            return FindUserResult.notFound();
        }
        String userIdentifier = userAttributes.findString(OKTA_ATTRIBUTE_ID);
        if (userIdentifier == null) {
            return FindUserResult.failed("userIdentifier is null, that's unexpected here.");
        }
        try {
            Set<ConnectorGroup> groupsForUser = this.fetchGroupsForUser(userIdentifier, syncStatusFacade);
            List groupsNamesForUser = groupsForUser.stream().map(ConnectorGroup::getName).filter(Objects::nonNull).collect(Collectors.toList());
            userAttributes.put("GROUPS", groupsNamesForUser);
            if (!((OktaConnectorConfiguration)this.configuration).isIgnoreRequiredConnectorGroupsOnSingleUserSync() && !this.matchesRequiredConnectorGroups(groupsForUser)) {
                logger.debug("Required groups don't match, returning PREFILTERED");
                return FindUserResult.preFiltered(userAttributes);
            }
            return FindUserResult.found(userAttributes);
        }
        catch (HTTPRequestFailedException e) {
            return FindUserResult.failed(e);
        }
    }

    public void fetchAllUsers(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        syncStatusFacade.add("No required groups set, syncing all users.", SyncStatusFacade.LogLevel.DEBUG, logger);
        HttpUrl nextPageUrl = null;
        do {
            int resultCount;
            HttpUrl url;
            if (nextPageUrl == null) {
                url = this.getUsersUrlBase().addQueryParameter(PARAMETER_LIMIT, String.valueOf(((OktaConnectorConfiguration)this.configuration).getPageSize())).build();
            } else {
                logger.debug("Fetching next page of users.");
                url = nextPageUrl;
            }
            ResponseWrapper response = this.syncUsersPage(url, syncFunction, syncStatusFacade, new HashSet<String>());
            nextPageUrl = OktaConnector.parseNextPageUrl(response);
            SyncStatus syncStatus = syncStatusFacade.getSyncStatus();
            if (syncStatus == null || (resultCount = syncStatus.getResultCount()) % 100 != 0) continue;
            this.trackMemoryUsage(syncStatusFacade, "after processing " + resultCount + " users");
        } while (syncStatusFacade.isRunning() && nextPageUrl != null);
    }

    public void fetchUsersFromRequiredGroups(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        Set requiredGroupIds;
        try {
            requiredGroupIds = this.fetchRequiredConnectorGroups(this.getRequiredGroupCheckerHolder(), syncStatusFacade).stream().map(ConnectorGroup::getId).collect(Collectors.toSet());
        }
        catch (RequiredGroupCheckFailedException e) {
            syncStatusFacade.fail(e, logger);
            return;
        }
        syncStatusFacade.add("Syncing members of " + requiredGroupIds.size() + " groups", SyncStatusFacade.LogLevel.DEBUG, logger);
        if (!syncStatusFacade.isRunning()) {
            return;
        }
        HashSet<String> seenUserIdentifiers = new HashSet<String>();
        for (String requiredGroupId : requiredGroupIds) {
            HttpUrl nextPageUrl = null;
            do {
                int resultCount;
                HttpUrl url = nextPageUrl == null ? this.getGroupsUrlBase().addPathSegment(requiredGroupId).addPathSegment(PATH_SEGMENT_USERS).addQueryParameter(PARAMETER_LIMIT, String.valueOf(((OktaConnectorConfiguration)this.configuration).getPageSize())).build() : nextPageUrl;
                ResponseWrapper response = this.syncUsersPage(url, syncFunction, syncStatusFacade, seenUserIdentifiers);
                nextPageUrl = OktaConnector.parseNextPageUrl(response);
                SyncStatus syncStatus = syncStatusFacade.getSyncStatus();
                if (syncStatus == null || (resultCount = syncStatus.getResultCount()) % 100 != 0) continue;
                this.trackMemoryUsage(syncStatusFacade, "after processing " + resultCount + " users");
            } while (syncStatusFacade.isRunning() && nextPageUrl != null);
            if (syncStatusFacade.isRunning()) continue;
            return;
        }
    }

    public ResponseWrapper syncUsersPage(@Nonnull HttpUrl url, @Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade, @Nonnull Set<String> seenUserIdentifiers) {
        ResponseWrapper oktaResponse = this.performGetRequest(url, true, syncStatusFacade);
        if (!oktaResponse.isSuccess()) {
            syncStatusFacade.fail("This usually means that we were not able to connect to Okta or did not get a reply. Please check your network connection and make sure that Okta's endpoints are reachable. (see https://wiki.resolution.de/go/idpEndpoints) Error message: " + oktaResponse.getMessage(), oktaResponse.getCode(), oktaResponse.getMessage(), oktaResponse.getBody(), logger);
            return oktaResponse;
        }
        for (StructuredData currentUserAttributes : oktaResponse.getParsedJson().asList()) {
            if (!syncStatusFacade.isRunning()) {
                return oktaResponse;
            }
            String userIdentifier = currentUserAttributes.findString(OKTA_ATTRIBUTE_ID);
            if (userIdentifier == null) {
                syncStatusFacade.failPartially("userIdentifier is null, that's unexpected here.", logger);
                continue;
            }
            if (seenUserIdentifiers.contains(userIdentifier)) {
                logger.debug("Skipping already synced user {}", (Object)userIdentifier);
                continue;
            }
            seenUserIdentifiers.add(userIdentifier);
            if (STATUS_DEPROVISIONED.equals(currentUserAttributes.findString(STATUS))) continue;
            try {
                currentUserAttributes.put("GROUPS", this.fetchGroupsForUser(userIdentifier, syncStatusFacade).stream().map(ConnectorGroup::getName).filter(Objects::nonNull).collect(Collectors.toList()));
                syncFunction.accept(currentUserAttributes.asMap());
            }
            catch (HTTPRequestFailedException e) {
                syncStatusFacade.failPartially("Could not retrieve groups. This is usually caused by networking issues when connecting to Okta.", e, logger);
            }
        }
        return oktaResponse;
    }

    @Nonnull
    public ResponseWrapper performGetRequest(@Nonnull HttpUrl url, boolean handleRateLimit, @Nonnull SyncStatusFacade syncStatusFacade) {
        ResponseWrapper responseWrapper = this.getHttpWrapper().get(url, Collections.singletonMap("Authorization", this.getAuthorizationHeaderValue()));
        String oktaRequestId = responseWrapper.getHeader("X-Okta-Request-Id");
        if (responseWrapper.getCode() == 401) {
            return responseWrapper.setErrorMessage("Okta returned status 401 Unauthorized. Please check your API token. X-Okta-Request-Id: " + oktaRequestId);
        }
        if (responseWrapper.getCode() == 403) {
            return responseWrapper.setErrorMessage("Okta returned status 403 Forbidden. You're not authorized to request this resource. X-Okta-Request-Id: " + oktaRequestId);
        }
        if (responseWrapper.getCode() == 429) {
            if (handleRateLimit) {
                this.handleRateLimit(responseWrapper, syncStatusFacade);
                return this.performGetRequest(url, false, syncStatusFacade);
            }
            return responseWrapper.setErrorMessage("Rate limit exceeded.");
        }
        if (handleRateLimit) {
            this.handleRateLimit(responseWrapper, syncStatusFacade);
        }
        return responseWrapper;
    }

    private void handleRateLimit(@Nonnull ResponseWrapper response, @Nonnull SyncStatusFacade syncStatusFacade) {
        int rateLimitReset;
        int rateLimitRemaining;
        int rateLimitLimit;
        if (response.getCode() != 429 && ((OktaConnectorConfiguration)this.getConfiguration()).getRateLimitThreshold() <= 0) {
            syncStatusFacade.add("Rate limit handling disabled in connector configuration.", SyncStatusFacade.LogLevel.DEBUG, logger);
            return;
        }
        try {
            rateLimitLimit = Integer.parseInt(Objects.requireNonNull(response.getHeader("X-Rate-Limit-Limit")));
            rateLimitRemaining = Integer.parseInt(Objects.requireNonNull(response.getHeader("X-Rate-Limit-Remaining")));
            rateLimitReset = Integer.parseInt(Objects.requireNonNull(response.getHeader("X-Rate-Limit-Reset")));
        }
        catch (NullPointerException | NumberFormatException e) {
            syncStatusFacade.add("Could not parse rate limit headers, ignoring rate limiting", e, SyncStatusFacade.LogLevel.ERROR, logger);
            return;
        }
        double rateLimitRatio = (1.0 - (double)rateLimitRemaining / (double)rateLimitLimit) * 100.0;
        logger.trace("X-Rate-Limit-Limit: {}, X-Rate-Limit-Remaining: {}, X-Rate-Limit-Reset: {}, Ratio: {}", new Object[]{rateLimitLimit, rateLimitRemaining, rateLimitReset, rateLimitRatio});
        if (response.getCode() != 429 && rateLimitRatio < (double)((OktaConnectorConfiguration)this.configuration).getRateLimitThreshold()) {
            logger.trace("Rate limit ratio is below configured rate limit threshold, continuing without delay.");
            return;
        }
        Instant rateLimitResetInstant = Instant.ofEpochSecond(rateLimitReset).plusMillis(RANDOM.nextInt(10000));
        syncStatusFacade.add("Rate limit threshold reached, sync will resume on " + rateLimitResetInstant, null, SyncStatusFacade.LogLevel.INFO, logger);
        while (Instant.now().isBefore(rateLimitResetInstant)) {
            syncStatusFacade.checkCancel();
            long secondsRemaining = Duration.between(Instant.now(), rateLimitResetInstant).toMillis() / 1000L;
            logger.debug("Rate limit threshold reached, waiting for {} more seconds.", (Object)secondsRemaining);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                syncStatusFacade.add("Interrupted during sleep, cancelling sync", SyncStatusFacade.LogLevel.WARN, logger);
                Thread.currentThread().interrupt();
                syncStatusFacade.cancel();
                return;
            }
        }
    }

    @Nonnull
    public HttpUrl.Builder getUrlBase() {
        return new HttpUrl.Builder().scheme("https").host(((OktaConnectorConfiguration)this.getConfiguration()).getOktaDomain()).addPathSegment("api").addPathSegment("v1");
    }

    @Nonnull
    public HttpUrl.Builder getUsersUrlBase() {
        return this.getUrlBase().addPathSegment(PATH_SEGMENT_USERS);
    }

    @Nonnull
    public HttpUrl.Builder getGroupsUrlBase() {
        return this.getUrlBase().addPathSegment(PATH_SEGMENT_GROUPS);
    }

    @Nullable
    public static HttpUrl parseNextPageUrl(ResponseWrapper response) {
        for (String linkHeader : response.getHeaders("Link")) {
            Matcher m = HEADER_LINK_REGEX.matcher(linkHeader);
            if (!m.matches()) continue;
            return HttpUrl.parse(m.group(1));
        }
        return null;
    }

    @Nonnull
    public ResponseWrapper fetchGroupsPage(@Nullable HttpUrl fetchUrl, @Nonnull SyncStatusFacade syncStatusFacade) {
        HttpUrl url = fetchUrl == null ? this.getGroupsUrlBase().addQueryParameter(PARAMETER_LIMIT, String.valueOf(((OktaConnectorConfiguration)this.configuration).getPageSize())).build() : fetchUrl;
        return this.performGetRequest(url, true, syncStatusFacade);
    }

    @Override
    @Nonnull
    public Set<ConnectorGroup> fetchRequiredConnectorGroups(@Nonnull RequiredGroupCheckerHolder requiredGroupCheckerHolder, @Nonnull SyncStatusFacade syncStatusFacade) throws RequiredGroupCheckFailedException {
        ResponseWrapper groupResponse;
        syncStatusFacade.add("Calculating required groups...", SyncStatusFacade.LogLevel.DEBUG, logger);
        HashSet<ConnectorGroup> requiredConnectorGroups = new HashSet<ConnectorGroup>();
        HttpUrl nextPageUrl = null;
        do {
            HttpUrl url;
            if (!(groupResponse = this.fetchGroupsPage(url = nextPageUrl == null ? this.getGroupsUrlBase().build() : nextPageUrl, syncStatusFacade)).isSuccess()) {
                syncStatusFacade.fail("Fetching groups failed. This usually means that we were not able to connect to Okta or did not get a reply. Please check your network connection and make sure that Okta's endpoints are reachable. (see https://wiki.resolution.de/go/idpEndpoints) Error message: " + groupResponse.getMessage(), groupResponse.getCode(), groupResponse.getMessage(), groupResponse.getBody(), logger);
                return Collections.emptySet();
            }
            StructuredData groupData = groupResponse.getParsedJson();
            if (!groupData.isList()) {
                syncStatusFacade.fail("Group response is no list", logger);
                logger.warn("Unexpected group-data {}", (Object)groupData);
                return Collections.emptySet();
            }
            requiredGroupCheckerHolder.getLocalRequiredGroupChecker().ifPresent(requiredGroupChecker -> groupData.asList().stream().map(currentGroup -> {
                String id = currentGroup.findString(OKTA_ATTRIBUTE_ID);
                String name = currentGroup.findString("profile?.name");
                return new ConnectorGroup(id, name, JSONUtil.asJson(currentGroup));
            }).filter(requiredGroupChecker::isRequiredGroup).forEach(requiredConnectorGroups::add));
        } while ((nextPageUrl = OktaConnector.parseNextPageUrl(groupResponse)) != null && syncStatusFacade.isRunning());
        return requiredConnectorGroups;
    }

    @Nonnull
    public Set<ConnectorGroup> fetchGroupsForUser(@Nonnull String userIdentifier, @Nonnull SyncStatusFacade syncStatusFacade) throws HTTPRequestFailedException {
        ResponseWrapper groupResponse;
        HashSet<ConnectorGroup> groups2 = new HashSet<ConnectorGroup>();
        HttpUrl nextPageUrl = null;
        do {
            HttpUrl url;
            if (!(groupResponse = this.fetchGroupsPage(url = nextPageUrl == null ? this.getUsersUrlBase().addPathSegment(userIdentifier).addPathSegment(PATH_SEGMENT_GROUPS).addQueryParameter(PARAMETER_LIMIT, String.valueOf(((OktaConnectorConfiguration)this.configuration).getPageSize())).build() : nextPageUrl, syncStatusFacade)).isSuccess()) {
                throw new HTTPRequestFailedException(groupResponse);
            }
            groups2.addAll(OktaConnector.parseGroups(groupResponse.getParsedJson()));
        } while ((nextPageUrl = OktaConnector.parseNextPageUrl(groupResponse)) != null && syncStatusFacade.isRunning());
        return groups2;
    }

    @Nonnull
    private static Set<ConnectorGroup> parseGroups(@Nonnull StructuredData groupData) {
        if (groupData.isList()) {
            return groupData.asList().stream().map(group -> {
                String id = group.findString(OKTA_ATTRIBUTE_ID);
                String name = group.findString("profile.name");
                return new ConnectorGroup(id, name, JSONUtil.asJson(group));
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    @Nonnull
    public Class<OktaConnectorConfiguration> getConfigurationClass() {
        return OktaConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Okta";
    }

    @Override
    @Nonnull
    public List<String> getConnectorAttributes() {
        return CONNECTOR_ATTRIBUTES;
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public boolean isCanUseRequiredConnectorGroupsGroovy() {
        return true;
    }

    @Override
    public boolean isCanFetchRequiredConnectorGroups() {
        return true;
    }

    @Override
    protected String getAuthorizationHeaderValue() {
        return "SSWS " + ((OktaConnectorConfiguration)this.configuration).getApiToken();
    }

    @Override
    public List<ConnectionTestResultEntity.EndpointResult> doConnectionTest() {
        ArrayList<ConnectionTestResultEntity.EndpointResult> tests = new ArrayList<ConnectionTestResultEntity.EndpointResult>();
        SyncStatusFacade syncStatusFacade = SyncStatusFacade.nullFacade();
        tests.add(this.runSpecificConnectionTest(this.getUsersUrlBase().addQueryParameter(PARAMETER_LIMIT, "1").build(), syncStatusFacade, "Fetch User"));
        tests.add(this.runSpecificConnectionTest(this.getGroupsUrlBase().addQueryParameter(PARAMETER_LIMIT, "1").build(), syncStatusFacade, "Fetch Group"));
        return tests;
    }

    private ConnectionTestResultEntity.EndpointResult runSpecificConnectionTest(@Nonnull HttpUrl url, @Nonnull SyncStatusFacade syncStatusFacade, @Nonnull String testName) {
        ResponseWrapper userResp = this.performGetRequest(url, false, syncStatusFacade);
        return ConnectionTestResultEntity.EndpointResult.create(testName, url.toString(), userResp.getCode() == 200, String.valueOf(userResp.getCode()), userResp.getBody());
    }
}

