/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.atlascompat.factory;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.atlascompat.api.JiraPlatformApi;
import de.resolution.atlascompat.api.JiraServiceDeskApi;
import de.resolution.atlascompat.api.exception.AtlasCompatApiException;
import de.resolution.atlascompat.api.exception.AtlasCompatComponentException;
import de.resolution.atlascompat.factory.util.Version;
import de.resolution.atlascompat.jira73.JiraPlatform73Api;
import de.resolution.atlascompat.jira73.JiraServiceDesk33Api;
import de.resolution.atlascompat.jira8.JiraPlatform8Api;
import de.resolution.atlascompat.jira8.JiraServiceDesk4Api;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={AtlasCompatApiFactory.class})
@Component(value="AtlasCompatApiFactory")
public class AtlasCompatApiFactoryImpl
implements AtlasCompatApiFactory {
    private static final Logger logger = LoggerFactory.getLogger(AtlasCompatApiFactoryImpl.class);
    private final ApplicationProperties applicationProperties;

    @Autowired
    public AtlasCompatApiFactoryImpl(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        logger.info("atlas-compat starting up on {} platform", (Object)this.getPlatformApplicationDisplayName());
    }

    @Override
    public String getPlatformApplicationId() {
        return this.applicationProperties.getPlatformId();
    }

    @Override
    public String getPlatformApplicationDisplayName() {
        return this.applicationProperties.getDisplayName();
    }

    @Override
    public String getPlatformApplicationVersion() {
        return this.applicationProperties.getVersion();
    }

    private Version getPlatformApplicationVersionObj() {
        return Version.of(this.applicationProperties.getVersion());
    }

    @Override
    public boolean isJiraPlatform() {
        return this.applicationProperties.getPlatformId().equals("jira");
    }

    @Override
    public boolean isConfluencePlatform() {
        return this.applicationProperties.getPlatformId().equals("conf");
    }

    @Override
    public boolean isBitbucketPlatform() {
        String platformId = this.applicationProperties.getPlatformId();
        return platformId.equals("stash") || platformId.equals("bitbucket");
    }

    @Override
    public boolean isBambooPlatform() {
        return this.applicationProperties.getPlatformId().equals("bamboo");
    }

    @Override
    public boolean isFecruPlatform() {
        return this.applicationProperties.getPlatformId().equals("fisheye");
    }

    @Override
    public Optional<JiraPlatformApi> getJiraPlatformApi() {
        if (!this.isJiraPlatform()) {
            logger.warn("I'm not a Jira. Not giving out Platform Compat API");
            return Optional.empty();
        }
        Version jiraVersionObj = this.getPlatformApplicationVersionObj();
        try {
            if (jiraVersionObj.getMajorVersion() == 7) {
                if (jiraVersionObj.getMinorVersion() < 3) {
                    logger.warn("Jira version < 7.3 is no longer supported");
                    return Optional.empty();
                }
                return Optional.of(new JiraPlatform73Api());
            }
            if (jiraVersionObj.getMajorVersion() == 8 || jiraVersionObj.getMajorVersion() == 9) {
                return Optional.of(new JiraPlatform8Api());
            }
            logger.warn("Incompatible Jira Platform major version {}", (Object)jiraVersionObj);
            return Optional.empty();
        }
        catch (AtlasCompatComponentException e) {
            logger.warn("Jira Platform components are not ready or not installed.");
            return Optional.empty();
        }
        catch (AtlasCompatApiException e) {
            logger.warn("Unkown error initializing Jira Platform API.");
            return Optional.empty();
        }
    }

    @Override
    public Optional<JiraServiceDeskApi> getJiraServiceDeskApi() {
        Optional<JiraPlatformApi> jiraPlatformApi = this.getJiraPlatformApi();
        if (!jiraPlatformApi.isPresent()) {
            logger.warn("Jira Platform Compat API could not be loaded to check for Service Desk Presence.");
            return Optional.empty();
        }
        Version serviceDeskVersionObj = null;
        try {
            Optional<String> serviceDeskVersionOpt = jiraPlatformApi.get().getApplicationVersion("jira-servicedesk");
            if (!serviceDeskVersionOpt.isPresent()) {
                logger.debug("Jira Service Desk Compat API could not be loaded since Service Desk is currently not installed or loaded.");
                return Optional.empty();
            }
            serviceDeskVersionObj = Version.of(serviceDeskVersionOpt.get());
        }
        catch (AtlasCompatApiException e) {
            logger.debug("Jira Service Desk Compat API could not be loaded since application version could not be queried.");
            return Optional.empty();
        }
        try {
            if (serviceDeskVersionObj.getMajorVersion() == 3) {
                if (serviceDeskVersionObj.getMinorVersion() < 3) {
                    logger.debug("Jira Servicedesk < 3.3 is no longer supported");
                    return Optional.empty();
                }
                return Optional.of(new JiraServiceDesk33Api());
            }
            if (serviceDeskVersionObj.getMajorVersion() == 4 || serviceDeskVersionObj.getMajorVersion() == 5) {
                return Optional.of(new JiraServiceDesk4Api());
            }
            logger.warn("Incompatible Jira Service Desk version {}", (Object)serviceDeskVersionObj);
            return Optional.empty();
        }
        catch (AtlasCompatComponentException e) {
            logger.debug("Jira Service Desk components are not ready or not installed.");
            return Optional.empty();
        }
        catch (AtlasCompatApiException e) {
            logger.warn("Unknown error initializing Jira Service Desk API.");
            return Optional.empty();
        }
    }
}

